/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.workspace;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.m2e.workspace.WorkspaceState;

public class MutableWorkspaceState {
    private final Properties state = new Properties(WorkspaceState.getState());

    public void putPom(File pom, String groupId, String artifactId, String version) {
        String key = String.valueOf(groupId) + ":" + artifactId + ":pom::" + version;
        this.state.put(key, pom.getAbsolutePath());
    }

    public void putArtifact(File artifact, String groupId, String artifactId, String extension, String classifier, String version) {
        if (classifier == null) {
            classifier = "";
        }
        String key = String.valueOf(groupId) + ":" + artifactId + ":" + extension + ":" + classifier + ":" + version;
        this.state.put(key, artifact.getAbsolutePath());
    }

    public void store(File file) throws IOException {
        File dir = file.getParentFile();
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new IOException("Could not create directory " + dir);
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            this.store(os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void store(OutputStream os) throws IOException {
        this.state.store(os, null);
    }
}

