/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder.plexusbuildapi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.sonatype.plexus.build.incremental.BuildContext;

public class ChangedFileOutputStream
extends OutputStream {
    private final File file;
    private final BuildContext buildContext;
    private final OutputStream os;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public ChangedFileOutputStream(File file) throws FileNotFoundException {
        this(file, null);
    }

    public ChangedFileOutputStream(File file, BuildContext buildContext) throws FileNotFoundException {
        this.file = file;
        this.buildContext = buildContext;
        this.os = new BufferedOutputStream(new FileOutputStream(file));
    }

    @Override
    public void write(int b) {
        this.buffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.buffer.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        try {
            this.writeIfNewOrChanged();
        }
        finally {
            this.os.close();
        }
    }

    protected void writeIfNewOrChanged() throws IOException {
        byte[] bytes = this.buffer.toByteArray();
        boolean needToWrite = false;
        if (this.file.exists()) {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.file));
            try {
                int i = 0;
                while (i < bytes.length) {
                    if (bytes[i] != is.read()) {
                        needToWrite = true;
                    }
                    ++i;
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            needToWrite = true;
        }
        if (needToWrite) {
            if (this.buildContext != null) {
                this.buildContext.refresh(this.file);
            }
            this.os.write(bytes);
        }
    }
}

