/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.fx.core.RankedService;
import org.eclipse.fx.core.ServiceUtils;
import org.eclipse.fx.core.SystemUtils;
import org.eclipse.fx.core.ValueSerializer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component
public class DefaultValueSerializer
implements ValueSerializer,
RankedService {
    private final Map<Class<?>, TwoVal<?>> mappings = new HashMap();

    public DefaultValueSerializer() {
        this.mappings.put(Instant.class, new TwoVal<Instant>(Instant::parse, v -> v.toString()));
        this.mappings.put(LocalDate.class, new TwoVal<LocalDate>(LocalDate::parse, v -> v.toString()));
        this.mappings.put(LocalDateTime.class, new TwoVal<LocalDateTime>(LocalDateTime::parse, v -> v.toString()));
        this.mappings.put(LocalTime.class, new TwoVal<LocalTime>(LocalTime::parse, v -> v.toString()));
        this.mappings.put(OffsetDateTime.class, new TwoVal<OffsetDateTime>(OffsetDateTime::parse, v -> v.toString()));
        this.mappings.put(OffsetTime.class, new TwoVal<OffsetTime>(OffsetTime::parse, v -> v.toString()));
        this.mappings.put(Year.class, new TwoVal<Year>(Year::parse, v -> v.toString()));
        this.mappings.put(YearMonth.class, new TwoVal<YearMonth>(YearMonth::parse, v -> v.toString()));
        this.mappings.put(ZonedDateTime.class, new TwoVal<ZonedDateTime>(ZonedDateTime::parse, v -> v.toString()));
        this.mappings.put(Boolean.class, new TwoVal<Boolean>(Boolean::valueOf, v -> v.toString()));
        this.mappings.put(Boolean.TYPE, new TwoVal<Boolean>(Boolean::valueOf, v -> v.toString()));
        this.mappings.put(Short.class, new TwoVal<Short>(Short::valueOf, v -> v.toString()));
        this.mappings.put(Short.TYPE, new TwoVal<Short>(Short::valueOf, v -> v.toString()));
        this.mappings.put(Integer.class, new TwoVal<Integer>(Integer::valueOf, v -> v.toString()));
        this.mappings.put(Integer.TYPE, new TwoVal<Integer>(Integer::valueOf, v -> v.toString()));
        this.mappings.put(Long.class, new TwoVal<Long>(Long::valueOf, v -> v.toString()));
        this.mappings.put(Long.TYPE, new TwoVal<Long>(Long::valueOf, v -> v.toString()));
        this.mappings.put(Double.class, new TwoVal<Double>(Double::valueOf, v -> v.toString()));
        this.mappings.put(Double.TYPE, new TwoVal<Double>(Double::valueOf, v -> v.toString()));
        this.mappings.put(Float.class, new TwoVal<Float>(Float::valueOf, v -> v.toString()));
        this.mappings.put(Float.TYPE, new TwoVal<Float>(Float::valueOf, v -> v.toString()));
        this.mappings.put(BigDecimal.class, new TwoVal<BigDecimal>(BigDecimal::new, v -> v.toString()));
        this.mappings.put(BigInteger.class, new TwoVal<BigInteger>(BigInteger::new, v -> v.toString()));
        this.mappings.put(Date.class, new TwoVal<Date>(s -> Date.from(Instant.parse(s)), v -> v.toInstant().toString()));
        this.mappings.put(Calendar.class, new TwoVal<Calendar>(s -> {
            Calendar.Builder b = new Calendar.Builder();
            b.setInstant(Date.from(Instant.parse(s)));
            return b.build();
        }, v -> v.toInstant().toString()));
        if (!SystemUtils.isOsgiEnv()) {
            Map<Class, TwoVal> collect = ServiceUtils.getServiceList(ValueSerializer.ValueSerializeProvider.class).stream().collect(Collectors.toMap(p -> p.getType(), p -> new TwoVal<Object>(p::fromString, p::toString)));
            this.mappings.putAll(collect);
        }
    }

    @Override
    public int getRanking() {
        return 0;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    public <T> void registerProvider(ValueSerializer.ValueSerializeProvider<T> p) {
        this.mappings.put(p.getType(), new TwoVal<Object>(p, p::fromString, p::toString));
    }

    public void unregisterProvider(ValueSerializer.ValueSerializeProvider<?> p) {
        TwoVal<?> val = this.mappings.remove(p.getType());
        if (val != null && val.owner != p) {
            this.mappings.remove(p.getType(), val);
        }
    }

    @Override
    public boolean test(Class<?> t) {
        return this.mappings.containsKey(t);
    }

    @Override
    public <O> O fromString(Class<O> clazz, String value) {
        if (!this.test(clazz)) {
            throw new IllegalArgumentException("The type '" + String.valueOf(clazz) + "' is not supported");
        }
        return (O)this.mappings.get(clazz).fromString.apply(value);
    }

    @Override
    public String toString(Object o) {
        Function<Object, String> toString = this.mappings.get(o.getClass()).toString;
        return toString.apply(o);
    }

    static class TwoVal<T> {
        final @Nullable Object owner;
        final @NonNull Function<@NonNull String, @NonNull T> fromString;
        final @NonNull Function<@NonNull T, @NonNull String> toString;

        public TwoVal(@NonNull Function<@NonNull String, @NonNull T> fromString, @NonNull Function<@NonNull T, @NonNull String> toString) {
            this(null, fromString, toString);
        }

        public TwoVal(Object owner, @NonNull Function<@NonNull String, @NonNull T> fromString, @NonNull Function<@NonNull T, @NonNull String> toString) {
            this.owner = owner;
            this.fromString = fromString;
            this.toString = toString;
        }
    }
}

