/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.contentassist;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.geometry.Point2D;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.text.SourceTextEditActions;
import org.eclipse.fx.core.text.TextEditAction;
import org.eclipse.fx.text.ui.ITextViewer;
import org.eclipse.fx.text.ui.contentassist.ContentAssistContextData;
import org.eclipse.fx.text.ui.contentassist.ContentProposalPopup;
import org.eclipse.fx.text.ui.contentassist.ContextInformationPopup;
import org.eclipse.fx.text.ui.contentassist.ICompletionProposal;
import org.eclipse.fx.text.ui.contentassist.IContentAssistant;
import org.eclipse.fx.text.ui.contentassist.IContextInformation;
import org.eclipse.fx.text.ui.contentassist.IContextInformationValidator;
import org.eclipse.fx.text.ui.contentassist.LazyInitReference;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.TextSelection;
import org.eclipse.fx.ui.controls.styledtext.TriggerActionMapping;
import org.eclipse.jface.text.IDocument;

public class ContentAssistant
implements IContentAssistant {
    private final Function<ContentAssistContextData, List<ICompletionProposal>> proposalComputer;
    private ITextViewer fViewer;
    private ContextInformationPopup fContextInfoPopup;
    private final ThreadSynchronize threadSynchnronize;
    private final IContextInformationValidator validator;
    private boolean directlyApplySingleMatch;
    private LazyInitReference<ContentProposalPopup> fProposalPopup = new LazyInitReference();

    public ContentAssistant(IContextInformationValidator validator, ThreadSynchronize threadSynchnronize, Function<ContentAssistContextData, List<ICompletionProposal>> proposalComputer) {
        this.validator = validator;
        this.threadSynchnronize = threadSynchnronize;
        this.proposalComputer = proposalComputer;
    }

    @Override
    public void configureWindowSize(Supplier<Point2D> windowSizeRetriever, Consumer<Point2D> windowSizePersister) {
        this.fProposalPopup.init(r -> r.configureWindowSize(windowSizeRetriever, windowSizePersister));
    }

    public void setDirectlyApplySingleMatch(boolean directlyApplySingleMatch) {
        this.directlyApplySingleMatch = directlyApplySingleMatch;
    }

    @Override
    public void install(ITextViewer textViewer) {
        if (this.fViewer == null) {
            this.fViewer = textViewer;
            this.fProposalPopup.setFactory(() -> new ContentProposalPopup(this.threadSynchnronize, this, textViewer, this.proposalComputer));
            this.fViewer.subscribeAction(this::handleAction);
            this.fContextInfoPopup = new ContextInformationPopup(this.validator, textViewer);
        }
    }

    private boolean handleAction(TextEditAction action, TriggerActionMapping.Context context) {
        if (action == SourceTextEditActions.PROPOSAL_REQUEST) {
            int offset = this.fViewer.getTextWidget().getCaretOffset();
            List<ICompletionProposal> proposals = this.proposalComputer.apply(new ContentAssistContextData(offset, this.fViewer.getDocument()));
            if (proposals.size() == 1 && this.directlyApplySingleMatch) {
                ICompletionProposal completionProposal = proposals.get(0);
                completionProposal.apply(this.fViewer.getDocument());
                this.showContextInformation(completionProposal.getContextInformation(), offset);
            } else if (!proposals.isEmpty()) {
                Point2D p = this.fViewer.getTextWidget().getLocationAtOffset(this.fViewer.getTextWidget().getCaretOffset(), StyledTextArea.LineLocation.BELOW);
                Point2D coords = this.fViewer.getTextWidget().localToScreen(p);
                Optional<ICompletionProposal> chosenProposal = this.fProposalPopup.get().displayProposals(proposals, this.fViewer.getTextWidget().getCaretOffset(), coords);
                chosenProposal.ifPresent(proposal -> {
                    IDocument document = this.fViewer.getDocument();
                    proposal.apply(document);
                    TextSelection selection = proposal.getSelection(document);
                    if (selection.length > 0) {
                        this.fViewer.getTextWidget().setCaretOffset(selection.offset + selection.length);
                    }
                    this.fViewer.getTextWidget().setSelection(selection);
                    if (proposal.getContextInformation() != null) {
                        this.showContextInformation(proposal.getContextInformation(), this.fViewer.getTextWidget().getCaretOffset());
                    }
                });
            }
            this.fViewer.getTextWidget().layout();
            return true;
        }
        return false;
    }

    void showContextInformation(IContextInformation contextInformation, int offset) {
        if (this.fContextInfoPopup != null) {
            this.fContextInfoPopup.showContextInformation(contextInformation, offset);
        }
    }

    @Override
    public void showContextInformation(IContextInformation info) {
        if (this.fContextInfoPopup != null) {
            this.fContextInfoPopup.showContextInformation(info, info.getContextInformationPosition());
        }
    }
}

