/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.tokens;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenUtil;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.diagnostic.ITokenDiagnosticProvider;
import org.eclipse.xtext.serializer.tokens.IValueSerializer;
import org.eclipse.xtext.xtext.RuleNames;

public class ValueSerializer
implements IValueSerializer {
    @Inject
    private IValueConverterService converter;
    @Inject
    private RuleNames ruleNames;
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    protected ITokenDiagnosticProvider diagnostics;
    @Inject
    protected TokenUtil tokenUtil;

    @Override
    public boolean isValid(EObject context, RuleCall ruleCall, Object value, ISerializationDiagnostic.Acceptor errors) {
        try {
            String str = this.converter.toString(value, this.ruleNames.getQualifiedName(ruleCall.getRule()));
            if (str != null) {
                return true;
            }
            if (errors != null) {
                errors.accept(this.diagnostics.getNullNotAllowedDiagnostic(context, ruleCall));
            }
            return false;
        }
        catch (Throwable e) {
            if (errors != null) {
                errors.accept(this.diagnostics.getValueConversionExceptionDiagnostic(context, ruleCall, value, e));
            }
            return false;
        }
    }

    @Override
    public String serializeAssignedValue(EObject context, RuleCall ruleCall, Object value, INode node, ISerializationDiagnostic.Acceptor errors) {
        Object converted;
        AbstractRule nodeRule;
        AbstractRule rule = ruleCall.getRule();
        String ruleName = this.ruleNames.getQualifiedName(rule);
        if (node != null && (nodeRule = this.linkingHelper.getRuleFrom(node.getGrammarElement())) != null && this.ruleNames.getQualifiedName(nodeRule).equals(ruleName) && (converted = this.converter.toValue(NodeModelUtils.getTokenText(node), ruleName, node)) != null && converted.equals(value)) {
            return this.tokenUtil.serializeNode(node);
        }
        try {
            String str = this.converter.toString(value, ruleName);
            if (str != null) {
                return str;
            }
            if (errors != null) {
                errors.accept(this.diagnostics.getNullNotAllowedDiagnostic(context, ruleCall));
            }
            return null;
        }
        catch (Throwable e) {
            if (errors != null) {
                errors.accept(this.diagnostics.getValueConversionExceptionDiagnostic(context, ruleCall, value, e));
            }
            return null;
        }
    }
}

