/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextBoundsType;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.Util;
import org.eclipse.fx.ui.controls.styledtext.DecorationStrategyFactory;
import org.eclipse.fx.ui.controls.styledtext.internal.ReuseCache;
import org.eclipse.fx.ui.controls.styledtext.model.DecorationStrategy;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TextNode
extends HBox {
    private static final @NonNull CssMetaData<TextNode, @NonNull Paint> FILL = new CssMetaData<TextNode, Paint>("-fx-fill", StyleConverter.getPaintConverter(), (Paint)Color.BLACK){

        public boolean isSettable(TextNode styleable) {
            return !styleable.fillProperty().isBound();
        }

        public StyleableProperty<@NonNull Paint> getStyleableProperty(TextNode styleable) {
            return (StyleableProperty)styleable.fill;
        }
    };
    final @NonNull ObjectProperty<@NonNull Paint> fill = new SimpleStyleableObjectProperty(FILL, (Object)this, "fill", (Object)Color.BLACK);
    private static String[] BASIC_STRING_CACHE = new String[256];
    private static final @NonNull DecorationStyleConverter CONVERTER = new DecorationStyleConverter();
    private static final @NonNull CssMetaData<TextNode, @Nullable DecorationStrategy> DECORATIONSTRATEGY = new CssMetaData<TextNode, DecorationStrategy>("-efx-decoration", (StyleConverter)CONVERTER, null){

        public boolean isSettable(TextNode node) {
            return !node.decorationStrategyProperty().isBound();
        }

        public StyleableProperty<@Nullable DecorationStrategy> getStyleableProperty(TextNode node) {
            return (StyleableProperty)node.decorationStrategyProperty();
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
    private @NonNull ObjectProperty<@Nullable DecorationStrategy> decorationStrategy = new SimpleStyleableObjectProperty(DECORATIONSTRATEGY, (Object)this, "decorationStrategy");
    private int startOffset;
    private List<Integer> tabPositions = new ArrayList<Integer>();
    private String originalText;
    private List<Text> activeLetters = new ArrayList<Text>();
    private ReuseCache<Text> cache;
    private final IntegerProperty tabCharAdvance;

    static {
        ArrayList<Object> styleables = new ArrayList<Object>(Region.getClassCssMetaData());
        styleables.add(DECORATIONSTRATEGY);
        styleables.add(FILL);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    private static String toString(char c) {
        String rv = null;
        if (c < BASIC_STRING_CACHE.length && (rv = BASIC_STRING_CACHE[c]) == null) {
            TextNode.BASIC_STRING_CACHE[c] = String.valueOf(c);
        }
        if (rv == null) {
            rv = String.valueOf(c);
        }
        return rv;
    }

    public final @NonNull ObjectProperty<@NonNull Paint> fillProperty() {
        return this.fill;
    }

    public final @NonNull Paint getFill() {
        return (Paint)this.fillProperty().get();
    }

    public final void setFill(@NonNull Paint color) {
        this.fillProperty().set((Object)color);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TextNode.getClassCssMetaData();
    }

    public final @NonNull ObjectProperty<@Nullable DecorationStrategy> decorationStrategyProperty() {
        return this.decorationStrategy;
    }

    public final @Nullable DecorationStrategy getDecorationStrategy() {
        return (DecorationStrategy)this.decorationStrategyProperty().get();
    }

    public final void setDecorationStrategy(@Nullable DecorationStrategy strategy) {
        this.decorationStrategyProperty().set((Object)strategy);
    }

    public TextNode(String text, IntegerProperty tabCharAdvance) {
        this.tabCharAdvance = tabCharAdvance;
        this.setAlignment(Pos.CENTER_LEFT);
        this.setMinWidth(-1.0);
        this.cache = new ReuseCache<Text>(() -> {
            Text letter = new Text();
            letter.setBoundsType(TextBoundsType.LOGICAL_VERTICAL_CENTER);
            return letter;
        });
        this.cache.addOnActivate(node -> this.getChildren().add(node));
        this.cache.addOnRelease(node -> this.getChildren().remove(node));
        this.getStyleClass().add((Object)"styled-text-node");
        this.originalText = text;
        this.rebuildText(text);
        InvalidationListener listener = o -> this.rebuildText(this.originalText);
        this.parentProperty().addListener(e -> {
            if (this.getParent() == null) {
                this.tabCharAdvance.removeListener(listener);
            } else {
                this.tabCharAdvance.addListener(listener);
            }
        });
        this.cache.addOnActivate(n -> n.fillProperty().bind(this.fillProperty()));
        this.cache.addOnRelease(n -> n.fillProperty().unbind());
        this.decorationStrategy.addListener(this::handleDecorationChange);
    }

    public Subscription setStyledRange(String clazz, int start, int end) {
        return null;
    }

    public void updateText(String text) {
        this.rebuildText(text);
        this.originalText = text;
    }

    private void rebuildText(String text) {
        for (Text t : this.activeLetters) {
            this.cache.releaseElement(t);
        }
        this.activeLetters.clear();
        char[] cArray = this.processText(text).toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            Text textNode = this.cache.getElement();
            textNode.setText(TextNode.toString(c));
            this.activeLetters.add(textNode);
            ++n2;
        }
    }

    private String processText(String text) {
        String tmp = text;
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.tabCharAdvance.get()) {
            b.append(" ");
            ++i;
        }
        int position = -1;
        this.tabPositions.clear();
        while ((position = tmp.indexOf(9)) != -1) {
            tmp = tmp.replaceFirst("\t", b.toString());
            this.tabPositions.add(position);
        }
        return tmp;
    }

    private void handleDecorationChange(ObservableValue<? extends DecorationStrategy> observable, DecorationStrategy oldValue, DecorationStrategy newValue) {
        if (oldValue != null) {
            oldValue.unattach((Pane)this, this);
        }
        if (newValue != null) {
            newValue.attach((Pane)this, this);
        }
    }

    void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    @Deprecated
    public int getStartOffset() {
        return this.startOffset;
    }

    @Deprecated
    public int getEndOffset() {
        return this.startOffset + this.getText().length();
    }

    public boolean intersectOffset(int start, int end) {
        if (this.getStartOffset() > end) {
            return false;
        }
        return this.getEndOffset() >= start;
    }

    public String toString() {
        return "'" + this.originalText + "'";
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public String getText() {
        return this.originalText;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        DecorationStrategy decorationStrategy2 = (DecorationStrategy)this.decorationStrategy.get();
        if (decorationStrategy2 != null) {
            decorationStrategy2.layout((Pane)this, this);
        }
    }

    public int getCaretIndexAtPoint(Point2D point) {
        Point2D local = this.sceneToLocal(this.localToScene(point));
        Optional<Node> charNode = this.getChildren().stream().filter(n -> n.getBoundsInParent().contains(local)).findFirst();
        if (charNode.isPresent()) {
            Node node = charNode.get();
            int idx = this.getChildren().indexOf((Object)node);
            Bounds bounds = node.getBoundsInParent();
            if (bounds.getMinX() + bounds.getWidth() / 2.0 < local.getX()) {
                ++idx;
            }
            int toRemove = 0;
            for (Integer i : this.tabPositions) {
                if (i <= idx && idx < i + this.tabCharAdvance.get()) {
                    toRemove += idx - i;
                    if ((idx - i) % this.tabCharAdvance.get() < this.tabCharAdvance.get() / 2) break;
                    ++idx;
                    break;
                }
                if (i >= idx) continue;
                toRemove += this.tabCharAdvance.get() - 1;
            }
            return idx -= toRemove;
        }
        return -1;
    }

    public double getCharLocation(int index) {
        int realIndex = index;
        for (Integer i : this.tabPositions) {
            if (i >= realIndex) continue;
            realIndex += this.tabCharAdvance.get() - 1;
        }
        if (realIndex >= 0 && realIndex < this.getChildren().size()) {
            return this.localToParent(((Node)this.getChildren().get(realIndex)).getBoundsInParent()).getMinX();
        }
        if (!this.getChildren().isEmpty()) {
            return this.localToParent(((Node)this.getChildren().get(this.getChildren().size() - 1)).getBoundsInParent()).getMaxX();
        }
        return 0.0;
    }

    static class DecorationStyleConverter
    extends StyleConverter<ParsedValue<?, DecorationStrategy>, DecorationStrategy> {
        private static Map<String, DecorationStrategyFactory> FACTORIES;

        DecorationStyleConverter() {
        }

        public DecorationStrategy convert(ParsedValue<ParsedValue<?, DecorationStrategy>, DecorationStrategy> value, Font font) {
            String type;
            DecorationStrategyFactory strategy;
            String definition = "" + value.getValue();
            if (FACTORIES == null) {
                FACTORIES = Util.lookupServiceList(((Object)((Object)this)).getClass(), DecorationStrategyFactory.class).stream().sorted((f1, f2) -> -1 * Integer.compare(f1.getRanking(), f2.getRanking())).collect(Collectors.toMap(f -> f.getDecorationStrategyName(), f -> f));
            }
            if ((strategy = FACTORIES.get(type = definition.contains("(") ? definition.substring(0, definition.indexOf(40)) : String.valueOf(definition))) != null) {
                return strategy.create(definition.contains("(") ? definition.substring(definition.indexOf(40) + 1, definition.lastIndexOf(41)) : null);
            }
            return null;
        }
    }
}

