/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.trace;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.xtext.generator.trace.AbstractStatefulTraceRegion;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.generator.trace.SourceRelativeURI;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegionWithLineInformation;

public class TraceRegion
extends AbstractStatefulTraceRegion {
    public TraceRegion(int myOffset, int myLength, int myLineNumber, int myEndLineNumber, boolean useForDebugging, int associatedOffset, int associatedLength, int associatedLineNumber, int associatedEndLineNumber, AbstractTraceRegion parent, SourceRelativeURI associatedPath) {
        this(myOffset, myLength, myLineNumber, myEndLineNumber, useForDebugging, new LocationData(associatedOffset, associatedLength, associatedLineNumber, associatedEndLineNumber, associatedPath), parent);
    }

    public TraceRegion(int myOffset, int myLength, int myLineNumber, int myEndLineNumber, boolean useForDebugging, ILocationData locationData, AbstractTraceRegion parent) {
        super((ITextRegionWithLineInformation)new TextRegionWithLineInformation(myOffset, myLength, myLineNumber, myEndLineNumber), useForDebugging, locationData, parent);
        if (myOffset == myLength && myOffset == 0) {
            throw new IllegalArgumentException();
        }
        if (parent == null ? locationData.getSrcRelativePath() == null : parent.getAssociatedSrcRelativePath() == null && locationData.getSrcRelativePath() == null) {
            throw new IllegalArgumentException("associatedPath may not be null");
        }
    }

    public TraceRegion(int myOffset, int myLength, int myLineNumber, int myEndLineNumber, boolean useForDebugging, List<ILocationData> allLocationData, AbstractTraceRegion parent) {
        super((ITextRegionWithLineInformation)new TextRegionWithLineInformation(myOffset, myLength, myLineNumber, myEndLineNumber), useForDebugging, Lists.newArrayList(allLocationData), parent);
        if (parent == null) {
            for (ILocationData locationData : allLocationData) {
                if (locationData.getSrcRelativePath() != null) continue;
                throw new IllegalArgumentException("associatedPath may not be null");
            }
        } else {
            boolean nullSeen = false;
            boolean notNullSeen = false;
            for (ILocationData locationData : allLocationData) {
                if (locationData.getSrcRelativePath() == null) {
                    nullSeen = true;
                } else {
                    notNullSeen = true;
                }
                if (!nullSeen || !notNullSeen) continue;
                throw new IllegalArgumentException("list of locations is inconsistent");
            }
            if (parent.getAssociatedSrcRelativePath() == null && nullSeen) {
                throw new IllegalArgumentException("list of locations is inconsistent with parent");
            }
        }
    }
}

