/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.paint;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import org.eclipse.fx.ui.controls.paint.Messages;
import org.eclipse.fx.ui.panes.GridData;
import org.eclipse.fx.ui.panes.GridLayoutPane;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class PaintEditor
extends StackPane {
    private static final int PREVIEW_SIZE = 200;
    static final @NonNull DecimalFormat FORMAT = new DecimalFormat("0.0#");
    private ObjectProperty<BiConsumer<@NonNull State, @Nullable Paint>> stateConsumer = new SimpleObjectProperty();
    private final @NonNull TabPane paintTabFolder;
    private @Nullable Rectangle linearGradientPreview;
    private @Nullable Rectangle radialGradientPreview;
    private @Nullable Rectangle solidPreview;
    private final @NonNull ReadOnlyObjectWrapper<@Nullable Paint> paint = new ReadOnlyObjectWrapper();

    public PaintEditor(@Nullable Paint defaultPaint, State ... states) {
        Button b;
        this.paint.set((Object)defaultPaint);
        List<State> asList = Arrays.asList(states);
        BorderPane pane = new BorderPane();
        this.paintTabFolder = new TabPane();
        this.paintTabFolder.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        Tab solid = this.createColorTab();
        Tab linear = this.createLinearTab();
        Tab radial = this.createRadialTab();
        this.paintTabFolder.getTabs().addAll((Object[])new Tab[]{solid, linear, radial});
        pane.setCenter((Node)this.paintTabFolder);
        GridLayoutPane gl = new GridLayoutPane();
        gl.setNumColumns(1);
        GridLayoutPane buttons = new GridLayoutPane();
        buttons.setMakeColumnsEqualWidth(true);
        buttons.setNumColumns(states.length == 0 ? 3 : states.length);
        if (asList.isEmpty() || asList.contains((Object)State.APPLY)) {
            b = new Button(Messages.getString("PaintEditor.Apply"));
            b.setOnAction(this::handleApply);
            buttons.getChildren().add((Object)b);
            GridLayoutPane.setConstraint((Node)b, (GridData)new GridData(GridData.Alignment.FILL, GridData.Alignment.CENTER, false, false));
        }
        if (asList.isEmpty() || asList.contains((Object)State.OK)) {
            b = new Button(Messages.getString("PaintEditor.Ok"));
            b.setOnAction(this::handleOk);
            buttons.getChildren().add((Object)b);
            GridLayoutPane.setConstraint((Node)b, (GridData)new GridData(GridData.Alignment.FILL, GridData.Alignment.CENTER, false, false));
        }
        if (asList.isEmpty() || asList.contains((Object)State.CANCEL)) {
            b = new Button(Messages.getString("PaintEditor.Cancel"));
            b.setOnAction(this::handleCancel);
            buttons.getChildren().add((Object)b);
            GridLayoutPane.setConstraint((Node)b, (GridData)new GridData(GridData.Alignment.FILL, GridData.Alignment.CENTER, false, false));
        }
        GridLayoutPane.setConstraint((Node)buttons, (GridData)new GridData(GridData.Alignment.END, GridData.Alignment.CENTER, true, false));
        gl.getChildren().add((Object)buttons);
        pane.setBottom((Node)gl);
        this.getChildren().add((Object)pane);
        if (defaultPaint instanceof LinearGradient) {
            this.paintTabFolder.getSelectionModel().select((Object)linear);
        } else if (defaultPaint instanceof RadialGradient) {
            this.paintTabFolder.getSelectionModel().select((Object)radial);
        } else {
            this.paintTabFolder.getSelectionModel().select((Object)solid);
        }
        this.paint.set((Object)defaultPaint);
        this.paintTabFolder.getSelectionModel().selectedItemProperty().addListener((o, oldTab, newTab) -> {
            Rectangle t = null;
            t = newTab == linear ? this.linearGradientPreview : (newTab == radial ? this.radialGradientPreview : this.solidPreview);
            if (t != null) {
                this.paint.set((Object)t.getFill());
            } else {
                this.paint.set(null);
            }
        });
    }

    public @Nullable Paint getPaint() {
        return (Paint)this.paint.get();
    }

    public @NonNull ReadOnlyObjectProperty<@Nullable Paint> getPaintProperty() {
        return this.paint.getReadOnlyProperty();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void handleApply(ActionEvent e) {
        @NonNull @Nullable BiConsumer consumer = (BiConsumer)this.stateConsumer.get();
        if (consumer != null) {
            consumer.accept(State.APPLY, this.getPaint());
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void handleOk(ActionEvent e) {
        @NonNull @Nullable BiConsumer consumer = (BiConsumer)this.stateConsumer.get();
        if (consumer != null) {
            consumer.accept(State.OK, this.getPaint());
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void handleCancel(ActionEvent e) {
        @NonNull @Nullable BiConsumer consumer = (BiConsumer)this.stateConsumer.get();
        if (consumer != null) {
            consumer.accept(State.CANCEL, null);
        }
    }

    public void setStateConsumer(BiConsumer<@NonNull State, @Nullable Paint> stateConsumer) {
        this.stateConsumer.set(stateConsumer);
    }

    public BiConsumer<@NonNull State, @Nullable Paint> getStateConsumer() {
        return (BiConsumer)this.stateConsumer.get();
    }

    private Tab createColorTab() {
        Rectangle solidPreview;
        Tab t = new Tab();
        t.setText(Messages.getString("PaintEditor.Color"));
        GridLayoutPane p = new GridLayoutPane();
        p.setNumColumns(3);
        this.solidPreview = solidPreview = new Rectangle(200.0, 200.0);
        GridLayoutPane dataPane = new GridLayoutPane();
        dataPane.setNumColumns(2);
        ColorPicker picker = new ColorPicker();
        picker.valueProperty().addListener(o -> {
            solidPreview.setFill((Paint)picker.getValue());
            this.paint.set((Object)((Paint)picker.getValue()));
        });
        dataPane.getChildren().addAll((Object[])new Node[]{new Label(Messages.getString("PaintEditor.Color")), picker});
        Color color = (Color)this.paint.get();
        if (color instanceof Color) {
            picker.setValue((Object)color);
        }
        TitledPane dtp = new TitledPane(Messages.getString("PaintEditor.Data"), (Node)dataPane);
        dtp.setCollapsible(false);
        TitledPane pane = new TitledPane(Messages.getString("PaintEditor.Preview"), (Node)solidPreview);
        pane.setCollapsible(false);
        GridLayoutPane.setConstraint((Node)dtp, (GridData)new GridData(GridData.Alignment.FILL, GridData.Alignment.FILL, true, true));
        GridLayoutPane.setConstraint((Node)pane, (GridData)new GridData(GridData.Alignment.BEGINNING, GridData.Alignment.BEGINNING, false, false));
        p.getChildren().addAll((Object[])new Node[]{pane, dtp});
        t.setContent((Node)p);
        return t;
    }

    private Tab createLinearTab() {
        Rectangle linearGradientPreview;
        Tab t = new Tab();
        t.setText(Messages.getString("PaintEditor.LinearGradient"));
        GridLayoutPane p = new GridLayoutPane();
        p.setNumColumns(3);
        this.linearGradientPreview = linearGradientPreview = new Rectangle(200.0, 200.0);
        TextField startX = new TextField();
        TextField startY = new TextField();
        TextField endX = new TextField();
        TextField endY = new TextField();
        CheckBox proportional = new CheckBox();
        ChoiceBox cycleMethod = new ChoiceBox(FXCollections.observableArrayList((Object[])CycleMethod.values()));
        GridLayoutPane dataPane = new GridLayoutPane();
        dataPane.setNumColumns(2);
        dataPane.getChildren().addAll((Object[])new Node[]{new Label(Messages.getString("PaintEditor.StartX")), startX});
        dataPane.getChildren().addAll((Object[])new Node[]{new Label(Messages.getString("PaintEditor.StartY")), startY});
        dataPane.getChildren().addAll((Object[])new Node[]{new Label(Messages.getString("PaintEditor.EndX")), endX});
        dataPane.getChildren().addAll((Object[])new Node[]{new Label(Messages.getString("PaintEditor.EndY")), endY});
        dataPane.getChildren().addAll((Object[])new Node[]{new Label(Messages.getString("PaintEditor.Proportional")), proportional});
        dataPane.getChildren().addAll((Object[])new Node[]{new Label(Messages.getString("PaintEditor.CycleMethod")), cycleMethod});
        ListView colorStops = new ListView();
        colorStops.setCellFactory(v -> new StopCell());
        @Nullable Paint paint = (Paint)this.paint.get();
        Runnable updateLinear = () -> {
            linearGradientPreview.setFill((Paint)PaintEditor.createLinearGradient(startX.getText(), startY.getText(), endX.getText(), endY.getText(), proportional.isSelected(), (CycleMethod)cycleMethod.getSelectionModel().getSelectedItem(), (List<Stop>)colorStops.getItems()));
            this.paint.set((Object)linearGradientPreview.getFill());
        };
        if (!(paint instanceof LinearGradient)) {
            startX.setText(FORMAT.format(0L));
            startY.setText(FORMAT.format(0L));
            endX.setText(FORMAT.format(1L));
            endY.setText(FORMAT.format(1L));
            proportional.setSelected(true);
            cycleMethod.getSelectionModel().select(0);
            colorStops.setItems(FXCollections.observableArrayList((Object[])new Stop[]{new Stop(0.0, Color.WHITE), new Stop(1.0, Color.BLACK)}));
            updateLinear.run();
        } else if (paint instanceof LinearGradient) {
            linearGradientPreview.setFill(paint);
            LinearGradient g = (LinearGradient)paint;
            startX.setText(FORMAT.format(g.getStartX()));
            startY.setText(FORMAT.format(g.getStartY()));
            endX.setText(FORMAT.format(g.getEndY()));
            endY.setText(FORMAT.format(g.getEndY()));
            proportional.setSelected(g.isProportional());
            cycleMethod.setValue((Object)g.getCycleMethod());
        }
        StopColorPane pane = new StopColorPane((oldStop, newStop) -> {
            ObservableList items = colorStops.getItems();
            items.set(items.indexOf(oldStop), newStop);
            colorStops.getSelectionModel().select(newStop);
            updateLinear.run();
        });
        InvalidationListener l = o -> updateLinear.run();
        startX.textProperty().addListener(l);
        startY.textProperty().addListener(l);
        endX.textProperty().addListener(l);
        endY.textProperty().addListener(l);
        proportional.selectedProperty().addListener(l);
        cycleMethod.getSelectionModel().selectedItemProperty().addListener(l);
        colorStops.getSelectionModel().selectedItemProperty().addListener(o -> {
            Stop item = (Stop)colorStops.getSelectionModel().getSelectedItem();
            if (item != null) {
                pane.setStop(item);
            }
        });
        TitledPane previewPane = new TitledPane(Messages.getString("PaintEditor.Preview"), (Node)linearGradientPreview);
        previewPane.setCollapsible(false);
        BorderPane colorContainer = new BorderPane((Node)colorStops);
        Button newColor = new Button(Messages.getString("PaintEditor.New"));
        newColor.setOnAction(e -> {
            Stop s = new Stop(0.0, Color.RED);
            colorStops.getItems().add((Object)s);
            colorStops.getSelectionModel().select((Object)s);
        });
        GridLayoutPane.setConstraint((Node)newColor, (GridData)new GridData(GridData.Alignment.FILL, GridData.Alignment.CENTER, false, false));
        Button removeColor = new Button(Messages.getString("PaintEditor.Remove"));
        removeColor.setOnAction(e -> colorStops.getItems().removeAll((Collection)colorStops.getSelectionModel().getSelectedItems()));
        GridLayoutPane.setConstraint((Node)removeColor, (GridData)new GridData(GridData.Alignment.FILL, GridData.Alignment.CENTER, false, false));
        GridLayoutPane buttonContainer = new GridLayoutPane();
        buttonContainer.setNumColumns(2);
        buttonContainer.setMakeColumnsEqualWidth(true);
        buttonContainer.getChildren().addAll((Object[])new Node[]{newColor, removeColor});
        colorContainer.setBottom((Node)buttonContainer);
        TitledPane colorStopPane = new TitledPane(Messages.getString("PaintEditor.Colors"), (Node)colorContainer);
        colorStopPane.setCollapsible(false);
        GridLayoutPane.setConstraint((Node)previewPane, (GridData)new GridData(GridData.Alignment.BEGINNING, GridData.Alignment.BEGINNING, false, false, 1, 2));
        GridLayoutPane.setConstraint((Node)colorStopPane, (GridData)new GridData(GridData.Alignment.CENTER, GridData.Alignment.FILL, false, true, 1, 2));
        GridLayoutPane.setConstraint((Node)pane, (GridData)new GridData(GridData.Alignment.FILL, GridData.Alignment.BEGINNING, true, false));
        TitledPane dtp = new TitledPane(Messages.getString("PaintEditor.Data"), (Node)dataPane);
        dtp.setCollapsible(false);
        GridLayoutPane.setConstraint((Node)dtp, (GridData)new GridData(GridData.Alignment.FILL, GridData.Alignment.FILL, true, true));
        p.getChildren().addAll((Object[])new Node[]{previewPane, colorStopPane, pane, dtp});
        t.setContent((Node)p);
        return t;
    }

    private static LinearGradient createLinearGradient(String startX, String startY, String endX, String endY, boolean proportional, CycleMethod cycleMethod, List<Stop> stops) {
        double dsx = PaintEditor.parseSafe(startX, 0.0);
        double dsy = PaintEditor.parseSafe(startY, 0.0);
        double dex = PaintEditor.parseSafe(endX, 1.0);
        double dey = PaintEditor.parseSafe(endY, 1.0);
        return new LinearGradient(dsx, dsy, dex, dey, proportional, cycleMethod, stops);
    }

    private static RadialGradient createRadialGradient(String focusAngle, String focusDistance, String centerX, String centerY, String radius, boolean proportional, CycleMethod cycleMethod, List<Stop> stops) {
        double dFocusAngle = PaintEditor.parseSafe(focusAngle, 0.0);
        double dFocusDistance = PaintEditor.parseSafe(focusDistance, 0.0);
        double dCenterX = PaintEditor.parseSafe(centerX, 0.5);
        double dCenterY = PaintEditor.parseSafe(centerY, 0.5);
        double dRadius = PaintEditor.parseSafe(radius, 1.0);
        return new RadialGradient(dFocusAngle, dFocusDistance, dCenterX, dCenterY, dRadius, proportional, cycleMethod, stops);
    }

    static double parseSafe(String value, double defaultVal) {
        try {
            return FORMAT.parse(value).doubleValue();
        }
        catch (ParseException parseException) {
            return defaultVal;
        }
    }

    private Tab createRadialTab() {
        Rectangle radialGradientPreview;
        Tab t = new Tab();
        t.setText(Messages.getString("PaintEditor.RadialGradient"));
        GridLayoutPane p = new GridLayoutPane();
        p.setNumColumns(3);
        this.radialGradientPreview = radialGradientPreview = new Rectangle(200.0, 200.0);
        TextField focusAngle = new TextField();
        TextField focusDistance = new TextField();
        TextField centerX = new TextField();
        TextField centerY = new TextField();
        TextField radius = new TextField();
        CheckBox proportional = new CheckBox();
        ChoiceBox cycleMethod = new ChoiceBox(FXCollections.observableArrayList((Object[])CycleMethod.values()));
        GridLayoutPane dataPane = new GridLayoutPane();
        dataPane.setNumColumns(2);
        dataPane.getChildren().addAll((Object[])new Node[]{new Label(Messages.getString("PaintEditor.FocusAngle")), focusAngle});
        dataPane.getChildren().addAll((Object[])new Node[]{new Label(Messages.getString("PaintEditor.FocusDistance")), focusDistance});
        dataPane.getChildren().addAll((Object[])new Node[]{new Label(Messages.getString("PaintEditor.CenterX")), centerX});
        dataPane.getChildren().addAll((Object[])new Node[]{new Label(Messages.getString("PaintEditor.CenterY")), centerY});
        dataPane.getChildren().addAll((Object[])new Node[]{new Label(Messages.getString("PaintEditor.Radius")), radius});
        dataPane.getChildren().addAll((Object[])new Node[]{new Label(Messages.getString("PaintEditor.Proportional")), proportional});
        dataPane.getChildren().addAll((Object[])new Node[]{new Label(Messages.getString("PaintEditor.CycleMethod")), cycleMethod});
        ListView colorStops = new ListView();
        colorStops.setCellFactory(v -> new StopCell());
        @Nullable Paint paint = (Paint)this.paint.get();
        Runnable updateRadial = () -> {
            radialGradientPreview.setFill((Paint)PaintEditor.createRadialGradient(focusAngle.getText(), focusDistance.getText(), centerX.getText(), centerY.getText(), radius.getText(), proportional.isSelected(), (CycleMethod)cycleMethod.getSelectionModel().getSelectedItem(), (List<Stop>)colorStops.getItems()));
            this.paint.set((Object)radialGradientPreview.getFill());
        };
        if (!(paint instanceof RadialGradient)) {
            focusAngle.setText(FORMAT.format(0L));
            focusDistance.setText(FORMAT.format(0L));
            centerX.setText(FORMAT.format(0.5));
            centerY.setText(FORMAT.format(0.5));
            radius.setText(FORMAT.format(1L));
            proportional.setSelected(true);
            cycleMethod.getSelectionModel().select(0);
            colorStops.setItems(FXCollections.observableArrayList((Object[])new Stop[]{new Stop(0.0, Color.WHITE), new Stop(1.0, Color.BLACK)}));
            updateRadial.run();
        } else if (paint instanceof RadialGradient) {
            radialGradientPreview.setFill(paint);
            RadialGradient g = (RadialGradient)paint;
            focusAngle.setText(FORMAT.format(g.getFocusAngle()));
            focusDistance.setText(FORMAT.format(g.getFocusDistance()));
            centerX.setText(FORMAT.format(g.getCenterX()));
            centerY.setText(FORMAT.format(g.getCenterY()));
            radius.setText(FORMAT.format(g.getRadius()));
            proportional.setSelected(g.isProportional());
            cycleMethod.setValue((Object)g.getCycleMethod());
        }
        StopColorPane pane = new StopColorPane((oldStop, newStop) -> {
            ObservableList items = colorStops.getItems();
            items.set(items.indexOf(oldStop), newStop);
            colorStops.getSelectionModel().select(newStop);
            updateRadial.run();
        });
        InvalidationListener l = o -> updateRadial.run();
        focusAngle.textProperty().addListener(l);
        focusDistance.textProperty().addListener(l);
        centerX.textProperty().addListener(l);
        centerY.textProperty().addListener(l);
        radius.textProperty().addListener(l);
        proportional.selectedProperty().addListener(l);
        cycleMethod.getSelectionModel().selectedItemProperty().addListener(l);
        colorStops.getSelectionModel().selectedItemProperty().addListener(o -> {
            Stop item = (Stop)colorStops.getSelectionModel().getSelectedItem();
            if (item != null) {
                pane.setStop(item);
            }
        });
        TitledPane previewPane = new TitledPane(Messages.getString("PaintEditor.Preview"), (Node)radialGradientPreview);
        previewPane.setCollapsible(false);
        BorderPane colorContainer = new BorderPane((Node)colorStops);
        Button newColor = new Button(Messages.getString("PaintEditor.New"));
        newColor.setOnAction(e -> {
            Stop s = new Stop(0.0, Color.RED);
            colorStops.getItems().add((Object)s);
            colorStops.getSelectionModel().select((Object)s);
        });
        GridLayoutPane.setConstraint((Node)newColor, (GridData)new GridData(GridData.Alignment.FILL, GridData.Alignment.CENTER, false, false));
        Button removeColor = new Button(Messages.getString("PaintEditor.Remove"));
        removeColor.setOnAction(e -> colorStops.getItems().removeAll((Collection)colorStops.getSelectionModel().getSelectedItems()));
        GridLayoutPane.setConstraint((Node)removeColor, (GridData)new GridData(GridData.Alignment.FILL, GridData.Alignment.CENTER, false, false));
        GridLayoutPane buttonContainer = new GridLayoutPane();
        buttonContainer.setNumColumns(2);
        buttonContainer.setMakeColumnsEqualWidth(true);
        buttonContainer.getChildren().addAll((Object[])new Node[]{newColor, removeColor});
        colorContainer.setBottom((Node)buttonContainer);
        TitledPane colorStopPane = new TitledPane(Messages.getString("PaintEditor.Colors"), (Node)colorContainer);
        colorStopPane.setCollapsible(false);
        GridLayoutPane.setConstraint((Node)previewPane, (GridData)new GridData(GridData.Alignment.BEGINNING, GridData.Alignment.BEGINNING, false, false, 1, 2));
        GridLayoutPane.setConstraint((Node)colorStopPane, (GridData)new GridData(GridData.Alignment.CENTER, GridData.Alignment.FILL, false, true, 1, 2));
        GridLayoutPane.setConstraint((Node)pane, (GridData)new GridData(GridData.Alignment.FILL, GridData.Alignment.BEGINNING, true, false));
        TitledPane dtp = new TitledPane(Messages.getString("PaintEditor.Data"), (Node)dataPane);
        dtp.setCollapsible(false);
        GridLayoutPane.setConstraint((Node)dtp, (GridData)new GridData(GridData.Alignment.FILL, GridData.Alignment.FILL, true, true));
        p.getChildren().addAll((Object[])new Node[]{previewPane, colorStopPane, pane, dtp});
        t.setContent((Node)p);
        return t;
    }

    public static enum State {
        OK,
        APPLY,
        CANCEL;

    }

    static class StopCell
    extends ListCell<Stop> {
        StopCell() {
        }

        protected void updateItem(Stop item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null && !empty) {
                Rectangle r = new Rectangle(20.0, 20.0, (Paint)item.getColor());
                r.setStrokeWidth(1.0);
                r.setStroke((Paint)Color.BLACK);
                this.setGraphic((Node)r);
                this.setText(String.valueOf(FORMAT.format(item.getOffset() * 100.0)) + "%");
            } else {
                this.setGraphic(null);
                this.setText(null);
            }
        }
    }

    static class StopColorPane
    extends TitledPane {
        private final @NonNull ColorPicker picker;
        private final @NonNull TextField f;
        private Stop stop;
        private BiConsumer<Stop, Stop> consumer;
        private boolean inSet;

        public StopColorPane(BiConsumer<Stop, Stop> consumer) {
            this.setText(Messages.getString("PaintEditor.ColorStop"));
            this.consumer = consumer;
            this.setCollapsible(false);
            this.setDisable(true);
            GridLayoutPane p = new GridLayoutPane();
            p.setNumColumns(2);
            this.picker = new ColorPicker();
            this.picker.valueProperty().addListener(this::update);
            GridLayoutPane.setConstraint((Node)this.picker, (GridData)new GridData(768));
            p.getChildren().addAll((Object[])new Node[]{new Label(Messages.getString("PaintEditor.Color")), this.picker});
            this.f = new TextField();
            this.f.textProperty().addListener(this::update);
            GridLayoutPane.setConstraint((Node)this.f, (GridData)new GridData(768));
            p.getChildren().addAll((Object[])new Node[]{new Label(Messages.getString("PaintEditor.Offset")), this.f});
            this.setContent((Node)p);
        }

        void update(Observable t) {
            if (this.inSet) {
                return;
            }
            try {
                this.inSet = true;
                this.consumer.accept(this.stop, new Stop(PaintEditor.parseSafe(this.f.getText(), 0.0), (Color)this.picker.getValue()));
            }
            finally {
                this.inSet = false;
            }
        }

        public void setStop(Stop stop) {
            this.stop = stop;
            if (this.inSet) {
                return;
            }
            try {
                this.inSet = true;
                if (stop != null) {
                    this.picker.setValue((Object)stop.getColor());
                    this.f.setText(FORMAT.format(stop.getOffset()));
                    this.setDisable(false);
                } else {
                    this.setDisable(true);
                }
            }
            finally {
                this.inSet = false;
            }
        }
    }
}

