/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.fx;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.fx.code.editor.fx.services.Outline;
import org.eclipse.fx.ui.controls.tree.SimpleTreeCell;

public class OutlineViewer {
    private Map<Outline, TreeView<Outline.OutlineItem>> treeCache = new WeakHashMap<Outline, TreeView<Outline.OutlineItem>>();
    private final BorderPane container;

    @Inject
    public OutlineViewer(BorderPane container) {
        this.container = container;
    }

    private TreeView<Outline.OutlineItem> createView() {
        TreeView outlineView = new TreeView();
        outlineView.setShowRoot(false);
        outlineView.setCellFactory(this::createCell);
        return outlineView;
    }

    TreeCell<Outline.OutlineItem> createCell(TreeView<Outline.OutlineItem> param) {
        return new SimpleTreeCell(i -> i.getLabel(), i -> i.getGraphic(), i -> Collections.emptyList());
    }

    @Inject
    void updateInput(@Optional @Named(value="activeOutline") Outline outline) {
        if (outline != null) {
            TreeView<Outline.OutlineItem> view = this.treeCache.get(outline);
            if (view == null) {
                view = this.createView();
                TreeItem root = new TreeItem();
                for (Outline.OutlineItem l : outline.getRootItems()) {
                    root.getChildren().add(this.createRec(l));
                }
                outline.getRootItems().addListener(c -> {
                    while (c.next()) {
                        if (c.wasAdded()) {
                            root.getChildren().addAll((Collection)c.getAddedSubList().stream().map(this::createRec).collect(Collectors.toList()));
                        }
                        if (!c.wasRemoved()) continue;
                        root.getChildren().removeIf(t -> c.getRemoved().contains(t.getValue()));
                    }
                });
                view.setRoot(root);
                this.treeCache.put(outline, view);
            }
            this.container.setCenter(view);
        } else {
            this.container.setCenter(null);
        }
    }

    TreeItem<Outline.OutlineItem> createRec(Outline.OutlineItem i) {
        TreeItem l = new TreeItem((Object)i);
        for (Outline.OutlineItem c : i.getChildren()) {
            l.getChildren().add(this.createRec(c));
        }
        return l;
    }
}

