/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base.addons;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.fx.ui.services.sync.UISynchronize;
import org.osgi.service.event.Event;

public class CleanUpAddon {
    @Inject
    UISynchronize synchronize;
    @Inject
    EModelService modelService;

    @PostConstruct
    void init(IEventBroker broker) {
        broker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this::handleChildrenModified);
        broker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this::handleRenderingChanged);
    }

    private void handleChildrenModified(Event event) {
        Object changedObj = event.getProperty("ChangedElement");
        if (UIEvents.isREMOVE((Event)event)) {
            MElementContainer container = (MElementContainer)changedObj;
            MElementContainer containerParent = container.getParent();
            if (container instanceof MApplication || container instanceof MPerspectiveStack || container instanceof MMenuElement || container instanceof MTrimBar || container instanceof MToolBar || container instanceof MArea || container.getTags().contains("NoAutoCollapse")) {
                return;
            }
            if (container instanceof MWindow && containerParent instanceof MApplication) {
                return;
            }
            this.synchronize.scheduleExecution(200L, () -> {
                int tbrCount = this.modelService.toBeRenderedCount(container);
                boolean lastStack = this.isLastEditorStack((MUIElement)container);
                if (tbrCount == 0 && !lastStack) {
                    container.setToBeRendered(false);
                }
                if (container.getChildren().isEmpty()) {
                    container.setParent(null);
                } else if (container instanceof MGenericTile && container.getChildren().size() == 1) {
                    MGenericTile tile = (MGenericTile)container;
                    int idx = container.getParent().getChildren().indexOf(container);
                    String containerData = tile.getContainerData();
                    MUIElement child = (MUIElement)container.getChildren().remove(0);
                    child.setContainerData(containerData);
                    container.getParent().getChildren().add(idx, child);
                    container.setParent(null);
                }
            });
        }
    }

    private void handleRenderingChanged(Event event) {
        MUIElement changedObj = (MUIElement)event.getProperty("ChangedElement");
        MElementContainer container = null;
        container = changedObj.getCurSharedRef() != null ? changedObj.getCurSharedRef().getParent() : changedObj.getParent();
        if (container == null) {
            return;
        }
        MElementContainer containerElement = container;
        if (containerElement instanceof MWindow && containerElement.getParent() != null) {
            return;
        }
        if (this.isLastEditorStack((MUIElement)containerElement) || containerElement instanceof MPerspective || containerElement instanceof MPerspectiveStack) {
            return;
        }
        Boolean toBeRendered = (Boolean)event.getProperty("NewValue");
        if (Boolean.TRUE.equals(toBeRendered)) {
            if (!container.isToBeRendered()) {
                container.setToBeRendered(true);
            }
            if (!container.isVisible() && !container.getTags().contains("Minimized")) {
                container.setVisible(true);
            }
        } else {
            if (container.getTags().contains("NoAutoCollapse")) {
                return;
            }
            int visCount = this.modelService.countRenderableChildren((MUIElement)container);
            MElementContainer theContainer = container;
            if (visCount == 0) {
                this.synchronize.scheduleExecution(200L, () -> {
                    int _visCount = this.modelService.countRenderableChildren((MUIElement)theContainer);
                    if (!this.isLastEditorStack((MUIElement)theContainer) && _visCount == 0) {
                        theContainer.setToBeRendered(false);
                    }
                });
            } else {
                boolean makeInvisible = true;
                for (MUIElement kid : container.getChildren()) {
                    if (!kid.isToBeRendered() || !kid.isVisible()) continue;
                    makeInvisible = false;
                    break;
                }
                if (makeInvisible) {
                    container.setVisible(false);
                }
            }
        }
    }

    boolean isLastEditorStack(MUIElement element) {
        return this.modelService.isLastEditorStack(element);
    }
}

