/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.databinding.internal;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.fx.core.databinding.internal.FXBeanPropertyListenerSupport;

public abstract class FXBeanPropertyListener
extends NativePropertyListener {
    private final PropertyDescriptor propertyDescriptor;
    private final Map<Object, ChangeListener<Object>> map = new HashMap<Object, ChangeListener<Object>>();

    protected FXBeanPropertyListener(IProperty property, PropertyDescriptor propertyDescriptor, ISimplePropertyListener listener) {
        super(property, listener);
        this.propertyDescriptor = propertyDescriptor;
    }

    protected abstract IDiff computeDiff(Object var1, Object var2);

    protected void fireChange(Object source, IDiff diff) {
        super.fireChange(source, diff);
    }

    protected void doAddTo(Object source) {
        if (!this.map.containsKey(source)) {
            ChangeListener<Object> l = new ChangeListener<Object>(){

                public void changed(ObservableValue<? extends Object> source, Object oldValue, Object newValue) {
                    IDiff diff = oldValue == null || newValue == null ? null : FXBeanPropertyListener.this.computeDiff(oldValue, newValue);
                    FXBeanPropertyListener.this.fireChange(source, diff);
                }
            };
            this.map.put(source, l);
            FXBeanPropertyListenerSupport.hookListener(source, this.propertyDescriptor.getName(), l);
        }
    }

    protected void doRemoveFrom(Object source) {
        ChangeListener<Object> l = this.map.get(source);
        if (l != null) {
            FXBeanPropertyListenerSupport.unhookListener(source, this.propertyDescriptor.getName(), l);
        }
    }
}

