/**
 * Copyright (c) 2008, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      IBM Corporation - initial API and implementation
 */
package org.eclipse.e4.ui.model.application.ui.menu.impl;

import org.eclipse.e4.ui.model.application.ui.menu.MRenderedToolBar;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Rendered Tool Bar</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.e4.ui.model.application.ui.menu.impl.RenderedToolBarImpl#getContributionManager <em>Contribution Manager</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class RenderedToolBarImpl extends ToolBarImpl implements MRenderedToolBar {
	/**
	 * The default value of the '{@link #getContributionManager() <em>Contribution Manager</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContributionManager()
	 * @generated
	 * @ordered
	 */
	protected static final Object CONTRIBUTION_MANAGER_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getContributionManager() <em>Contribution Manager</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContributionManager()
	 * @generated
	 * @ordered
	 */
	protected Object contributionManager = CONTRIBUTION_MANAGER_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RenderedToolBarImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return MenuPackageImpl.Literals.RENDERED_TOOL_BAR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object getContributionManager() {
		return contributionManager;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContributionManager(Object newContributionManager) {
		Object oldContributionManager = contributionManager;
		contributionManager = newContributionManager;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MenuPackageImpl.RENDERED_TOOL_BAR__CONTRIBUTION_MANAGER, oldContributionManager, contributionManager));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case MenuPackageImpl.RENDERED_TOOL_BAR__CONTRIBUTION_MANAGER:
				return getContributionManager();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case MenuPackageImpl.RENDERED_TOOL_BAR__CONTRIBUTION_MANAGER:
				setContributionManager(newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case MenuPackageImpl.RENDERED_TOOL_BAR__CONTRIBUTION_MANAGER:
				setContributionManager(CONTRIBUTION_MANAGER_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case MenuPackageImpl.RENDERED_TOOL_BAR__CONTRIBUTION_MANAGER:
				return CONTRIBUTION_MANAGER_EDEFAULT == null ? contributionManager != null : !CONTRIBUTION_MANAGER_EDEFAULT.equals(contributionManager);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (contributionManager: "); //$NON-NLS-1$
		result.append(contributionManager);
		result.append(')');
		return result.toString();
	}

} //RenderedToolBarImpl
