/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.preferences.page;

import java.io.File;
import javafx.scene.control.Button;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import org.eclipse.fx.ui.preferences.page.StringFieldEditor;

public class DirectoryFieldEditor
extends StringFieldEditor {
    public static final String DIRECTORY_EDITOR_STYLE = "directory-field-container";

    public DirectoryFieldEditor(String name, String label) {
        super(name, label);
        Button browse = new Button("...");
        this.getTextContainer().getChildren().add((Object)browse);
        this.getTextContainer().getStyleClass().add((Object)DIRECTORY_EDITOR_STYLE);
        browse.setOnAction(event -> this.browse(browse.getScene().getWindow()));
    }

    private void browse(Window parent) {
        DirectoryChooser chooser = new DirectoryChooser();
        chooser.setInitialDirectory(this.getCurrentFolder());
        File result = chooser.showDialog(parent);
        if (result != null) {
            this.setCurrentFolder(result);
        }
    }

    private void setCurrentFolder(File result) {
        this.getTextField().setText(result.getPath());
    }

    private File getCurrentFolder() {
        String textValue = this.getTextField().getText();
        File folder = new File(textValue);
        while (folder != null && !folder.isDirectory()) {
            folder = folder.getParentFile();
        }
        return folder;
    }

    public DirectoryFieldEditor(String name) {
        this(name, null);
    }
}

