/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;
import org.eclipse.titanium.preferences.PreferenceConstants;

public class TooManyParameters
extends BaseModuleCodeSmellSpotter {
    private final int reportTooManyParametersSize = Platform.getPreferencesService().getInt("org.eclipse.titanium", PreferenceConstants.TOO_MANY_PARAMETERS_SIZE, 7, null);
    private static final String TOOMANYPARAMETERS = "More than {0} parameters: {1}";

    public TooManyParameters() {
        super(CodeSmellType.TOO_MANY_PARAMETERS);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        FormalParameterList s;
        if (node instanceof FormalParameterList && (s = (FormalParameterList)node).getNofParameters() > this.reportTooManyParametersSize) {
            String msg = MessageFormat.format(TOOMANYPARAMETERS, this.reportTooManyParametersSize, s.getNofParameters());
            problems.report(s.getLocation(), msg);
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(FormalParameterList.class);
        return ret;
    }
}

