/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class IfWithoutElse
extends BaseModuleCodeSmellSpotter {
    private static final String ERROR_MESSAGE = "Conditional operation without else clause";

    public IfWithoutElse() {
        super(CodeSmellType.IF_WITHOUT_ELSE);
    }

    @Override
    public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
        StatementBlock parentBlock;
        If_Statement s;
        if (node instanceof If_Statement && (s = (If_Statement)node).getStatementBlock() == null && s.getIfClauses() != null && s.getIfClauses().isExactlyOne() && (parentBlock = s.getMyStatementBlock()) != null && parentBlock.getSize() == 1) {
            problems.report(s.getLocation(), ERROR_MESSAGE);
        }
    }

    @Override
    public List<Class<? extends IVisitableNode>> getStartNode() {
        ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
        ret.add(If_Statement.class);
        return ret;
    }
}

