/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.export;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titanium.markers.export.BaseProblemExporter;
import org.eclipse.titanium.markers.handler.Marker;
import org.eclipse.titanium.markers.handler.MarkerHandler;
import org.eclipse.titanium.markers.types.CodeSmellType;
import org.eclipse.titanium.markers.types.TaskType;
import org.eclipse.titanium.markers.utils.AnalyzerCache;
import org.eclipse.titanium.markers.utils.RiskFactorCalculator;

public class XlsProblemExporter
extends BaseProblemExporter {
    public XlsProblemExporter(IProject project) {
        super(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportMarkers(IProgressMonitor monitor, String filename, Date date) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        File file = new File(filename);
        POIFSFileSystem fs = null;
        HSSFWorkbook workbook = null;
        try {
            fs = new POIFSFileSystem(XlsProblemExporter.class.getResourceAsStream("ProblemMarkers.xlt"));
            workbook = new HSSFWorkbook(fs, true);
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while exporting to excel", (Throwable)e);
            if (this.reportDebugInformation) {
                TITANDebugConsole.println((String[])new String[]{"Error on opening ProblemMarkers.xlt. Chartless xls will be generated"});
            }
            workbook = new HSSFWorkbook((InputStream)new FileInputStream(file));
            workbook.createSheet("Summary");
            workbook.setSheetOrder("Summary", 0);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while exporting to excel", (Throwable)e);
            return;
        }
        progress.worked(10);
        try {
            HSSFSheet summarySheet = workbook.getSheetAt(0);
            this.createTimeSheet(workbook);
            HashMap<String, Integer> smellCount = new HashMap<String, Integer>();
            int summaryRow = 4;
            Cell label = null;
            Cell numberCell = null;
            Map<TaskType, List<IMarker>> markers = this.collectMarkers();
            for (TaskType t : TaskType.values()) {
                this.createTaskSheet(workbook, t, markers.get(t));
                HSSFRow row1 = summarySheet.createRow(summaryRow++);
                label = row1.createCell(0);
                label.setCellValue(t.getHumanReadableName());
                int nofMarkers = markers.get(t).size();
                numberCell = row1.createCell(1);
                numberCell.setCellValue((double)nofMarkers);
                smellCount.put(t.name(), nofMarkers);
            }
            progress.worked(20);
            MarkerHandler mh = AnalyzerCache.withAll().analyzeProject((IProgressMonitor)progress.newChild(30), this.project);
            progress.setWorkRemaining(CodeSmellType.values().length + 1);
            for (CodeSmellType t : CodeSmellType.values()) {
                this.createCodeSmellSheet(workbook, mh, t);
                HSSFRow row1 = summarySheet.createRow(summaryRow++);
                label = row1.createCell(0);
                label.setCellValue(t.getHumanReadableName());
                smellCount.put(t.name(), mh.numberOfOccurrences(t));
                numberCell = row1.createCell(1);
                numberCell.setCellValue((double)mh.numberOfOccurrences(t));
                progress.worked(1);
            }
            HSSFRow row0 = summarySheet.createRow(0);
            row0.createCell(0).setCellValue("Project: " + this.project.getName());
            HSSFRow row1 = summarySheet.createRow(1);
            row1.createCell(0).setCellValue("Code smell \\ date");
            HSSFCellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setDataFormat(workbook.getCreationHelper().createDataFormat().getFormat("yyyy.mm.dd"));
            label = row1.createCell(1);
            label.setCellValue(date);
            label.setCellStyle((CellStyle)cellStyle);
            HSSFRow row2 = summarySheet.createRow(2);
            row2.createCell(0).setCellValue("Commulative Project Risk Factor");
            int riskFactor = new RiskFactorCalculator().measure(this.project, smellCount);
            row2.createCell(1).setCellValue((double)riskFactor);
            summarySheet.autoSizeColumn(0);
            summarySheet.autoSizeColumn(1);
            progress.worked(1);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while exporting to excel", (Throwable)e);
        }
        finally {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                workbook.write((OutputStream)fileOutputStream);
            }
            catch (Exception e) {
                try {
                    ErrorReporter.logExceptionStackTrace((String)"Error while closing the generated excel", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileOutputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)fileOutputStream);
            }
            IOUtils.closeQuietly((Closeable)fileOutputStream);
        }
    }

    private void createTimeSheet(HSSFWorkbook workbook) {
        Cell maxTimeCell;
        Cell avgTimeCell;
        Cell minTimeCell;
        Cell label;
        HSSFRow row2;
        HSSFSheet timeSheet = workbook.createSheet("Repair times");
        workbook.setSheetOrder("Repair times", 1);
        HSSFRow headerRow = timeSheet.createRow(0);
        headerRow.createCell(1).setCellValue("Minimal repair time");
        headerRow.createCell(2).setCellValue("Average repair time");
        headerRow.createCell(3).setCellValue("Maximal repair time");
        int summaryRow = 4;
        for (TaskType taskType : TaskType.values()) {
            row2 = timeSheet.createRow(summaryRow);
            label = row2.createCell(0);
            label.setCellValue(taskType.getHumanReadableName());
            minTimeCell = row2.createCell(1);
            minTimeCell.setCellType(2);
            minTimeCell.setCellFormula(taskType.getMinRepairTime() + "*Summary!$B" + (summaryRow + 1));
            avgTimeCell = row2.createCell(2);
            avgTimeCell.setCellType(2);
            avgTimeCell.setCellFormula(taskType.getAvgRepairTime() + "*Summary!$B" + (summaryRow + 1));
            maxTimeCell = row2.createCell(3);
            maxTimeCell.setCellType(2);
            maxTimeCell.setCellFormula(taskType.getMaxRepairTime() + "*Summary!$B" + ++summaryRow);
        }
        for (Enum enum_ : CodeSmellType.values()) {
            row2 = timeSheet.createRow(summaryRow);
            label = row2.createCell(0);
            label.setCellValue(((CodeSmellType)enum_).getHumanReadableName());
            minTimeCell = row2.createCell(1);
            minTimeCell.setCellType(2);
            minTimeCell.setCellFormula(((CodeSmellType)enum_).getMinRepairTime() + "*Summary!$B" + (summaryRow + 1));
            avgTimeCell = row2.createCell(2);
            avgTimeCell.setCellType(2);
            avgTimeCell.setCellFormula(((CodeSmellType)enum_).getAvgRepairTime() + "*Summary!$B" + (summaryRow + 1));
            maxTimeCell = row2.createCell(3);
            maxTimeCell.setCellType(2);
            maxTimeCell.setCellFormula(((CodeSmellType)enum_).getMaxRepairTime() + "*Summary!$B" + ++summaryRow);
        }
        HSSFRow totalRow = timeSheet.createRow(1);
        totalRow.createCell(0).setCellValue("Total");
        Cell cell1 = totalRow.createCell(1);
        cell1.setCellType(2);
        cell1.setCellFormula("SUM($B4:$B" + summaryRow + ")");
        Cell cell2 = totalRow.createCell(2);
        cell2.setCellType(2);
        cell2.setCellFormula("SUM($C4:$C" + summaryRow + ")");
        Cell cell = totalRow.createCell(3);
        cell.setCellType(2);
        cell.setCellFormula("SUM($D4:$D" + summaryRow + ")");
        timeSheet.autoSizeColumn(0);
        timeSheet.autoSizeColumn(1);
        timeSheet.autoSizeColumn(2);
        timeSheet.autoSizeColumn(3);
    }

    private void createTaskSheet(HSSFWorkbook workbook, TaskType t, List<IMarker> markers) {
        if (markers.isEmpty()) {
            return;
        }
        int currentRow = 1;
        String sheetName = t.getHumanReadableName();
        HSSFSheet sheet = workbook.createSheet(sheetName);
        HSSFRow row = sheet.createRow(0);
        row.createCell(0).setCellValue("Description");
        row.createCell(1).setCellValue("Resource");
        row.createCell(2).setCellValue("Location");
        for (IMarker m : markers) {
            row = sheet.createRow(currentRow);
            Cell label = row.createCell(0);
            try {
                label.setCellValue(m.getAttribute("message").toString());
            }
            catch (CoreException e) {
                label.setCellValue("<unknown>");
            }
            label = row.createCell(1);
            label.setCellValue(m.getResource().getName());
            Cell numberCell = row.createCell(2);
            try {
                numberCell.setCellValue(Double.parseDouble(m.getAttribute("lineNumber").toString()));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++currentRow;
        }
        sheet.autoSizeColumn(0);
        sheet.autoSizeColumn(1);
    }

    private void createCodeSmellSheet(HSSFWorkbook workbook, MarkerHandler mh, CodeSmellType t) {
        if (mh.get(t).isEmpty()) {
            return;
        }
        String sheetName = t.name();
        HSSFSheet sheet = workbook.createSheet(sheetName);
        HSSFRow row = sheet.createRow(0);
        row.createCell(0).setCellValue("Description");
        row.createCell(1).setCellValue("Resource");
        row.createCell(2).setCellValue("Location");
        int currentRow = 1;
        for (Marker m : mh.get(t)) {
            if (m.getLine() == -1 || m.getResource() == null) continue;
            try {
                row = sheet.createRow(currentRow);
                Cell label = row.createCell(0);
                label.setCellValue(m.getMessage());
                label = row.createCell(1);
                label.setCellValue(m.getResource().getName());
                label = row.createCell(2);
                label.setCellValue((double)m.getLine());
                ++currentRow;
            }
            catch (Exception e) {
                ErrorReporter.logWarning((String)("Only " + currentRow + " rows were written: the limit has been reached."));
                break;
            }
        }
        sheet.autoSizeColumn(0);
        sheet.autoSizeColumn(1);
        sheet.autoSizeColumn(2);
    }
}

