/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.utils;

import java.io.File;
import java.io.IOException;
import org.eclipse.titan.common.logging.ErrorReporter;

public final class FileUtils {
    private FileUtils() {
    }

    public static void delete(File file) throws IOException {
        if (FileUtils.deleteIfExists(file)) {
            throw new IOException("The file cannot be deleted: " + file.getAbsolutePath());
        }
    }

    public static boolean deleteQuietly(File file) {
        boolean failed = FileUtils.deleteIfExists(file);
        if (failed) {
            ErrorReporter.logError("Cannot delete file: " + file.getPath());
        }
        return !failed;
    }

    private static boolean deleteIfExists(File file) {
        return file.exists() && !file.delete();
    }
}

