/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.utils;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.IOUtils;

public final class Cygwin {
    private static Boolean installed = null;

    private Cygwin() {
    }

    public static synchronized boolean isInstalled() {
        if (installed != null) {
            return installed;
        }
        installed = Boolean.FALSE;
        try {
            String regQueryOutput = Cygwin.executeProgram("reg query HKCU\\Software\\Cygwin\\Installations");
            if (regQueryOutput == null && (regQueryOutput = Cygwin.executeProgram("reg query HKLM\\SOFTWARE\\Cygwin\\Installations")) == null) {
                return installed;
            }
            Pattern errorPattern = Pattern.compile("ERROR.*");
            Matcher errorMatcher = errorPattern.matcher(regQueryOutput);
            if (errorMatcher.matches()) {
                return installed;
            }
            installed = Boolean.TRUE;
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace("While checking if cygwin is installed", e);
        }
        return installed;
    }

    public static boolean isMissingInOSWin32() {
        return "win32".equals(Platform.getOS()) && !Cygwin.isInstalled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeProgram(String command) {
        Process proc;
        try {
            proc = Runtime.getRuntime().exec(command);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace("Error while executing " + command, e);
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream(), Charset.defaultCharset()));
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            if (proc.waitFor() != 0) {
                String string = null;
                return string;
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace("Error while executing " + command, e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)reader);
        }
        return null;
    }
}

