/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.path;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.Joiner;

public final class PathUtil {
    private PathUtil() {
    }

    private static List<String> getPathList(File file) {
        ArrayList<String> temp = new ArrayList<String>();
        try {
            for (File result = file.getCanonicalFile(); result != null; result = result.getParentFile()) {
                temp.add(result.getName());
            }
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace("The canonical path of " + file.getName() + "could not be calculated", e);
        }
        Collections.reverse(temp);
        return temp;
    }

    private static String calculateAbsolutePath(List<String> baseList, List<String> relativeList) {
        StringBuilder builder = new StringBuilder();
        ArrayList<String> result = new ArrayList<String>(baseList);
        for (int index = 0; index < relativeList.size(); ++index) {
            String temp = relativeList.get(index);
            if ("..".equals(temp)) {
                if (result.isEmpty()) continue;
                result.remove(result.size() - 1);
                continue;
            }
            result.add(temp);
        }
        new Joiner(File.separator).join(result).appendTo(builder);
        return builder.toString();
    }

    public static String getAbsolutePath(String base, String relative) {
        Path basePath = new Path(base);
        Path relativePath = new Path(relative);
        String baseDevice = basePath.getDevice();
        String relativeDevice = relativePath.getDevice();
        if (baseDevice != null && relativeDevice != null && !basePath.getDevice().equals(relativePath.getDevice())) {
            return relative;
        }
        List<String> baseList = Arrays.asList(basePath.segments());
        List<String> relativeList = Arrays.asList(relativePath.segments());
        Path calculatedPath = new Path(PathUtil.calculateAbsolutePath(baseList, relativeList));
        IPath temp = calculatedPath.setDevice(baseDevice);
        IPath absolutePath = temp.makeAbsolute();
        return absolutePath.toOSString();
    }

    private static String calculateRelativePath(List<String> baseList, List<String> whatList) {
        int whatIndex;
        if (baseList.isEmpty()) {
            return File.separator + new Joiner(File.separator).join(whatList).toString();
        }
        int baseIndex = 0;
        for (whatIndex = 0; baseIndex < baseList.size() && whatIndex < whatList.size() && baseList.get(baseIndex).equals(whatList.get(whatIndex)); ++baseIndex, ++whatIndex) {
        }
        StringBuilder builder = new StringBuilder();
        while (baseIndex < baseList.size()) {
            builder.append("..").append(File.separator);
            ++baseIndex;
        }
        while (whatIndex < whatList.size()) {
            builder.append(whatList.get(whatIndex));
            if (whatIndex != whatList.size() - 1) {
                builder.append(File.separator);
            }
            ++whatIndex;
        }
        return builder.toString();
    }

    public static String getRelativePath(File base, File what) {
        List<String> baseList = PathUtil.getPathList(base);
        List<String> whatList = PathUtil.getPathList(what);
        return PathUtil.calculateRelativePath(baseList, whatList);
    }

    public static String getRelativePath(String base, String what) {
        if (base.equals(what)) {
            return ".";
        }
        if (base.length() == 0) {
            return what;
        }
        Path basePath = new Path(base);
        Path whatPath = new Path(what);
        String baseDevice = basePath.getDevice();
        String whatDevice = whatPath.getDevice();
        if (baseDevice == null || whatDevice == null ? baseDevice != null && !baseDevice.equals(whatDevice) : !baseDevice.equals(whatDevice)) {
            return what;
        }
        return PathUtil.calculateRelativePath(Arrays.asList(basePath.segments()), Arrays.asList(whatPath.segments()));
    }
}

