/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.parsers.cfg;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.common.parsers.TitanListener;
import org.eclipse.titan.common.parsers.cfg.CfgInterval;
import org.eclipse.titan.common.parsers.cfg.CfgLexer;
import org.eclipse.titan.common.parsers.cfg.CfgParseResult;
import org.eclipse.titan.common.parsers.cfg.CfgParser;
import org.eclipse.titan.common.parsers.cfg.indices.ComponentSectionHandler;
import org.eclipse.titan.common.parsers.cfg.indices.DefineSectionHandler;
import org.eclipse.titan.common.parsers.cfg.indices.ExecuteSectionHandler;
import org.eclipse.titan.common.parsers.cfg.indices.ExternalCommandSectionHandler;
import org.eclipse.titan.common.parsers.cfg.indices.GroupSectionHandler;
import org.eclipse.titan.common.parsers.cfg.indices.IncludeSectionHandler;
import org.eclipse.titan.common.parsers.cfg.indices.LoggingSectionHandler;
import org.eclipse.titan.common.parsers.cfg.indices.MCSectionHandler;
import org.eclipse.titan.common.parsers.cfg.indices.ModuleParameterSectionHandler;
import org.eclipse.titan.common.parsers.cfg.indices.TestportParameterSectionHandler;
import org.eclipse.titan.common.utils.StandardCharsets;

public final class CfgAnalyzer {
    private CfgInterval rootInterval;
    private TitanListener lexerListener = null;
    private TitanListener parserListener = null;
    private ModuleParameterSectionHandler moduleParametersHandler = null;
    private TestportParameterSectionHandler testportParametersHandler = null;
    private ComponentSectionHandler componentSectionHandler = null;
    private GroupSectionHandler groupSectionHandler = null;
    private MCSectionHandler mcSectionHandler = null;
    private ExternalCommandSectionHandler externalCommandsSectionHandler = null;
    private ExecuteSectionHandler executeSectionHandler = null;
    private IncludeSectionHandler includeSectionHandler = null;
    private IncludeSectionHandler orderedIncludeSectionHandler = null;
    private DefineSectionHandler defineSectionHandler = null;
    private LoggingSectionHandler loggingSectionHandler = null;
    private CfgParseResult mCfgParseResult;

    public CfgParseResult getCfgParseResult() {
        return this.mCfgParseResult;
    }

    public CfgInterval getRootInterval() {
        return this.rootInterval;
    }

    public ModuleParameterSectionHandler getModuleParametersHandler() {
        return this.moduleParametersHandler;
    }

    public TestportParameterSectionHandler getTestportParametersHandler() {
        return this.testportParametersHandler;
    }

    public ComponentSectionHandler getComponentSectionHandler() {
        return this.componentSectionHandler;
    }

    public GroupSectionHandler getGroupSectionHandler() {
        return this.groupSectionHandler;
    }

    public MCSectionHandler getMcSectionHandler() {
        return this.mcSectionHandler;
    }

    public ExternalCommandSectionHandler getExternalCommandsSectionHandler() {
        return this.externalCommandsSectionHandler;
    }

    public ExecuteSectionHandler getExecuteSectionHandler() {
        return this.executeSectionHandler;
    }

    public IncludeSectionHandler getIncludeSectionHandler() {
        return this.includeSectionHandler;
    }

    public IncludeSectionHandler getOrderedIncludeSectionHandler() {
        return this.orderedIncludeSectionHandler;
    }

    public DefineSectionHandler getDefineSectionHandler() {
        return this.defineSectionHandler;
    }

    public LoggingSectionHandler getLoggingSectionHandler() {
        return this.loggingSectionHandler;
    }

    public List<SyntacticErrorStorage> getErrorStorage() {
        if (this.lexerListener != null && this.parserListener != null) {
            this.lexerListener.addAll(this.parserListener.getErrorsStored());
            return this.lexerListener.getErrorsStored();
        }
        return new ArrayList<SyntacticErrorStorage>();
    }

    public void parse(IFile file, String code) {
        String fileName = "<unknown file>";
        if (file != null) {
            fileName = file.getFullPath().toOSString();
        }
        this.directParse(file, fileName, code);
    }

    public void directParse(IFile file, String fileName, String code) {
        int fileLength;
        Reader reader;
        if (null != code) {
            reader = new StringReader(code);
            fileLength = code.length();
        } else {
            if (null != file) {
                try {
                    IFileStore store;
                    reader = new BufferedReader(new InputStreamReader(file.getContents(), StandardCharsets.UTF8));
                    try {
                        store = EFS.getStore((URI)file.getLocationURI());
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                        return;
                    }
                    IFileInfo fileInfo = store.fetchInfo();
                    fileLength = (int)fileInfo.getLength();
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace("Could not get the contents of `" + fileName + "'", e);
                    return;
                }
            }
            ErrorReporter.INTERNAL_ERROR("CfgAnalyzer.directParse(): nothing to parse");
            return;
        }
        UnbufferedCharStream charStream = new UnbufferedCharStream(reader);
        CfgLexer lexer = new CfgLexer((CharStream)charStream);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        lexer.initRootInterval(fileLength);
        this.lexerListener = new TitanListener();
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)this.lexerListener);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        CfgParser parser = new CfgParser((TokenStream)tokenStream);
        parser.setActualFile(file);
        this.parserListener = new TitanListener();
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)this.parserListener);
        CfgParser.Pr_ConfigFileContext parseTreeRoot = parser.pr_ConfigFile();
        this.mCfgParseResult = parser.getCfgParseResult();
        this.mCfgParseResult.setParseTreeRoot(parseTreeRoot);
        this.mCfgParseResult.setTokens(tokenStream.getTokens());
        this.moduleParametersHandler = parser.getModuleParametersHandler();
        this.testportParametersHandler = parser.getTestportParametersHandler();
        this.componentSectionHandler = parser.getComponentSectionHandler();
        this.groupSectionHandler = parser.getGroupSectionHandler();
        this.mcSectionHandler = parser.getMcSectionHandler();
        this.externalCommandsSectionHandler = parser.getExternalCommandsSectionHandler();
        this.executeSectionHandler = parser.getExecuteSectionHandler();
        this.includeSectionHandler = parser.getIncludeSectionHandler();
        this.orderedIncludeSectionHandler = parser.getOrderedIncludeSectionHandler();
        this.defineSectionHandler = parser.getDefineSectionHandler();
        this.loggingSectionHandler = parser.getLoggingSectionHandler();
        this.rootInterval = lexer.getRootInterval();
    }
}

