/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.parsers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.ILexerLogUtil;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.common.parsers.TokenNameResolver;
import org.eclipse.titan.common.parsers.cfg.CfgInterval;

public class ParserLogger {
    public static void log(ParseTree aRoot, Parser aParser, List<Token> aTokens, ILexerLogUtil aLexerLogUtil) {
        ParserLogger.log(aRoot, aParser, aTokens, new TokenNameResolver(aLexerLogUtil));
    }

    public static void log(ParseTree aRoot, Parser aParser, List<Token> aTokens, Lexer aLexer) {
        ParserLogger.log(aRoot, aParser, aTokens, new TokenNameResolver(aLexer));
    }

    public static void log(ParseTree aRoot, Parser aParser, List<Token> aTokens) {
        ParserLogger.log(aRoot, aParser, aTokens, new TokenNameResolver());
    }

    private static void log(ParseTree aRoot, Parser aParser, List<Token> aTokens, TokenNameResolver aTokenNameResolver) {
        ParserLogger.log(aRoot, aParser, aTokens, aTokenNameResolver, 0, false);
    }

    private static void log(ParseTree aRoot, Parser aParser, List<Token> aTokens, TokenNameResolver aTokenNameResolver, int aLevel, boolean aParentOneChild) {
        if (aRoot == null) {
            ParserLogger.println("ERROR: ParseTree root is null");
            return;
        }
        if (!aParser.getBuildParseTree()) {
            ParserLogger.println("ERROR: ParseTree is not build. Call Parser.setBuildParseTree( true ); BEFORE parsing. Or do NOT call Parser.setBuildParseTree( false );");
            return;
        }
        if (aRoot instanceof ParserRuleContext) {
            boolean oneChild;
            ParserRuleContext rule = (ParserRuleContext)aRoot;
            String ruleInfo = ParserLogger.getRuleInfo(rule, aParser, aTokenNameResolver);
            if (aParentOneChild) {
                ParserLogger.printArrow(ruleInfo);
            } else {
                ParserLogger.printIndent(ruleInfo, aLevel);
            }
            int count = rule.getChildCount();
            boolean bl = oneChild = count == 1 && rule.exception == null;
            if (!oneChild) {
                ParserLogger.print(": '" + ParserLogger.getEscapedRuleText(rule, aTokens) + "'");
                ParserLogger.println();
            }
            for (int i = 0; i < count; ++i) {
                ParseTree child = rule.getChild(i);
                ParserLogger.log(child, aParser, aTokens, aTokenNameResolver, aLevel + (aParentOneChild ? 0 : 1), oneChild);
            }
        } else if (aRoot instanceof TerminalNodeImpl) {
            TerminalNodeImpl tn = (TerminalNodeImpl)aRoot;
            if (aParentOneChild) {
                ParserLogger.print(": '" + ParserLogger.getEscapedTokenText(tn.getSymbol()) + "'");
                ParserLogger.println();
            }
            ParserLogger.printIndent(ParserLogger.getTokenInfo(tn.getSymbol(), aTokenNameResolver), aLevel);
            if (tn.parent == null) {
                ParserLogger.print(", parent == null <-------------------------------------------------------------- ERROR");
            }
            ParserLogger.println();
        } else if (aRoot instanceof AddedParseTree) {
            AddedParseTree apt = (AddedParseTree)aRoot;
            if (aParentOneChild) {
                ParserLogger.print(": '" + ParserLogger.getEscapedText(apt.getText()) + "'");
                ParserLogger.println();
            }
            ParserLogger.printIndent("AddedParseString: " + ParserLogger.getEscapedText(apt.getText()), aLevel);
            if (apt.getParent() == null) {
                ParserLogger.print(", parent == null <-------------------------------------------------------------- ERROR");
            }
            ParserLogger.println();
        } else {
            ParserLogger.println("ERROR: INVALID ParseTree type");
        }
    }

    private static String getExceptionInfo(ParserRuleContext aRule, TokenNameResolver aTokenNameResolver) {
        RecognitionException e = aRule.exception;
        if (e == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\naRule.getText() == " + aRule.getText());
        sb.append("\ngetOffendingState() == " + e.getOffendingState());
        sb.append("\ngetExpectedTokens() == [");
        List expectedTokens = e.getExpectedTokens().toList();
        for (int i = 0; i < expectedTokens.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            int tokenType = (Integer)expectedTokens.get(i);
            sb.append(ParserLogger.getTokenName(tokenType, aTokenNameResolver));
        }
        sb.append("]");
        if (e instanceof NoViableAltException) {
            NoViableAltException nvae = (NoViableAltException)e;
            sb.append("\ngetStartToken() == " + ParserLogger.getTokenInfo(nvae.getStartToken(), aTokenNameResolver));
            sb.append("\ngetDeadEndConfigs() == " + nvae.getDeadEndConfigs());
        }
        StringWriter errors = new StringWriter();
        e.printStackTrace(new PrintWriter(errors));
        sb.append("\n" + errors.toString());
        return sb.toString();
    }

    private static String getRuleInfo(ParserRuleContext aRule, Parser aParser, TokenNameResolver aTokenNameResolver) {
        String info = (String)aParser.getRuleInvocationStack((RuleContext)aRule).get(0);
        info = info + ParserLogger.getExceptionInfo(aRule, aTokenNameResolver);
        return info;
    }

    private static String getEscapedRuleText(ParserRuleContext aRule, List<Token> aTokens) {
        Token startToken = aRule.start;
        if (startToken == null) {
            ParserLogger.println("ERROR: ParseLogger.getEscapedRuleText() startToken == null");
            return "";
        }
        int startIndex = startToken.getTokenIndex();
        Token stopToken = aRule.stop;
        if (stopToken == null) {
            ParserLogger.println("ERROR: ParseLogger.getEscapedRuleText() stopToken == null");
            return "";
        }
        int stopIndex = stopToken.getTokenIndex();
        StringBuilder sb = new StringBuilder();
        for (int i = startIndex; i <= stopIndex; ++i) {
            try {
                sb.append(ParserLogger.getEscapedTokenText(aTokens.get(i)));
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                sb.append("_");
            }
        }
        return sb.toString();
    }

    public static String getRuleText(ParserRuleContext aRule, List<Token> aTokens) {
        Token startToken = aRule.start;
        if (startToken == null) {
            ParserLogger.println("ERROR: ParseLogger.getEscapedRuleText() startToken == null");
            return "";
        }
        int startIndex = startToken.getTokenIndex();
        Token stopToken = aRule.stop;
        if (stopToken == null) {
            ParserLogger.println("ERROR: ParseLogger.getEscapedRuleText() stopToken == null");
            return "";
        }
        int stopIndex = stopToken.getTokenIndex();
        StringBuilder sb = new StringBuilder();
        for (int i = startIndex; i <= stopIndex; ++i) {
            sb.append(aTokens.get(i));
        }
        return sb.toString();
    }

    private static String getTokenInfo(Token aToken, TokenNameResolver aTokenNameResolver) {
        StringBuilder sb = new StringBuilder();
        int tokenType = aToken.getType();
        String tokenName = ParserLogger.getTokenName(tokenType, aTokenNameResolver);
        sb.append(tokenName);
        sb.append(": ");
        sb.append("'");
        sb.append(ParserLogger.getEscapedTokenText(aToken));
        sb.append("'");
        sb.append(", @" + aToken.getTokenIndex());
        sb.append(", " + aToken.getLine() + ":" + aToken.getCharPositionInLine());
        if (aToken.getChannel() > 0) {
            sb.append(", channel=");
            sb.append(aToken.getChannel());
        }
        return sb.toString();
    }

    private static String getEscapedTokenText(Token aToken) {
        return ParserLogger.getEscapedText(aToken.getText());
    }

    private static String getEscapedText(String aText) {
        String txt = aText;
        if (txt == null) {
            return "";
        }
        txt = txt.replace("\n", "\\n");
        txt = txt.replace("\r", "\\r");
        txt = txt.replace("\t", "\\t");
        return txt;
    }

    private static String getTokenName(int aTokenType, TokenNameResolver aTokenNameResolver) {
        if (aTokenNameResolver == null) {
            aTokenNameResolver = new TokenNameResolver();
        }
        return aTokenNameResolver.getTokenName(aTokenType);
    }

    public static void logInterval(Interval aRootInterval) {
        ParserLogger.logInterval(aRootInterval, 0);
    }

    private static void logInterval(Interval aRootInterval, int aLevel) {
        StringBuilder sb = new StringBuilder();
        sb.append("" + aRootInterval.getDepth());
        sb.append(", " + aRootInterval.getStartOffset());
        sb.append(", " + aRootInterval.getStartLine());
        sb.append(", " + aRootInterval.getEndOffset());
        sb.append(", " + aRootInterval.getEndLine());
        sb.append(", " + (Object)((Object)aRootInterval.getType()));
        if (aRootInterval instanceof CfgInterval) {
            sb.append(", " + (Object)((Object)((CfgInterval)aRootInterval).getSectionType()));
        }
        if (aRootInterval.getErroneous()) {
            sb.append(", ERRONEOUS");
        }
        ParserLogger.printIndent(sb.toString(), aLevel);
        ParserLogger.println();
        if (aRootInterval.getSubIntervals() != null) {
            for (Interval interval : aRootInterval.getSubIntervals()) {
                ParserLogger.logInterval(interval, aLevel + 1);
            }
        }
    }

    private static void printArrow(String aMsg) {
        ParserLogger.print(" -> ");
        ParserLogger.print(aMsg);
    }

    private static void printIndent(String aMsg, int aLevel) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < aLevel; ++i) {
            sb.append("  ");
        }
        ParserLogger.print(sb.toString());
        ParserLogger.print(aMsg);
    }

    private static void print(String aMsg) {
        System.out.print(aMsg);
    }

    private static void println() {
        System.out.println();
    }

    private static void println(String aMsg) {
        System.out.println(aMsg);
    }
}

