/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.widgets;

import fr.inria.zvtm.animation.Animation;
import fr.inria.zvtm.animation.interpolation.IdentityInterpolator;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.VCircle;
import fr.inria.zvtm.glyphs.VRing;
import fr.inria.zvtm.glyphs.VTextOr;
import fr.inria.zvtm.widgets.PieMenu;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;

public class PieMenuR
extends PieMenu {
    public static final int animStartSize = 5;

    public PieMenuR(String[] stringLabels, Point2D.Double menuCenterCoordinates, String vsName, VirtualSpaceManager vsm, double radius, float irr, double startAngle, double angleWidth, Color[] fillColors, Color[] borderColors, Color[] fillSColors, Color[] borderSColors, Color[] labelColors, float alphaT, int animDuration, double sensitRadius, Font font, Point2D.Double[] labelOffsets) {
        int i;
        this.vs = vsm.getVirtualSpace(vsName);
        double vx = menuCenterCoordinates.x;
        double vy = menuCenterCoordinates.y;
        this.items = new VRing[stringLabels.length];
        this.labels = new VTextOr[stringLabels.length];
        double angle = startAngle;
        double angleDelta = angleWidth / (double)stringLabels.length;
        double pieMenuRadius = radius;
        for (i = 0; i < this.labels.length; ++i) {
            this.items[i] = new VRing(vx, vy, 0, animDuration > 0 ? 5.0 : pieMenuRadius, angleDelta, irr, angle += angleDelta, fillColors[i], borderColors[i], alphaT);
            this.items[i].setCursorInsideFillColor(fillSColors[i]);
            this.items[i].setCursorInsideHighlightColor(borderSColors[i]);
            this.vs.addGlyph(this.items[i], false, false);
            if (stringLabels[i] == null || stringLabels[i].length() <= 0) continue;
            if (this.orientText) {
                double textAngle = angle;
                if (angle > 1.5707963267948966) {
                    if (angle > Math.PI) {
                        if (angle < 4.71238898038469) {
                            textAngle -= Math.PI;
                        }
                    } else {
                        textAngle += Math.PI;
                    }
                }
                this.labels[i] = new VTextOr(vx + Math.cos(angle) * pieMenuRadius / 2.0 + labelOffsets[i].x, vy + Math.sin(angle) * pieMenuRadius / 2.0 + labelOffsets[i].y, 0, labelColors[i], stringLabels[i], textAngle, 1);
            } else {
                this.labels[i] = new VTextOr(vx + Math.cos(angle) * pieMenuRadius / 2.0 + labelOffsets[i].x, vy + Math.sin(angle) * pieMenuRadius / 2.0 + labelOffsets[i].y, 0, labelColors[i], stringLabels[i], 0.0, 1);
            }
            this.labels[i].setBorderColor(borderColors[i]);
            this.labels[i].setFont(font);
            this.labels[i].setSensitivity(false);
            this.vs.addGlyph(this.labels[i]);
        }
        if (animDuration > 0) {
            for (i = 0; i < this.items.length; ++i) {
                Animation sizeAnim = vsm.getAnimationManager().getAnimationFactory().createGlyphSizeAnim(animDuration, this.items[i], (float)pieMenuRadius, false, IdentityInterpolator.getInstance(), null);
                vsm.getAnimationManager().startAnimation(sizeAnim, false);
            }
        }
        this.boundary = new VCircle(vx, vy, 0, pieMenuRadius * sensitRadius * 2.0, Color.white);
        this.boundary.setVisible(false);
        this.vs.addGlyph(this.boundary);
        this.vs.atBottom(this.boundary);
    }
}

