/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.lens;

import fr.inria.zvtm.lens.FixedSizeLens;

public class FSFresnelLens
extends FixedSizeLens {
    int nbSteps = 2;
    int[] Ri;
    float[] MMi;
    double d = 0.0;

    public FSFresnelLens() {
        this(2.0f, 100, 50, 2, 0, 0);
    }

    public FSFresnelLens(float mm, int ns) {
        this(mm, 100, 50, ns, 0, 0);
    }

    public FSFresnelLens(float mm, int outerRadius, int innerRadius, int ns) {
        this(mm, outerRadius, innerRadius, ns, 0, 0);
    }

    public FSFresnelLens(float mm, int outerRadius, int innerRadius, int ns, int x, int y) {
        this.MM = mm;
        this.LR1 = outerRadius;
        this.LR2 = innerRadius;
        this.updateMagBufferWorkingDimensions();
        this.nbSteps = ns;
        this.Ri = new int[this.nbSteps];
        this.MMi = new float[this.nbSteps];
        this.updateSteps();
        this.lx = x;
        this.ly = y;
    }

    void updateSteps() {
        float stepRadius = (float)(this.LR1 - this.LR2) / (float)this.nbSteps;
        float stepMM = (this.MM - 1.0f) / ((float)this.nbSteps + 1.0f);
        for (int i = 0; i < this.Ri.length; ++i) {
            this.Ri[i] = this.LR2 + Math.round((float)(i + 1) * stepRadius);
            this.MMi[i] = this.MM - stepMM * (float)(i + 1);
        }
    }

    @Override
    public void setOuterRadius(int r) {
        super.setOuterRadius(r);
        this.updateSteps();
    }

    @Override
    public void setInnerRadius(int r) {
        super.setInnerRadius(r);
        this.updateSteps();
    }

    @Override
    public void setRadii(int outerRadius, int innerRadius) {
        this.setRadii(outerRadius, innerRadius, true);
    }

    @Override
    public void setRadii(int outerRadius, int innerRadius, boolean forceRaster) {
        super.setRadii(outerRadius, innerRadius, forceRaster);
        this.updateSteps();
    }

    @Override
    public void setMMandRadii(float mm, int outerRadius, int innerRadius) {
        this.setMMandRadii(mm, outerRadius, innerRadius, true);
    }

    @Override
    public void setMMandRadii(float mm, int outerRadius, int innerRadius, boolean forceRaster) {
        super.setMMandRadii(mm, outerRadius, innerRadius, forceRaster);
        this.updateSteps();
    }

    @Override
    public void setMaximumMagnification(float mm) {
        this.setMaximumMagnification(mm, true);
    }

    @Override
    public void setMaximumMagnification(float mm, boolean forceRaster) {
        super.setMaximumMagnification(mm, forceRaster);
        this.updateSteps();
    }

    @Override
    public void gf(float x, float y, float[] g) {
        this.d = Math.sqrt((x - (float)this.sw - (float)this.lx) * (x - (float)this.sw - (float)this.lx) + (y - (float)this.sh - (float)this.ly) * (y - (float)this.sh - (float)this.ly));
        if (this.d <= (double)this.LR2) {
            g[0] = g[1] = this.MM;
        } else if (this.d <= (double)this.LR1) {
            for (int i = 0; i < this.Ri.length; ++i) {
                if (!(this.d <= (double)this.Ri[i])) continue;
                g[0] = g[1] = this.MMi[i];
                break;
            }
        } else {
            g[1] = 1.0f;
            g[0] = 1.0f;
        }
    }
}

