/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.projection.ProjPolygon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class VPolygon<T>
extends ClosedShape {
    ProjPolygon[] pc;
    double[] xcoords;
    double[] ycoords;
    double[] lxcoords;
    double[] lycoords;

    public VPolygon(Point2D.Double[] v, int z, Color c) {
        this(v, z, c, Color.BLACK, 1.0f);
    }

    public VPolygon(Point2D.Double[] v, int z, Color c, Color bc) {
        this(v, z, c, bc, 1.0f);
    }

    public VPolygon(Point2D.Double[] v, int z, Color c, Color bc, float alpha) {
        this.vx = 0.0;
        this.vy = 0.0;
        this.vz = z;
        this.xcoords = new double[v.length];
        this.ycoords = new double[v.length];
        this.lxcoords = new double[v.length];
        this.lycoords = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            this.xcoords[i] = v[i].x;
            this.ycoords[i] = v[i].y;
        }
        this.orient = 0.0;
        Point2D.Double ct = this.getCentroid();
        this.vx = ct.x;
        this.vy = ct.y;
        int i = 0;
        while (i < this.xcoords.length) {
            int n = i;
            this.xcoords[n] = this.xcoords[n] - this.vx;
            int n2 = i++;
            this.ycoords[n2] = this.ycoords[n2] - this.vy;
        }
        this.computeSize();
        this.setColor(c);
        this.setBorderColor(bc);
        this.setTranslucencyValue(alpha);
    }

    @Override
    public void initCams(int nbCam) {
        this.pc = new ProjPolygon[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjPolygon(this.xcoords.length);
        }
    }

    @Override
    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjPolygon[] ta = this.pc;
                this.pc = new ProjPolygon[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjPolygon(this.xcoords.length);
            } else {
                System.err.println("VPolygon:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjPolygon[1];
            this.pc[0] = new ProjPolygon(this.xcoords.length);
        } else {
            System.err.println("VPolygon:Error while adding camera " + verifIndex);
        }
    }

    @Override
    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    @Override
    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    @Override
    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
        this.borderColor = this.bColor;
    }

    @Override
    public double getOrient() {
        return this.orient;
    }

    @Override
    public void orientTo(double angle) {
    }

    @Override
    public double getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = 0.0;
        for (int i = 0; i < this.xcoords.length; ++i) {
            double f = Math.sqrt(this.xcoords[i] * this.xcoords[i] + this.ycoords[i] * this.ycoords[i]);
            if (!(f > this.size)) continue;
            this.size = f;
        }
        this.size *= 2.0;
    }

    @Override
    public synchronized void sizeTo(double s) {
        double ratio = s / this.size;
        this.size = 0.0;
        for (int i = 0; i < this.xcoords.length; ++i) {
            this.xcoords[i] = this.xcoords[i] * ratio;
            this.ycoords[i] = this.ycoords[i] * ratio;
            double f = Math.sqrt(this.xcoords[i] * this.xcoords[i] + this.ycoords[i] * this.ycoords[i]);
            if (!(f > this.size)) continue;
            this.size = f;
        }
        this.size *= 2.0;
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public synchronized void reSize(double factor) {
        this.size = 0.0;
        for (int i = 0; i < this.xcoords.length; ++i) {
            this.xcoords[i] = this.xcoords[i] * factor;
            this.ycoords[i] = this.ycoords[i] * factor;
            double f = Math.sqrt(this.xcoords[i] * this.xcoords[i] + this.ycoords[i] * this.ycoords[i]);
            if (!(f > this.size)) continue;
            this.size = f;
        }
        this.size *= 2.0;
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public boolean fillsView(double w, double h, int camIndex) {
        return this.alphaC == null && this.pc[camIndex].p.contains(0, 0) && this.pc[camIndex].p.contains(w, 0.0) && this.pc[camIndex].p.contains(0.0, h) && this.pc[camIndex].p.contains(w, h);
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return this.pc[camIndex].p.contains(jpx, jpy);
    }

    @Override
    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return this.pc[camIndex].p.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
    }

    @Override
    public short mouseInOut(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        if (this.coordInside(jpx, jpy, camIndex, cvx, cvy)) {
            if (!this.pc[camIndex].prevMouseIn) {
                this.pc[camIndex].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[camIndex].prevMouseIn) {
            this.pc[camIndex].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public Point2D.Double[] getVertices() {
        Point2D.Double[] res = new Point2D.Double[this.xcoords.length];
        for (int i = 0; i < this.xcoords.length; ++i) {
            res[i] = new Point2D.Double(Math.round(this.xcoords[i]), Math.round(this.ycoords[i]));
        }
        return res;
    }

    public Point2D.Double[] getAbsoluteVertices() {
        Point2D.Double[] res = new Point2D.Double[this.xcoords.length];
        for (int i = 0; i < this.xcoords.length; ++i) {
            res[i] = new Point2D.Double(Math.round(this.xcoords[i] + this.vx), Math.round(this.ycoords[i] + this.vy));
        }
        return res;
    }

    public String getVerticesAsText() {
        StringBuffer res = new StringBuffer();
        for (int i = 0; i < this.xcoords.length - 1; ++i) {
            res.append(this.xcoords[i] + this.vx + "," + this.ycoords[i] + this.vy + ";");
        }
        res.append(this.xcoords[this.xcoords.length - 1] + this.vx + "," + this.ycoords[this.ycoords.length - 1] + this.vy);
        return res.toString();
    }

    @Override
    public void project(Camera c, Dimension d) {
        int j;
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = (int)Math.round((double)(d.width / 2) + (this.vx - c.vx) * this.coef);
        this.pc[i].cy = (int)Math.round((double)(d.height / 2) - (this.vy - c.vy) * this.coef);
        this.pc[i].cr = (int)Math.round(this.size * this.coef);
        for (j = 0; j < this.xcoords.length; ++j) {
            this.pc[i].xpcoords[j] = (int)Math.round((double)this.pc[i].cx + this.xcoords[j] * this.coef);
            this.pc[i].ypcoords[j] = (int)Math.round((double)this.pc[i].cy - this.ycoords[j] * this.coef);
        }
        if (this.pc[i].p == null) {
            this.pc[i].p = new Polygon(this.pc[i].xpcoords, this.pc[i].ypcoords, this.xcoords.length);
        } else {
            this.pc[i].p.npoints = this.xcoords.length;
            for (j = 0; j < this.xcoords.length; ++j) {
                this.pc[i].p.xpoints[j] = this.pc[i].xpcoords[j];
                this.pc[i].p.ypoints[j] = this.pc[i].ypcoords[j];
            }
            this.pc[i].p.invalidate();
        }
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int j;
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.pc[i].lcx = (int)Math.round((double)(lensWidth / 2) + (this.vx - lensx) * this.coef);
        this.pc[i].lcy = (int)Math.round((double)(lensHeight / 2) - (this.vy - lensy) * this.coef);
        this.pc[i].lcr = (int)Math.round(this.size * this.coef);
        for (j = 0; j < this.xcoords.length; ++j) {
            this.pc[i].lxpcoords[j] = (int)Math.round((double)this.pc[i].lcx + this.xcoords[j] * this.coef);
            this.pc[i].lypcoords[j] = (int)Math.round((double)this.pc[i].lcy - this.ycoords[j] * this.coef);
        }
        if (this.pc[i].lp == null) {
            this.pc[i].lp = new Polygon(this.pc[i].lxpcoords, this.pc[i].lypcoords, this.xcoords.length);
        } else {
            this.pc[i].lp.npoints = this.xcoords.length;
            for (j = 0; j < this.xcoords.length; ++j) {
                this.pc[i].lp.xpoints[j] = this.pc[i].lxpcoords[j];
                this.pc[i].lp.ypoints[j] = this.pc[i].lypcoords[j];
            }
            this.pc[i].lp.invalidate();
        }
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].cr > 1) {
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.filled) {
                    g.setColor(this.color);
                    g.translate(dx, dy);
                    g.fillPolygon(this.pc[i].p);
                    g.translate(-dx, -dy);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.translate(dx, dy);
                        g.drawPolygon(this.pc[i].p);
                        g.translate(-dx, -dy);
                        g.setStroke(stdS);
                    } else {
                        g.translate(dx, dy);
                        g.drawPolygon(this.pc[i].p);
                        g.translate(-dx, -dy);
                    }
                }
                g.setComposite(acO);
            } else {
                if (this.filled) {
                    g.setColor(this.color);
                    g.translate(dx, dy);
                    g.fillPolygon(this.pc[i].p);
                    g.translate(-dx, -dy);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.translate(dx, dy);
                        g.drawPolygon(this.pc[i].p);
                        g.translate(-dx, -dy);
                        g.setStroke(stdS);
                    } else {
                        g.translate(dx, dy);
                        g.drawPolygon(this.pc[i].p);
                        g.translate(-dx, -dy);
                    }
                }
            }
        } else {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
                g.setComposite(acO);
            } else {
                g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
            }
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].lcr > 1) {
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.filled) {
                    g.setColor(this.color);
                    g.translate(dx, dy);
                    g.fillPolygon(this.pc[i].lp);
                    g.translate(-dx, -dy);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.translate(dx, dy);
                        g.drawPolygon(this.pc[i].lp);
                        g.translate(-dx, -dy);
                        g.setStroke(stdS);
                    } else {
                        g.translate(dx, dy);
                        g.drawPolygon(this.pc[i].lp);
                        g.translate(-dx, -dy);
                    }
                }
                g.setComposite(acO);
            } else {
                if (this.filled) {
                    g.setColor(this.color);
                    g.translate(dx, dy);
                    g.fillPolygon(this.pc[i].lp);
                    g.translate(-dx, -dy);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.translate(dx, dy);
                        g.drawPolygon(this.pc[i].lp);
                        g.translate(-dx, -dy);
                        g.setStroke(stdS);
                    } else {
                        g.translate(dx, dy);
                        g.drawPolygon(this.pc[i].lp);
                        g.translate(-dx, -dy);
                    }
                }
            }
        } else {
            g.setColor(this.color);
            if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
                g.setComposite(acO);
            } else {
                g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
            }
        }
    }

    public double getArea() {
        double[] xcoordsForArea = new double[this.xcoords.length];
        double[] ycoordsForArea = new double[this.ycoords.length];
        for (int i = 0; i < this.xcoords.length; ++i) {
            xcoordsForArea[i] = this.vx + this.xcoords[i];
            ycoordsForArea[i] = this.vy + this.ycoords[i];
        }
        double res = 0.0;
        for (int j = 0; j < this.xcoords.length; ++j) {
            int k = (j + 1) % this.xcoords.length;
            res += xcoordsForArea[j] * ycoordsForArea[k] - ycoordsForArea[j] * xcoordsForArea[k];
        }
        return (res /= 2.0) < 0.0 ? -res : res;
    }

    public Point2D.Double getCentroid() {
        int k;
        int j;
        double[] xcoordsForArea = new double[this.xcoords.length];
        double[] ycoordsForArea = new double[this.ycoords.length];
        for (int i = 0; i < this.xcoords.length; ++i) {
            xcoordsForArea[i] = this.vx + this.xcoords[i];
            ycoordsForArea[i] = this.vy + this.ycoords[i];
        }
        double area = 0.0;
        for (j = 0; j < this.xcoords.length; ++j) {
            k = (j + 1) % this.xcoords.length;
            area += xcoordsForArea[j] * ycoordsForArea[k] - ycoordsForArea[j] * xcoordsForArea[k];
        }
        area /= 2.0;
        double factor = 0.0;
        double cx = 0.0;
        double cy = 0.0;
        for (j = 0; j < this.xcoords.length; ++j) {
            k = (j + 1) % this.xcoords.length;
            factor = xcoordsForArea[j] * ycoordsForArea[k] - xcoordsForArea[k] * ycoordsForArea[j];
            cx += (xcoordsForArea[j] + xcoordsForArea[k]) * factor;
            cy += (ycoordsForArea[j] + ycoordsForArea[k]) * factor;
        }
        factor = 1.0 / (area *= 6.0);
        return new Point2D.Double(cx *= factor, cy *= factor);
    }

    @Override
    public Shape getJava2DShape() {
        int[] xc = new int[this.xcoords.length];
        int[] yc = new int[this.xcoords.length];
        for (int i = 0; i < this.xcoords.length; ++i) {
            xc[i] = (int)Math.round(this.xcoords[i] + this.vx);
            yc[i] = (int)Math.round(this.ycoords[i] + this.vy);
        }
        return new Polygon(xc, yc, xc.length);
    }

    @Override
    public Object clone() {
        Point2D.Double[] lps = new Point2D.Double[this.xcoords.length];
        for (int i = 0; i < lps.length; ++i) {
            lps[i] = new Point2D.Double(this.xcoords[i] + this.vx, this.ycoords[i] + this.vy);
        }
        VPolygon<T> res = new VPolygon<T>(lps, this.getZindex(), this.color, this.borderColor, this.alphaC != null ? this.alphaC.getAlpha() : 1.0f);
        res.borderColor = this.borderColor;
        res.cursorInsideColor = this.cursorInsideColor;
        res.bColor = this.bColor;
        return res;
    }
}

