/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.glyphs.PathElement;
import java.awt.Shape;
import java.awt.geom.Line2D;

class SEGElement
extends PathElement {
    Line2D[] pc;
    Line2D[] lpc;

    SEGElement(double x, double y, int nbCam) {
        this.type = 1;
        this.x = x;
        this.y = y;
        if (nbCam > 0) {
            this.initCams(nbCam);
        }
    }

    @Override
    void initCams(int nbCam) {
        this.pc = new Line2D[nbCam];
        this.lpc = new Line2D[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new Line2D.Double();
            this.lpc[i] = new Line2D.Double();
        }
    }

    @Override
    void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                Line2D[] ta = this.pc;
                this.pc = new Line2D[ta.length + 1];
                System.arraycopy(ta, 0, this.pc, 0, ta.length);
                this.pc[this.pc.length - 1] = new Line2D.Double();
                ta = this.lpc;
                this.lpc = new Line2D[ta.length + 1];
                System.arraycopy(ta, 0, this.lpc, 0, ta.length);
                this.lpc[this.lpc.length - 1] = new Line2D.Double();
            } else {
                System.err.println("DPath:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new Line2D[1];
            this.pc[0] = new Line2D.Double();
            this.lpc = new Line2D[1];
            this.lpc[0] = new Line2D.Double();
        } else {
            System.err.println("DPath:Error while adding camera " + verifIndex);
        }
    }

    @Override
    void removeCamera(int index) {
        this.pc[index] = null;
        this.lpc[index] = null;
    }

    @Override
    void project(int i, int hw, int hh, Camera c, double coef, double px, double py) {
        this.pc[i].setLine(px, py, (double)hw + (this.x - c.vx) * coef, (double)hh - (this.y - c.vy) * coef);
    }

    @Override
    void projectForLens(int i, int hw, int hh, double lx, double ly, double coef, double px, double py) {
        this.lpc[i].setLine(px, py, (double)hw + (this.x - lx) * coef, (double)hh - (this.y - ly) * coef);
    }

    @Override
    double getX(int i) {
        return this.pc[i].getX2();
    }

    @Override
    double getY(int i) {
        return this.pc[i].getY2();
    }

    @Override
    double getlX(int i) {
        return this.lpc[i].getX2();
    }

    @Override
    double getlY(int i) {
        return this.lpc[i].getY2();
    }

    @Override
    Shape getShape(int i) {
        return this.pc[i];
    }

    @Override
    Shape getlShape(int i) {
        return this.lpc[i];
    }
}

