/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.animation;

import fr.inria.zvtm.animation.TickSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Timer;

class TickThread {
    private Timer edtTimer;
    private final List<TickSource> receivers = new CopyOnWriteArrayList<TickSource>();

    public TickThread(String name) {
        ActionListener taskPerformer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (TickSource ts : TickThread.this.receivers) {
                    ts.tick();
                }
            }
        };
        this.edtTimer = new Timer(16, taskPerformer);
    }

    public void start() {
        this.edtTimer.start();
    }

    public void setResolution(int res) {
        this.edtTimer.setDelay(res);
    }

    public void addSubscriber(TickSource ts) {
        this.receivers.add(ts);
    }

    public void removeSubscriber(TickSource ts) {
        this.receivers.remove((Object)ts);
    }

    public void requestStop() {
        this.edtTimer.stop();
    }
}

