/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.widgets;

import fr.inria.zvtm.widgets.TranslucentWidget;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JRadioButton;

public class TranslucentRadioButton
extends JRadioButton
implements TranslucentWidget {
    AlphaComposite bgAC = AB_08;
    AlphaComposite bgACro = AlphaComposite.getInstance(3, 0.8f);
    AlphaComposite fgAC = AB_10;
    Color bgColro = Color.GRAY;
    Color fgColsel = Color.LIGHT_GRAY;
    Color fgCol = Color.WHITE;
    Color bgCol = Color.BLACK;
    boolean cursorInside = false;
    boolean buttonPressed = false;

    public TranslucentRadioButton() {
    }

    public TranslucentRadioButton(Action a) {
        super(a);
        this.init();
    }

    public TranslucentRadioButton(Icon icon) {
        super(icon);
        this.init();
    }

    public TranslucentRadioButton(Icon icon, boolean selected) {
        super(icon, selected);
        this.init();
    }

    public TranslucentRadioButton(String text) {
        super(text);
        this.init();
    }

    public TranslucentRadioButton(String text, boolean selected) {
        super(text, selected);
        this.init();
    }

    public TranslucentRadioButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public TranslucentRadioButton(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.init();
    }

    void init() {
        this.setOpaque(false);
        this.setContentAreaFilled(false);
        this.setBorderPainted(false);
        this.initColors();
        this.initListeners();
    }

    void initColors() {
        this.setForeground(this.fgCol);
        this.setBackground(this.bgCol);
    }

    void initListeners() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                TranslucentRadioButton.this.cursorInside = true;
                TranslucentRadioButton.this.setBackground(TranslucentRadioButton.this.bgColro);
                TranslucentRadioButton.this.repaint();
            }

            public void mouseExited(MouseEvent e) {
                TranslucentRadioButton.this.cursorInside = false;
                TranslucentRadioButton.this.setBackground(TranslucentRadioButton.this.bgCol);
                TranslucentRadioButton.this.repaint();
            }

            public void mousePressed(MouseEvent e) {
                TranslucentRadioButton.this.buttonPressed = true;
                TranslucentRadioButton.this.setForeground(TranslucentRadioButton.this.fgColsel);
                TranslucentRadioButton.this.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                TranslucentRadioButton.this.buttonPressed = false;
                TranslucentRadioButton.this.setForeground(TranslucentRadioButton.this.fgCol);
                TranslucentRadioButton.this.repaint();
            }
        });
    }

    public void setBackgroundTranslucence(float alpha) {
        this.bgAC = AlphaComposite.getInstance(3, alpha);
    }

    public void setForegroundTranslucence(float alpha) {
        this.fgAC = AlphaComposite.getInstance(3, alpha);
    }

    public void setRolloverBackgroundTranslucence(float alpha) {
        this.bgAC = AlphaComposite.getInstance(3, alpha);
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.cursorInside) {
            g2d.setComposite(this.bgACro);
        } else {
            g2d.setComposite(this.bgAC);
        }
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setComposite(this.fgAC);
        g2d.setColor(this.getForeground());
        g2d.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        super.paint(g2d);
    }
}

