/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.preferences;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.internal.archetype.ArchetypeManager;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.preferences.LocalArchetypeCatalogDialog;
import org.eclipse.m2e.core.ui.internal.preferences.RemoteArchetypeCatalogDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenArchetypesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger log = LoggerFactory.getLogger(MavenArchetypesPreferencePage.class);
    ArchetypeManager archetypeManager;
    TableViewer archetypesViewer;
    List<ArchetypeCatalogFactory> archetypeCatalogs;

    public MavenArchetypesPreferencePage() {
        this.setTitle(Messages.MavenArchetypesPreferencePage_title);
        this.archetypeManager = MavenPluginActivator.getDefault().getArchetypeManager();
    }

    protected void performDefaults() {
        Iterator<ArchetypeCatalogFactory> it = this.archetypeCatalogs.iterator();
        while (it.hasNext()) {
            ArchetypeCatalogFactory factory = it.next();
            if (!factory.isEditable()) continue;
            it.remove();
        }
        this.archetypesViewer.setInput(this.archetypeCatalogs);
        this.archetypesViewer.setSelection(null, true);
        super.performDefaults();
    }

    public boolean performOk() {
        Collection catalogs = this.archetypeManager.getArchetypeCatalogs();
        for (ArchetypeCatalogFactory factory : catalogs) {
            if (!factory.isEditable()) continue;
            this.archetypeManager.removeArchetypeCatalogFactory(factory.getId());
        }
        for (ArchetypeCatalogFactory factory : this.archetypeCatalogs) {
            if (!factory.isEditable()) continue;
            this.archetypeManager.addArchetypeCatalogFactory(factory);
        }
        try {
            this.archetypeManager.saveCatalogs();
        }
        catch (IOException ex) {
            this.setErrorMessage(NLS.bind((String)Messages.MavenArchetypesPreferencePage_error, (Object)ex.getMessage()));
            return false;
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        Link addRemoveOrLink = new Link(composite, 0);
        GridData gd_addRemoveOrLink = new GridData(4, 0x1000000, false, false, 2, 1);
        addRemoveOrLink.setLayoutData((Object)gd_addRemoveOrLink);
        addRemoveOrLink.setText(Messages.MavenArchetypesPreferencePage_link);
        addRemoveOrLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    URL url = new URL("http://maven.apache.org/plugins/maven-archetype-plugin/specification/archetype-catalog.html");
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                    browser.openURL(url);
                }
                catch (MalformedURLException ex) {
                    log.error("Malformed URL", (Throwable)ex);
                }
                catch (PartInitException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            }
        });
        this.archetypesViewer = new TableViewer(composite, 67584);
        this.archetypesViewer.setLabelProvider((IBaseLabelProvider)new CatalogsLabelProvider());
        this.archetypesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object input) {
                if (input instanceof Collection) {
                    return ((Collection)input).toArray();
                }
                return new Object[0];
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        Table table = this.archetypesViewer.getTable();
        table.setLinesVisible(false);
        table.setHeaderVisible(false);
        table.setLayoutData((Object)new GridData(4, 4, true, false, 1, 4));
        TableColumn typeColumn = new TableColumn(table, 0);
        typeColumn.setWidth(250);
        typeColumn.setText("");
        Button addLocalButton = new Button(composite, 0);
        addLocalButton.setLayoutData((Object)new GridData(4, 128, false, false));
        addLocalButton.setText(Messages.MavenArchetypesPreferencePage_btnAddLocal);
        addLocalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalArchetypeCatalogDialog dialog = new LocalArchetypeCatalogDialog(MavenArchetypesPreferencePage.this.getShell(), null);
                if (dialog.open() == 0) {
                    MavenArchetypesPreferencePage.this.addCatalogFactory(dialog.getArchetypeCatalogFactory());
                }
            }
        });
        Button addRemoteButton = new Button(composite, 0);
        addRemoteButton.setLayoutData((Object)new GridData(4, 128, false, false));
        addRemoteButton.setText(Messages.MavenArchetypesPreferencePage_btnAddRemote);
        addRemoteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteArchetypeCatalogDialog dialog = new RemoteArchetypeCatalogDialog(MavenArchetypesPreferencePage.this.getShell(), null);
                if (dialog.open() == 0) {
                    MavenArchetypesPreferencePage.this.addCatalogFactory(dialog.getArchetypeCatalogFactory());
                }
            }
        });
        final Button editButton = new Button(composite, 0);
        editButton.setLayoutData((Object)new GridData(4, 128, false, false));
        editButton.setEnabled(false);
        editButton.setText(Messages.MavenArchetypesPreferencePage_btnEdit);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int n;
                TitleAreaDialog dialog;
                ArchetypeCatalogFactory factory = MavenArchetypesPreferencePage.this.getSelectedArchetypeCatalogFactory();
                ArchetypeCatalogFactory newFactory = null;
                if (factory instanceof ArchetypeCatalogFactory.LocalCatalogFactory) {
                    dialog = new LocalArchetypeCatalogDialog(MavenArchetypesPreferencePage.this.getShell(), factory);
                    if (dialog.open() == 0) {
                        newFactory = dialog.getArchetypeCatalogFactory();
                    }
                } else if (factory instanceof ArchetypeCatalogFactory.RemoteCatalogFactory && (dialog = new RemoteArchetypeCatalogDialog(MavenArchetypesPreferencePage.this.getShell(), factory)).open() == 0) {
                    newFactory = dialog.getArchetypeCatalogFactory();
                }
                if (newFactory != null && (n = MavenArchetypesPreferencePage.this.archetypeCatalogs.indexOf(factory)) > -1) {
                    MavenArchetypesPreferencePage.this.archetypeCatalogs.set(n, newFactory);
                    MavenArchetypesPreferencePage.this.archetypesViewer.setInput(MavenArchetypesPreferencePage.this.archetypeCatalogs);
                    MavenArchetypesPreferencePage.this.archetypesViewer.setSelection((ISelection)new StructuredSelection((Object)newFactory), true);
                }
            }
        });
        final Button removeButton = new Button(composite, 0);
        removeButton.setEnabled(false);
        removeButton.setLayoutData((Object)new GridData(4, 128, false, true));
        removeButton.setText(Messages.MavenArchetypesPreferencePage_btnRemove);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchetypeCatalogFactory factory = MavenArchetypesPreferencePage.this.getSelectedArchetypeCatalogFactory();
                MavenArchetypesPreferencePage.this.archetypeCatalogs.remove(factory);
                MavenArchetypesPreferencePage.this.archetypesViewer.setInput(MavenArchetypesPreferencePage.this.archetypeCatalogs);
                MavenArchetypesPreferencePage.this.archetypesViewer.setSelection(null, true);
            }
        });
        this.archetypesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (MavenArchetypesPreferencePage.this.archetypesViewer.getSelection() instanceof IStructuredSelection) {
                    ArchetypeCatalogFactory factory = MavenArchetypesPreferencePage.this.getSelectedArchetypeCatalogFactory();
                    boolean isEnabled = factory != null && factory.isEditable();
                    removeButton.setEnabled(isEnabled);
                    editButton.setEnabled(isEnabled);
                }
            }
        });
        this.archetypeCatalogs = new ArrayList<ArchetypeCatalogFactory>(this.archetypeManager.getArchetypeCatalogs());
        this.archetypesViewer.setInput(this.archetypeCatalogs);
        this.archetypesViewer.refresh();
        return composite;
    }

    protected ArchetypeCatalogFactory getSelectedArchetypeCatalogFactory() {
        IStructuredSelection selection = (IStructuredSelection)this.archetypesViewer.getSelection();
        return (ArchetypeCatalogFactory)selection.getFirstElement();
    }

    private void addCatalogFactory(ArchetypeCatalogFactory factory) {
        if (factory == null) {
            return;
        }
        this.archetypeCatalogs.add(factory);
        if (!this.archetypesViewer.getControl().isDisposed()) {
            this.archetypesViewer.setInput(this.archetypeCatalogs);
            this.archetypesViewer.setSelection((ISelection)new StructuredSelection((Object)factory), true);
        }
    }

    static class CatalogsLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private Color disabledColor = Display.getCurrent().getSystemColor(16);

        CatalogsLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ArchetypeCatalogFactory factory = (ArchetypeCatalogFactory)element;
            if (factory instanceof ArchetypeCatalogFactory.LocalCatalogFactory) {
                return NLS.bind((String)Messages.MavenArchetypesPreferencePage_local, (Object)factory.getDescription());
            }
            if (factory instanceof ArchetypeCatalogFactory.RemoteCatalogFactory) {
                if (factory.isEditable()) {
                    return NLS.bind((String)Messages.MavenArchetypesPreferencePage_remote, (Object)factory.getDescription());
                }
                return NLS.bind((String)Messages.MavenArchetypesPreferencePage_packaged, (Object)factory.getDescription());
            }
            return factory.getDescription();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            ArchetypeCatalogFactory factory = (ArchetypeCatalogFactory)element;
            return !factory.isEditable() ? this.disabledColor : null;
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

