/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.views.msc.model.MSCModel;
import org.eclipse.titan.log.viewer.views.msc.ui.core.BasicFrame;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Lifeline;
import org.eclipse.titan.log.viewer.views.msc.ui.core.LifelineHeader;
import org.eclipse.titan.log.viewer.views.msc.ui.core.MSCNode;
import org.eclipse.titan.log.viewer.views.msc.ui.core.SetverdictUnknown;
import org.eclipse.titan.log.viewer.views.msc.ui.view.IGC;
import org.eclipse.titan.log.viewer.views.msc.util.MSCConstants;
import org.eclipse.titan.log.viewer.views.msc.util.MSCNodeComparator;

public class Frame
extends BasicFrame {
    private MSCModel model;
    private boolean hasChildren = false;
    private List<Lifeline> lifelineNodes;
    private List<LifelineHeader> lifelineHeaderNodes;
    private MSCNodeComparator comparator = new MSCNodeComparator();
    private int selectedLine = 3;
    private String name = "";
    private List<MSCNode> nodeCache = null;

    public Frame(MSCModel model) {
        this.model = model;
    }

    public MSCModel getModel() {
        return this.model;
    }

    public void setName(String nodeName) {
        this.name = nodeName;
    }

    public String getName() {
        return this.name;
    }

    public Lifeline getLifeline(int index) {
        if (this.getLifelines() != null && index >= 0 && index < this.lifeLinesCount()) {
            return this.getLifelines().get(index);
        }
        return null;
    }

    public int lifeLinesCount() {
        List<Lifeline> lifelines = this.getLifelines();
        if (lifelines != null) {
            return lifelines.size();
        }
        return 0;
    }

    private List<Lifeline> getLifelines() {
        if (!this.hasChildren) {
            return new ArrayList<Lifeline>();
        }
        return this.lifelineNodes;
    }

    public void moveLifeLineToPosition(Lifeline lifeLine, int position) {
        if (position == lifeLine.getIndex() || position > this.lifeLinesCount()) {
            return;
        }
        int oldPosition = lifeLine.getIndex();
        if (oldPosition > position) {
            this.moveLeft(oldPosition, position);
        } else {
            this.moveRight(oldPosition, position);
        }
        lifeLine.setIndex(position);
        Collections.sort(this.getLifelines(), this.comparator);
    }

    private void moveLeft(int oldPosition, int newPosition) {
        List<Lifeline> lifelines = this.getLifelines();
        for (Lifeline currLifeLine : lifelines) {
            int currLifeLineIndex = currLifeLine.getIndex();
            if (currLifeLineIndex >= oldPosition || currLifeLineIndex < newPosition) continue;
            currLifeLine.setIndex(currLifeLineIndex + 1);
        }
    }

    private void moveRight(int oldPosition, int newPosition) {
        List<Lifeline> lifelines = this.getLifelines();
        for (Lifeline currLifeLine : lifelines) {
            int currLifeLineIndex = currLifeLine.getIndex();
            if (currLifeLineIndex <= oldPosition || currLifeLineIndex > newPosition) continue;
            currLifeLine.setIndex(currLifeLineIndex - 1);
        }
    }

    public void addLifeLine(Lifeline lifeLine) {
        if (lifeLine == null) {
            return;
        }
        lifeLine.setFrame(this);
        lifeLine.setIndex(this.getNewHorizontalIndex());
        if (!this.hasChildren) {
            this.lifelineNodes = new ArrayList<Lifeline>();
            this.lifelineHeaderNodes = new ArrayList<LifelineHeader>();
            this.hasChildren = true;
        }
        this.lifelineNodes.add(lifeLine);
    }

    public void addLifeLineHeader(LifelineHeader lifeLineHeader) {
        if (!this.hasChildren) {
            this.lifelineNodes = new ArrayList<Lifeline>();
            this.lifelineHeaderNodes = new ArrayList<LifelineHeader>();
            this.hasChildren = true;
        }
        this.lifelineHeaderNodes.add(lifeLineHeader);
    }

    public Lifeline getCloserLifeline(int x) {
        int index = x / MSCConstants.COLUMN_WIDTH - 1;
        if (index < 0) {
            index = 0;
        }
        if (index > this.lifeLinesCount()) {
            index = this.lifeLinesCount();
        }
        return this.getLifeline(index);
    }

    public MSCNode getNodeAt(int x, int y) {
        if (!this.hasChildren) {
            return null;
        }
        MSCNode toReturn = this.getHeaderNodeFromListAt(x, y, this.lifelineHeaderNodes, 0);
        if (toReturn != null) {
            return toReturn;
        }
        if (this.nodeCache == null) {
            return null;
        }
        return this.getNodeFromListAt(x, y, this.nodeCache, 0);
    }

    protected void drawChildsNodes(IGC context) {
        if (!this.hasChildren) {
            return;
        }
        int arrayStep = 1;
        if ((float)(MSCConstants.getFontHeight() + 20) * context.getZoom() < 1.0f) {
            arrayStep = Math.round(1.0f / ((float)(MSCConstants.getFontHeight() + 20) * context.getZoom()));
        }
        this.drawLifeLineNodes(context, this.lifelineNodes, 0, arrayStep);
        int yStart = (context.getContentsY() - 5) / MSCConstants.ROW_HEIGHT;
        int yEnd = (context.getContentsY() + context.getVisibleHeight() - 5) / MSCConstants.ROW_HEIGHT;
        this.nodeCache = this.model.getNodes(yStart, yEnd + 3);
        this.drawNodes(context, this.nodeCache, 0, arrayStep);
        this.drawLifeLineNodes(context, this.lifelineHeaderNodes, 0, arrayStep);
    }

    private int drawLifeLineNodes(IGC context, List<? extends MSCNode> list, int startIndex, int step) {
        if (!this.hasChildren || list.size() < 0) {
            return 0;
        }
        int nodesCount = 0;
        int contextX = context.getContentsX();
        int contextY = context.getContentsY();
        int contextWidth = context.getVisibleWidth();
        int contextHeight = context.getVisibleHeight();
        for (int i = startIndex; i < list.size(); i += step) {
            MSCNode toDraw = list.get(i);
            if (!toDraw.isVisible(contextX, contextY, contextWidth, contextHeight)) continue;
            toDraw.draw(context);
            ++nodesCount;
        }
        return nodesCount;
    }

    private int drawNodes(IGC context, List<MSCNode> list, int startIndex, int step) {
        if (!this.hasChildren || list.size() < 0) {
            return 0;
        }
        int contextX = context.getContentsX();
        int contextY = context.getContentsY();
        int contextWidth = context.getVisibleWidth();
        int contextHeight = context.getVisibleHeight();
        ArrayList<MSCNode> shouldBeDrawn = new ArrayList<MSCNode>();
        for (int i = startIndex; i < list.size(); i += step) {
            MSCNode toDraw = list.get(i);
            if (!toDraw.isVisible(contextX, contextY, contextWidth, contextHeight)) continue;
            shouldBeDrawn.add(toDraw);
        }
        for (MSCNode temp : shouldBeDrawn) {
            if (temp instanceof SetverdictUnknown) {
                ((SetverdictUnknown)temp).setNumLifelines(this.lifeLinesCount());
            }
            temp.draw(context);
        }
        return shouldBeDrawn.size();
    }

    public void draw(IGC context) {
        if (!this.hasChildren) {
            return;
        }
        int x = 0;
        int y = MSCConstants.ROW_HEIGHT * this.selectedLine + MSCConstants.ROW_HEIGHT;
        int width = this.getWidth();
        int height = MSCConstants.ROW_HEIGHT;
        context.setBackground((Color)Activator.getDefault().getCachedResource("COLOR_LIGHTER_GREY"));
        context.fillRectangle(x, y, width, height);
        this.setVisibleArea(context.getContentsX(), context.getContentsY(), context.getVisibleWidth(), context.getVisibleHeight());
        this.drawChildsNodes(context);
    }

    public int getSelectedLine() {
        return this.selectedLine;
    }

    public void setSelectedLine(int selectedLine) {
        this.selectedLine = selectedLine < 4 ? 3 : (selectedLine > this.getMaxEventOccurrence() - 4 ? this.getMaxEventOccurrence() - 4 : selectedLine);
    }
}

