/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.model;

import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.parsers.data.LogRecord;
import org.eclipse.titan.log.viewer.readers.ValueReader;
import org.eclipse.titan.log.viewer.utils.Constants;
import org.eclipse.titan.log.viewer.views.msc.model.EventObject;
import org.eclipse.titan.log.viewer.views.msc.model.ExecutionModel;
import org.eclipse.titan.log.viewer.views.msc.model.IEventObject;
import org.eclipse.titan.log.viewer.views.msc.model.TestComponent;
import org.eclipse.titan.log.viewer.views.msc.ui.core.ComponentCreation;
import org.eclipse.titan.log.viewer.views.msc.ui.core.ComponentTermination;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Enqueued;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Frame;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Function;
import org.eclipse.titan.log.viewer.views.msc.ui.core.FunctionDone;
import org.eclipse.titan.log.viewer.views.msc.ui.core.FunctionNode;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Lifeline;
import org.eclipse.titan.log.viewer.views.msc.ui.core.LifelineHeader;
import org.eclipse.titan.log.viewer.views.msc.ui.core.MSCNode;
import org.eclipse.titan.log.viewer.views.msc.ui.core.PortConnection;
import org.eclipse.titan.log.viewer.views.msc.ui.core.PortDisconnection;
import org.eclipse.titan.log.viewer.views.msc.ui.core.PortEventNode;
import org.eclipse.titan.log.viewer.views.msc.ui.core.PortMapping;
import org.eclipse.titan.log.viewer.views.msc.ui.core.PortUnmapping;
import org.eclipse.titan.log.viewer.views.msc.ui.core.ReceiveSignal;
import org.eclipse.titan.log.viewer.views.msc.ui.core.SendSignal;
import org.eclipse.titan.log.viewer.views.msc.ui.core.SetverdictComp;
import org.eclipse.titan.log.viewer.views.msc.ui.core.SetverdictUnknown;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Signal;
import org.eclipse.titan.log.viewer.views.msc.ui.core.SilentEvent;
import org.eclipse.titan.log.viewer.views.msc.ui.core.TestCaseEnd;
import org.eclipse.titan.log.viewer.views.msc.ui.core.TestCaseStart;
import org.eclipse.titan.log.viewer.views.msc.ui.core.TimeStampNode;

public class MSCModel {
    private ExecutionModel model;
    private Map<String, Lifeline> lifelines;
    private Lifeline sutLifeline;
    private Frame frame;
    private URI logFilePath;
    private String sutName;
    private static final int MAX_CHARS = 100;

    public MSCModel(ExecutionModel model, LogFileMetaData logFileMetaData, String sutName) {
        this.model = model;
        this.logFilePath = logFileMetaData.getFilePath();
        this.sutName = sutName;
        this.lifelines = new HashMap<String, Lifeline>();
    }

    public Frame getModelFrame() {
        if (this.model == null) {
            return null;
        }
        this.frame = new Frame(this);
        this.frame.setName(this.model.getTestCase().getTestCaseName());
        List<EventObject> events = this.model.getLifelineInformation();
        if (this.sutLifeline == null) {
            this.sutLifeline = new Lifeline();
        }
        for (EventObject event : events) {
            int eventNumber = event.getEventNumber();
            this.sutLifeline.setCurrentEventOccurrence(eventNumber);
            this.extractLifeLineAndHeaderNodes(event, eventNumber);
        }
        this.sutLifeline.setCurrentEventOccurrence(this.model.getNumberOfEvents());
        return this.frame;
    }

    public List<MSCNode> getNodes(int startIndex, int endIndex) {
        MSCNode[] nodes;
        int i;
        if (this.sutLifeline == null) {
            this.sutLifeline = new Lifeline();
        }
        List<IEventObject> events = this.model.getEvents(startIndex, endIndex);
        ArrayList<MSCNode> result = new ArrayList<MSCNode>();
        for (i = 0; i < 3; ++i) {
            for (MSCNode node : nodes = this.extractNodes(events.get(i), i)) {
                if (node instanceof Lifeline || node instanceof LifelineHeader) continue;
                result.add(node);
            }
        }
        for (i = 3; i < events.size(); ++i) {
            for (MSCNode node : nodes = this.extractNodes(events.get(i), startIndex + i)) {
                if (node instanceof Lifeline || node instanceof LifelineHeader) continue;
                result.add(node);
            }
        }
        return result;
    }

    private void extractLifeLineAndHeaderNodes(IEventObject ievent, int occurrence) {
        if (!(ievent instanceof EventObject)) {
            return;
        }
        EventObject event = (EventObject)ievent;
        String ref = event.getReference();
        String time = event.getTime();
        switch (event.getType()) {
            case SYSTEM_CREATE: {
                ref = "system";
                this.createLifelineAndHeaderComponent(ref, time, this.sutLifeline, occurrence);
                break;
            }
            case HC_CREATE: {
                ref = "hc";
                this.createLifelineAndHeaderComponent(ref, time, new Lifeline(), occurrence);
                break;
            }
            case MTC_CREATE: {
                ref = "mtc";
                if (this.lifelines.get(ref) == null) {
                    this.createLifelineAndHeaderComponent(ref, time, new Lifeline(), occurrence);
                    break;
                }
                this.createLifelineAndHeaderComponent(ref, time, this.lifelines.get(ref), occurrence);
                break;
            }
            case PTC_CREATE: {
                this.createLifelineAndHeaderComponent(ref, time, new Lifeline(), occurrence);
                break;
            }
            case SYSTEM_TERMINATE: {
                ref = "system";
                this.terminateLifeLineComponent(ref, time, occurrence);
                break;
            }
            case HC_TERMINATE: {
                ref = "hc";
                this.terminateLifeLineComponent(ref, time, occurrence);
                break;
            }
            case MTC_TERMINATE: {
                ref = "mtc";
                this.terminateLifeLineComponent(ref, time, occurrence);
                break;
            }
            case PTC_TERMINATE: {
                this.terminateLifeLineComponent(ref, time, occurrence);
                break;
            }
        }
    }

    private void createLifelineAndHeaderComponent(String ref, String time, Lifeline lifeline, int occurrence) {
        if (this.lifelines.containsKey(ref)) {
            return;
        }
        this.lifelines.put(ref, lifeline);
        String name = this.getComponentNameFromReference(ref);
        lifeline.setName(name);
        this.frame.addLifeLine(lifeline);
        LifelineHeader lifeLineHeader = new LifelineHeader(lifeline, this.frame);
        if (!(name.contentEquals(this.sutName) || name.contentEquals("MTC") || name.contentEquals(ref))) {
            name = name + " (" + ref + ")";
        }
        lifeLineHeader.setName(name);
        this.frame.addLifeLineHeader(lifeLineHeader);
        lifeline.setCurrentEventOccurrence(occurrence);
        ComponentCreation start = new ComponentCreation(occurrence, lifeline);
        start.setName(name);
        lifeline.setStart(start);
    }

    private void terminateLifeLineComponent(String ref, String time, int occurrence) {
        Lifeline tmpLifeline = this.lifelines.get(ref);
        if (tmpLifeline == null) {
            return;
        }
        String name = this.getComponentNameFromReference(ref);
        if (!(name.contentEquals(this.sutName) || name.contentEquals("MTC") || name.contentEquals(ref))) {
            name = name + " (" + ref + ")";
        }
        String verdict = this.getComponentVerdictFromReference(ref);
        ComponentTermination stop = new ComponentTermination(occurrence, tmpLifeline, verdict);
        stop.setName(name);
        tmpLifeline.setStop(stop);
    }

    private MSCNode[] extractNodes(IEventObject ievent, int occurrence) {
        if (!(ievent instanceof EventObject)) {
            return new MSCNode[0];
        }
        EventObject event = (EventObject)ievent;
        String ref = event.getReference();
        String target = event.getTarget();
        String name = event.getName();
        String time = event.getTime();
        String type = event.getEventType();
        String sourcePort = event.getPort();
        String targetPort = event.getTargetPort();
        switch (event.getType()) {
            case TC_START: {
                return this.testCaseStart(name, time, this.frame.lifeLinesCount(), occurrence);
            }
            case TC_END: {
                return this.testCaseEnd(name, time, this.frame.lifeLinesCount(), occurrence);
            }
            case SYSTEM_CREATE: {
                ref = "system";
                return this.createComponent(ref, time, this.lifelines.get(ref), occurrence);
            }
            case HC_CREATE: {
                ref = "hc";
                return this.createComponent(ref, time, this.lifelines.get(ref), occurrence);
            }
            case MTC_CREATE: {
                ref = "mtc";
                Lifeline lifeLine = this.lifelines.get(ref);
                return this.createComponent(ref, time, lifeLine, occurrence);
            }
            case PTC_CREATE: {
                return this.createComponent(ref, time, this.lifelines.get(ref), occurrence);
            }
            case SYSTEM_TERMINATE: {
                ref = "system";
                return this.terminateComponent(ref, time, occurrence);
            }
            case HC_TERMINATE: {
                ref = "hc";
                return this.terminateComponent(ref, time, occurrence);
            }
            case MTC_TERMINATE: {
                ref = "mtc";
                return this.terminateComponent(ref, time, occurrence);
            }
            case PTC_TERMINATE: {
                return this.terminateComponent(ref, time, occurrence);
            }
            case SEND: {
                return this.addSignal(new SendSignal(), ref, target, name, time, occurrence);
            }
            case RECEIVE: {
                return this.addSignal(new ReceiveSignal(), ref, target, name, time, occurrence);
            }
            case ENQUEUED: {
                return this.addEnqueued(ref, target, name, time, occurrence);
            }
            case SILENT_EVENT: {
                LogRecord logrecord = null;
                try {
                    logrecord = ValueReader.getInstance().readLogRecordFromLogFile(this.logFilePath, event);
                }
                catch (IOException valueException) {
                    return this.addSilentEvent(ref, "", type, time, occurrence);
                }
                catch (ParseException e) {
                    return this.addSilentEvent(ref, "", type, time, occurrence);
                }
                String messageText = this.getMessageTextFromRecord(logrecord);
                return this.addSilentEvent(ref, messageText, type, time, occurrence);
            }
            case FUNCTION: {
                return this.addFunctionNode(new Function(), ref, target, name, time, occurrence);
            }
            case PTC_DONE: {
                return this.addFunctionNode(new FunctionDone(), ref, target, name, time, occurrence);
            }
            case SETVERDICT: 
            case SETVERDICT_INCONC: 
            case SETVERDICT_NONE: 
            case SETVERDICT_PASS: {
                return this.addSetVerdict(ref, name, time, occurrence);
            }
            case MAPPING_PORT: {
                return this.addPortEventNode(new PortMapping(sourcePort, targetPort), ref, target, time, occurrence);
            }
            case UNMAPPING_PORT: {
                return this.addPortEventNode(new PortUnmapping(sourcePort, targetPort), ref, target, time, occurrence);
            }
            case CONNECTING_PORT: {
                return this.addPortEventNode(new PortConnection(sourcePort, targetPort), ref, target, time, occurrence);
            }
            case DISCONNECTING_PORT: {
                return this.addPortEventNode(new PortDisconnection(sourcePort, targetPort), ref, target, time, occurrence);
            }
        }
        return new MSCNode[0];
    }

    private String getMessageTextFromRecord(LogRecord logrecord) {
        String messageText = "";
        if (logrecord != null) {
            messageText = logrecord.getMessage();
        }
        messageText = messageText.trim();
        if ((messageText = messageText.replaceAll("\r\n", "\n")).length() > 100) {
            messageText = messageText.substring(0, 100).trim() + " ...\n\n for more, use Value View.";
        }
        return messageText;
    }

    private MSCNode[] testCaseStart(String name, String time, int width, int occurrence) {
        TestCaseStart testCaseStart = new TestCaseStart(occurrence, width);
        testCaseStart.setName(name);
        return new MSCNode[]{testCaseStart, new TimeStampNode(occurrence, time)};
    }

    private MSCNode[] testCaseEnd(String name, String time, int width, int occurrence) {
        TestCaseEnd testCaseEnd = new TestCaseEnd(occurrence, name, width);
        testCaseEnd.setName(name);
        return new MSCNode[]{testCaseEnd, new TimeStampNode(occurrence, time)};
    }

    private MSCNode[] createComponent(String ref, String time, Lifeline lifeline, int occurrence) {
        String name = this.getComponentNameFromReference(ref);
        if (!(name.contentEquals(this.sutName) || name.contentEquals("MTC") || name.contentEquals(ref))) {
            name = name + " (" + ref + ")";
        }
        ComponentCreation start = new ComponentCreation(occurrence, lifeline);
        start.setName(name);
        return new MSCNode[]{start, new TimeStampNode(occurrence, time)};
    }

    private MSCNode[] terminateComponent(String ref, String time, int occurrence) {
        Lifeline tmpLifeline = this.lifelines.get(ref);
        if (tmpLifeline == null) {
            return new MSCNode[0];
        }
        String name = this.getComponentNameFromReference(ref);
        if (!(name.contentEquals(this.sutName) || name.contentEquals("MTC") || name.contentEquals(ref))) {
            name = name + " (" + ref + ")";
        }
        String verdict = this.getComponentVerdictFromReference(ref);
        ComponentTermination stop = new ComponentTermination(occurrence, tmpLifeline, verdict);
        stop.setName(name);
        tmpLifeline.setStop(stop);
        return new MSCNode[]{stop, new TimeStampNode(occurrence, time)};
    }

    private MSCNode[] addSignal(Signal signal, String ref, String target, String name, String time, int occurrence) {
        Lifeline source = this.lifelines.get(ref);
        Lifeline dest = this.lifelines.get(target);
        if (source == null || dest == null) {
            return new MSCNode[0];
        }
        source.setCurrentEventOccurrence(occurrence);
        dest.setCurrentEventOccurrence(occurrence);
        signal.setStartLifeline(source);
        signal.setEndLifeline(dest);
        signal.setName(name);
        return new MSCNode[]{signal, new TimeStampNode(occurrence, time)};
    }

    private MSCNode[] addEnqueued(String ref, String target, String name, String time, int occurrence) {
        Enqueued message = new Enqueued();
        Lifeline source = this.lifelines.get(ref);
        Lifeline dest = this.lifelines.get(target);
        if (source == null || dest == null) {
            return new MSCNode[0];
        }
        source.setCurrentEventOccurrence(occurrence);
        dest.setCurrentEventOccurrence(occurrence);
        message.setStartLifeline(source);
        message.setEndLifeline(dest);
        message.setName(name);
        return new MSCNode[]{message, new TimeStampNode(occurrence, time)};
    }

    private MSCNode[] addSilentEvent(String ref, String name, String type, String time, int occurrence) {
        String silentEventType = null;
        Set<String> types = Constants.EVENT_CATEGORIES.keySet();
        for (String currType : types) {
            if (!type.startsWith(currType)) continue;
            silentEventType = currType;
            break;
        }
        if (silentEventType == null) {
            return new MSCNode[0];
        }
        Lifeline tmpLifeline = this.lifelines.get(ref);
        if (tmpLifeline == null) {
            return new MSCNode[0];
        }
        SilentEvent silentEvent = new SilentEvent(occurrence, tmpLifeline, type);
        silentEvent.setName(type + "\n" + name);
        return new MSCNode[]{silentEvent, new TimeStampNode(occurrence, time)};
    }

    private MSCNode[] addFunctionNode(FunctionNode function, String ref, String target, String name, String time, int occurrence) {
        Lifeline source = this.lifelines.get(ref);
        Lifeline destination = this.lifelines.get(target);
        if (source == null || destination == null) {
            return new MSCNode[0];
        }
        source.setCurrentEventOccurrence(occurrence);
        destination.setCurrentEventOccurrence(occurrence);
        function.setStartLifeline(source);
        function.setEndLifeline(destination);
        function.setName(name);
        return new MSCNode[]{function, new TimeStampNode(occurrence, time)};
    }

    private MSCNode[] addPortEventNode(PortEventNode portEventNode, String ref, String target, String time, int occurrence) {
        Lifeline source = this.lifelines.get(ref);
        Lifeline destination = this.lifelines.get(target);
        if (source == null || destination == null) {
            return new MSCNode[0];
        }
        source.setCurrentEventOccurrence(occurrence);
        destination.setCurrentEventOccurrence(occurrence);
        portEventNode.setStartLifeline(source);
        portEventNode.setEndLifeline(destination);
        return new MSCNode[]{portEventNode, new TimeStampNode(occurrence, time)};
    }

    private MSCNode[] addSetVerdict(String ref, String name, String time, int occurrence) {
        MSCNode[] temp = new MSCNode[2];
        if (ref == null || ref.length() == 0) {
            SetverdictUnknown setverdictUnknown = new SetverdictUnknown(occurrence, name);
            setverdictUnknown.setName(name);
            temp[0] = setverdictUnknown;
        } else {
            Lifeline tmpLifeline = this.lifelines.get(ref);
            if (tmpLifeline == null) {
                return new MSCNode[0];
            }
            SetverdictComp setverdictComp = new SetverdictComp(occurrence, tmpLifeline, name);
            setverdictComp.setName(name);
            temp[0] = setverdictComp;
        }
        temp[1] = new TimeStampNode(occurrence, time);
        return temp;
    }

    private String getComponentNameFromReference(String ref) {
        TestComponent component;
        if (ref.contentEquals("mtc")) {
            return "MTC";
        }
        if (ref.contentEquals("system")) {
            return this.sutName;
        }
        Map<String, TestComponent> components = this.model.getComponents();
        if (components != null && (component = components.get(ref)) != null) {
            if (component.getName().trim().length() > 0) {
                return component.getName();
            }
            return ref;
        }
        return ref;
    }

    private String getComponentVerdictFromReference(String ref) {
        TestComponent component;
        Map<String, TestComponent> components = this.model.getComponents();
        if (components != null && (component = components.get(ref)) != null) {
            return component.getVerdict();
        }
        return "none";
    }
}

