/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.AddSourceFolderWizard;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.MultipleFolderSelectionDialog;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.actions.AbstractOpenWizardAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CreateMultipleSourceFoldersDialog
extends TrayDialog {
    private final IJavaProject fJavaProject;
    private final CPListElement[] fExistingElements;
    private String fOutputLocation;
    private final HashSet<CPListElement> fRemovedElements;
    private final HashSet<CPListElement> fModifiedElements;
    private final HashSet<CPListElement> fInsertedElements;
    private final Hashtable<IFolder, IContainer> fNonExistingFolders;

    public CreateMultipleSourceFoldersDialog(IJavaProject javaProject, CPListElement[] existingElements, String outputLocation, Shell shell) {
        super(shell);
        this.fJavaProject = javaProject;
        this.fExistingElements = existingElements;
        this.fOutputLocation = outputLocation;
        this.fRemovedElements = new HashSet();
        this.fModifiedElements = new HashSet();
        this.fInsertedElements = new HashSet();
        this.fNonExistingFolders = new Hashtable();
        int i = 0;
        while (i < existingElements.length) {
            CPListElement cur = existingElements[i];
            if (cur.getResource() == null || !cur.getResource().exists()) {
                this.addFakeFolder((IContainer)this.fJavaProject.getProject(), cur);
            }
            ++i;
        }
    }

    public int open() {
        Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
        List<IResource> existingContainers = this.getExistingContainers(this.fExistingElements);
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        IProject currProject = this.fJavaProject.getProject();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)currProject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray()){

            @Override
            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IFolder && ((IFolder)element).isVirtual()) {
                    return false;
                }
                return super.select(viewer, parentElement, element);
            }
        };
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        FakeFolderBaseWorkbenchContentProvider cp = new FakeFolderBaseWorkbenchContentProvider();
        String title = NewWizardMessages.SourceContainerWorkbookPage_ExistingSourceFolderDialog_new_title;
        String message = NewWizardMessages.SourceContainerWorkbookPage_ExistingSourceFolderDialog_edit_description;
        MultipleFolderSelectionDialog dialog = new MultipleFolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp){

            @Override
            protected Control createDialogArea(Composite parent) {
                Control result = super.createDialogArea(parent);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.jdt.ui.bp_choose_existing_folder_to_make_source_folder");
                return result;
            }

            @Override
            protected Object createFolder(IContainer container) {
                final Object[] result = new Object[1];
                final CPListElement newElement = new CPListElement(CreateMultipleSourceFoldersDialog.this.fJavaProject, 3);
                final AddSourceFolderWizard wizard = CreateMultipleSourceFoldersDialog.this.newSourceFolderWizard(newElement, CreateMultipleSourceFoldersDialog.this.fExistingElements, CreateMultipleSourceFoldersDialog.this.fOutputLocation, container);
                AbstractOpenWizardAction action = new AbstractOpenWizardAction(){

                    @Override
                    protected INewWizard createWizard() throws CoreException {
                        return wizard;
                    }
                };
                action.addPropertyChangeListener(new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getProperty().equals("result")) {
                            if (event.getNewValue().equals(Boolean.TRUE)) {
                                result[0] = CreateMultipleSourceFoldersDialog.this.addFakeFolder((IContainer)CreateMultipleSourceFoldersDialog.this.fJavaProject.getProject(), newElement);
                            } else {
                                wizard.cancel();
                            }
                        }
                    }
                });
                action.run();
                return result[0];
            }
        };
        dialog.setExisting(existingContainers.toArray());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter(filter);
        dialog.setInput(this.fJavaProject.getProject().getParent());
        dialog.setInitialFocus(this.fJavaProject.getProject());
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            int i2 = 0;
            while (i2 < elements.length) {
                IResource res = (IResource)elements[i2];
                this.fInsertedElements.add(new CPListElement(this.fJavaProject, 3, res.getFullPath(), res));
                ++i2;
            }
            if (this.fExistingElements.length == 1) {
                CPListElement existingElement = this.fExistingElements[0];
                if (existingElement.getResource() instanceof IProject && !this.removeProjectFromBP(existingElement)) {
                    ArrayList<CPListElement> added = new ArrayList<CPListElement>(this.fInsertedElements);
                    HashSet<CPListElement> updatedEclusionPatterns = new HashSet<CPListElement>();
                    this.addExlusionPatterns(added, updatedEclusionPatterns);
                    this.fModifiedElements.addAll(updatedEclusionPatterns);
                }
            } else {
                ArrayList<CPListElement> added = new ArrayList<CPListElement>(this.fInsertedElements);
                HashSet<CPListElement> updatedEclusionPatterns = new HashSet<CPListElement>();
                this.addExlusionPatterns(added, updatedEclusionPatterns);
                this.fModifiedElements.addAll(updatedEclusionPatterns);
            }
            return 0;
        }
        return 1;
    }

    public List<CPListElement> getInsertedElements() {
        return new ArrayList<CPListElement>(this.fInsertedElements);
    }

    public List<CPListElement> getRemovedElements() {
        return new ArrayList<CPListElement>(this.fRemovedElements);
    }

    public List<CPListElement> getModifiedElements() {
        return new ArrayList<CPListElement>(this.fModifiedElements);
    }

    public IPath getOutputLocation() {
        return new Path(this.fOutputLocation).makeAbsolute();
    }

    private boolean removeProjectFromBP(CPListElement existing) {
        String message;
        Path outputFolder = new Path(this.fOutputLocation);
        IPath newOutputFolder = null;
        if (outputFolder.segmentCount() == 1) {
            String outputFolderName = PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
            newOutputFolder = outputFolder.append(outputFolderName);
            message = Messages.format(NewWizardMessages.SourceContainerWorkbookPage_ChangeOutputLocationDialog_project_and_output_message, BasicElementLabels.getPathLabel(newOutputFolder, false));
        } else {
            message = NewWizardMessages.SourceContainerWorkbookPage_ChangeOutputLocationDialog_project_message;
        }
        String title = NewWizardMessages.SourceContainerWorkbookPage_ChangeOutputLocationDialog_title;
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message)) {
            this.fRemovedElements.add(existing);
            if (newOutputFolder != null) {
                this.fOutputLocation = newOutputFolder.toString();
            }
            return true;
        }
        return false;
    }

    private void addExlusionPatterns(List<CPListElement> newEntries, Set<CPListElement> modifiedEntries) {
        BuildPathBasePage.fixNestingConflicts(newEntries.toArray(new CPListElement[newEntries.size()]), this.fExistingElements, modifiedEntries);
        if (!modifiedEntries.isEmpty()) {
            String title = NewWizardMessages.SourceContainerWorkbookPage_exclusion_added_title;
            String message = NewWizardMessages.SourceContainerWorkbookPage_exclusion_added_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    private AddSourceFolderWizard newSourceFolderWizard(CPListElement element, CPListElement[] existing, String outputLocation, IContainer parent) {
        AddSourceFolderWizard wizard = new AddSourceFolderWizard(existing, element, new Path(outputLocation).makeAbsolute(), false, true, false, false, false, parent);
        wizard.setDoFlushChange(false);
        return wizard;
    }

    private List<IResource> getExistingContainers(CPListElement[] existingElements) {
        ArrayList<IResource> res = new ArrayList<IResource>();
        int i = 0;
        while (i < existingElements.length) {
            IResource resource = existingElements[i].getResource();
            if (resource instanceof IContainer) {
                res.add(resource);
            }
            ++i;
        }
        Set<IFolder> keys = this.fNonExistingFolders.keySet();
        for (IFolder folder : keys) {
            res.add((IResource)folder);
        }
        return res;
    }

    private IFolder addFakeFolder(IContainer container, CPListElement element) {
        IContainer parent;
        IFolder result;
        IPath path;
        IPath projectPath = this.fJavaProject.getPath();
        if (projectPath.isPrefixOf(path = element.getPath())) {
            path = path.removeFirstSegments(projectPath.segmentCount());
        }
        Object folder = result = container.getFolder(path);
        do {
            parent = folder.getParent();
            this.fNonExistingFolders.put((IFolder)folder, parent);
        } while ((folder = parent instanceof IFolder ? (IFolder)parent : null) != null && !folder.exists());
        return result;
    }

    private final class FakeFolderBaseWorkbenchContentProvider
    extends BaseWorkbenchContentProvider {
        private FakeFolderBaseWorkbenchContentProvider() {
        }

        public Object getParent(Object element) {
            Object object = CreateMultipleSourceFoldersDialog.this.fNonExistingFolders.get(element);
            if (object != null) {
                return object;
            }
            return super.getParent(element);
        }

        public Object[] getChildren(Object element) {
            ArrayList<Object> result = new ArrayList<Object>();
            Set keys = CreateMultipleSourceFoldersDialog.this.fNonExistingFolders.keySet();
            for (Object key : keys) {
                if (!((IContainer)CreateMultipleSourceFoldersDialog.this.fNonExistingFolders.get(key)).equals(element)) continue;
                result.add(key);
            }
            if (result.size() == 0) {
                return super.getChildren(element);
            }
            Object[] children = super.getChildren(element);
            int i = 0;
            while (i < children.length) {
                result.add(children[i]);
                ++i;
            }
            return result.toArray();
        }
    }
}

