/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.OpenTypeSelectionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SuperInterfaceSelectionDialog
extends OpenTypeSelectionDialog {
    private static final int ADD_ID = 1025;
    private NewTypeWizardPage fTypeWizardPage;
    private List<String> fOldContent;

    public SuperInterfaceSelectionDialog(Shell parent, IRunnableContext context, NewTypeWizardPage page, IJavaProject p) {
        super(parent, true, context, SuperInterfaceSelectionDialog.createSearchScope(p), 6);
        this.fTypeWizardPage = page;
        this.fOldContent = this.fTypeWizardPage.getSuperInterfaces();
        this.setStatusLineAboveButtons(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, NewWizardMessages.SuperInterfaceSelectionDialog_addButton_label, true);
        super.createButtonsForButtonBar(parent);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return JavaPlugin.getDefault().getDialogSettingsSection("DialogBounds_SuperInterfaceSelectionDialog");
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        Button addButton = this.getButton(1025);
        if (addButton != null && !addButton.isDisposed()) {
            addButton.setEnabled(!status.matches(4));
        }
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.fTypeWizardPage.setSuperInterfaces(this.fOldContent, true);
    }

    protected void cancelPressed() {
        this.fTypeWizardPage.setSuperInterfaces(this.fOldContent, true);
        super.cancelPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.addSelectedInterfaces();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        this.addSelectedInterfaces();
        super.okPressed();
    }

    private void addSelectedInterfaces() {
        StructuredSelection selection = this.getSelectedItems();
        if (selection == null) {
            return;
        }
        for (Object obj : selection) {
            if (!(obj instanceof TypeNameMatch)) continue;
            this.accessedHistoryItem(obj);
            TypeNameMatch type = (TypeNameMatch)obj;
            String qualifiedName = SuperInterfaceSelectionDialog.getNameWithTypeParameters(type.getType());
            String message = this.fTypeWizardPage.addSuperInterface(qualifiedName) ? Messages.format(NewWizardMessages.SuperInterfaceSelectionDialog_interfaceadded_info, BasicElementLabels.getJavaElementName(qualifiedName)) : Messages.format(NewWizardMessages.SuperInterfaceSelectionDialog_interfacealreadyadded_info, BasicElementLabels.getJavaElementName(qualifiedName));
            this.updateStatus(new StatusInfo(1, message));
        }
    }

    private static IJavaSearchScope createSearchScope(IJavaProject p) {
        return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{p});
    }

    protected void handleDoubleClick() {
        this.buttonPressed(1025);
    }

    protected void handleSelected(StructuredSelection selection) {
        super.handleSelected(selection);
        if (selection.size() == 0 && this.fTypeWizardPage.getSuperInterfaces().size() > this.fOldContent.size()) {
            this.updateStatus(Status.OK_STATUS);
            this.getButton(1025).setEnabled(false);
        } else {
            this.getButton(1025).setEnabled(this.getButton(0).isEnabled());
        }
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.super_interface_selection_dialog_context");
    }

    public static String getNameWithTypeParameters(IType type) {
        String superName = type.getFullyQualifiedName('.');
        if (!JavaModelUtil.is50OrHigher(type.getJavaProject())) {
            return superName;
        }
        try {
            ITypeParameter[] typeParameters = type.getTypeParameters();
            if (typeParameters.length > 0) {
                StringBuffer buf = new StringBuffer(superName);
                buf.append('<');
                int k = 0;
                while (k < typeParameters.length) {
                    if (k != 0) {
                        buf.append(',').append(' ');
                    }
                    buf.append(typeParameters[k].getElementName());
                    ++k;
                }
                buf.append('>');
                return buf.toString();
            }
        }
        catch (JavaModelException javaModelException) {}
        return superName;
    }
}

