/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.refactoring.IJavaElementMapper;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.CuCollectingSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenamePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.rename.GenericRefactoringHandleTransplanter;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.jdt.internal.corext.refactoring.rename.TextMatchUpdater;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.Changes;
import org.eclipse.jdt.internal.corext.refactoring.util.CommentAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.util.Util;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.IResourceMapper;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenamePackageProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
ITextUpdating,
IQualifiedNameUpdating,
IResourceMapper,
IJavaElementMapper {
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_HIERARCHICAL = "hierarchical";
    private IPackageFragment fPackage;
    private TextChangeManager fChangeManager;
    private ImportsManager fImportsManager;
    private QualifiedNameSearchResult fQualifiedNameSearchResult;
    private boolean fUpdateReferences;
    private boolean fUpdateTextualMatches;
    private boolean fUpdateQualifiedNames;
    private String fFilePatterns;
    private boolean fRenameSubpackages;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renamePackageProcessor";
    private RenamePackageChange fRenamePackageChange;

    public RenamePackageProcessor(IPackageFragment fragment) {
        this.fPackage = fragment;
        if (this.fPackage != null) {
            this.setNewElementName(this.fPackage.getElementName());
        }
        this.fUpdateReferences = true;
        this.fUpdateTextualMatches = false;
        this.fRenameSubpackages = false;
    }

    public RenamePackageProcessor(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this(null);
        status.merge(this.initialize(arguments));
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fPackage);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenamePackageRefactoring_name;
    }

    @Override
    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fPackage);
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.fPackage};
    }

    @Override
    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications result = new RenameModifications();
        result.rename(this.fPackage, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()), this.fRenameSubpackages);
        return result;
    }

    @Override
    protected IFile[] getChangedFiles() throws CoreException {
        HashSet<IFile> combined = new HashSet<IFile>();
        combined.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
        if (this.fRenameSubpackages) {
            IPackageFragment[] allPackages = JavaElementUtil.getPackageAndSubpackages(this.fPackage);
            int i = 0;
            while (i < allPackages.length) {
                combined.addAll(Arrays.asList(ResourceUtil.getFiles(allPackages[i].getCompilationUnits())));
                ++i;
            }
        } else {
            combined.addAll(Arrays.asList(ResourceUtil.getFiles(this.fPackage.getCompilationUnits())));
        }
        if (this.fQualifiedNameSearchResult != null) {
            combined.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
        }
        return combined.toArray(new IFile[combined.size()]);
    }

    @Override
    public int getSaveMode() {
        return 2;
    }

    @Override
    public boolean canEnableTextUpdating() {
        return true;
    }

    @Override
    public boolean getUpdateTextualMatches() {
        return this.fUpdateTextualMatches;
    }

    @Override
    public void setUpdateTextualMatches(boolean update) {
        this.fUpdateTextualMatches = update;
    }

    @Override
    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    @Override
    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    @Override
    public boolean canEnableQualifiedNameUpdating() {
        return !this.fPackage.isDefaultPackage();
    }

    @Override
    public boolean getUpdateQualifiedNames() {
        return this.fUpdateQualifiedNames;
    }

    @Override
    public void setUpdateQualifiedNames(boolean update) {
        this.fUpdateQualifiedNames = update;
    }

    @Override
    public String getFilePatterns() {
        return this.fFilePatterns;
    }

    @Override
    public void setFilePatterns(String patterns) {
        Assert.isNotNull((Object)patterns);
        this.fFilePatterns = patterns;
    }

    public IResource getRefactoredResource(IResource element) {
        IPath elementPath;
        IFolder packageFolder = (IFolder)this.fPackage.getResource();
        if (packageFolder == null) {
            return element;
        }
        IContainer newPackageFolder = (IContainer)this.getNewPackage().getResource();
        if (packageFolder.equals((Object)element)) {
            return newPackageFolder;
        }
        IPath packagePath = packageFolder.getProjectRelativePath();
        if (packagePath.isPrefixOf(elementPath = element.getProjectRelativePath()) && (this.fRenameSubpackages || element instanceof IFile && packageFolder.equals((Object)element.getParent()))) {
            IPath pathInPackage = elementPath.removeFirstSegments(packagePath.segmentCount());
            if (element instanceof IFile) {
                return newPackageFolder.getFile(pathInPackage);
            }
            return newPackageFolder.getFolder(pathInPackage);
        }
        return element;
    }

    public IJavaElement getRefactoredJavaElement(IJavaElement original) {
        return new GenericRefactoringHandleTransplanter(){

            @Override
            protected IPackageFragment transplantHandle(IPackageFragmentRoot parent, IPackageFragment element) {
                if (!RenamePackageProcessor.this.fRenameSubpackages) {
                    if (RenamePackageProcessor.this.fPackage.equals(element)) {
                        return RenamePackageProcessor.this.getNewPackage();
                    }
                } else {
                    String packName = element.getElementName();
                    String packageName = RenamePackageProcessor.this.fPackage.getElementName();
                    if (RenamePackageProcessor.this.fPackage.getParent().equals(parent) && packName.startsWith(String.valueOf(packageName) + '.')) {
                        String newPackName = String.valueOf(RenamePackageProcessor.this.getNewElementName()) + packName.substring(packageName.length() - 1);
                        return RenamePackageProcessor.this.getPackageFragmentRoot().getPackageFragment(newPackName);
                    }
                }
                return super.transplantHandle(parent, element);
            }

            @Override
            protected IMethod transplantHandle(IType parent, IMethod element) {
                String[] parameterTypes = this.resolveParameterTypes(element);
                return parent.getMethod(element.getElementName(), parameterTypes);
            }

            private String[] resolveParameterTypes(IMethod method) {
                String[] oldParameterTypes = method.getParameterTypes();
                String[] newparams = new String[oldParameterTypes.length];
                String[] possibleOldSigs = new String[]{Signature.createTypeSignature((String)RenamePackageProcessor.this.fPackage.getElementName(), (boolean)false), Signature.createTypeSignature((String)RenamePackageProcessor.this.fPackage.getElementName(), (boolean)true)};
                String[] possibleNewSigs = new String[]{Signature.createTypeSignature((String)RenamePackageProcessor.this.getNewElementName(), (boolean)false), Signature.createTypeSignature((String)RenamePackageProcessor.this.getNewElementName(), (boolean)true)};
                int i = 0;
                while (i < oldParameterTypes.length) {
                    newparams[i] = oldParameterTypes[i];
                    int j = 0;
                    while (j < possibleOldSigs.length) {
                        newparams[i] = Util.replaceAll((String)newparams[i], (String)possibleOldSigs[j], (String)possibleNewSigs[j]);
                        ++j;
                    }
                    ++i;
                }
                return newparams;
            }
        }.transplantHandle(original);
    }

    public boolean canEnableRenameSubpackages() throws JavaModelException {
        return this.fPackage.hasSubpackages();
    }

    public boolean getRenameSubpackages() {
        return this.fRenameSubpackages;
    }

    public void setRenameSubpackages(boolean rename) {
        this.fRenameSubpackages = rename;
    }

    @Override
    public final String getCurrentElementName() {
        return this.fPackage.getElementName();
    }

    @Override
    public String getCurrentElementQualifier() {
        return "";
    }

    @Override
    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        Assert.isNotNull((Object)newName, (String)"new name");
        RefactoringStatus result = Checks.checkPackageName(newName, (IJavaElement)this.fPackage);
        if (result.hasFatalError()) {
            return result;
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fPackage, newName)) {
            result.addFatalError(RefactoringCoreMessages.RenamePackageRefactoring_another_name);
            return result;
        }
        result.merge(this.checkPackageInCurrentRoot(newName));
        return result;
    }

    @Override
    public Object getNewElement() {
        return this.getNewPackage();
    }

    private IPackageFragment getNewPackage() {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        return root.getPackageFragment(this.getNewElementName());
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    @Override
    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        try {
            String message;
            pm.beginTask("", 23 + (this.fUpdateQualifiedNames ? 10 : 0) + (this.fUpdateTextualMatches ? 10 : 0));
            pm.setTaskName(RefactoringCoreMessages.RenamePackageRefactoring_checking);
            RefactoringStatus result = new RefactoringStatus();
            result.merge(this.checkNewElementName(this.getNewElementName()));
            pm.worked(1);
            result.merge(this.checkForMainAndNativeMethods());
            pm.worked(2);
            if (this.fPackage.isReadOnly()) {
                message = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_Packagered_only, RenamePackageProcessor.getElementLabel((IJavaElement)this.fPackage));
                result.addFatalError(message);
            } else if (Resources.isReadOnly(this.fPackage.getResource())) {
                message = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_resource_read_only, RenamePackageProcessor.getElementLabel((IJavaElement)this.fPackage));
                result.addError(message);
            }
            result.merge(this.checkPackageName(this.getNewElementName()));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.fChangeManager = new TextChangeManager();
            this.fImportsManager = new ImportsManager();
            SubProgressMonitor subPm = new SubProgressMonitor(pm, 16);
            if (this.fRenameSubpackages) {
                IPackageFragment[] allSubpackages = JavaElementUtil.getPackageAndSubpackages(this.fPackage);
                subPm.beginTask("", allSubpackages.length);
                int i = 0;
                while (i < allSubpackages.length) {
                    new PackageRenamer(allSubpackages[i], this, this.fChangeManager, this.fImportsManager).doRename((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subPm, 1), result);
                    ++i;
                }
                subPm.done();
            } else {
                new PackageRenamer(this.fPackage, this, this.fChangeManager, this.fImportsManager).doRename((IProgressMonitor)subPm, result);
            }
            this.fImportsManager.rewriteImports(this.fChangeManager, (IProgressMonitor)new SubProgressMonitor(pm, 3));
            if (this.fUpdateTextualMatches) {
                pm.subTask(RefactoringCoreMessages.RenamePackageRefactoring_searching_text);
                TextMatchUpdater.perform((IProgressMonitor)new SubProgressMonitor(pm, 10), RefactoringScopeFactory.create((IJavaElement)this.fPackage), this, this.fChangeManager, new SearchResultGroup[0]);
            }
            if (this.fUpdateQualifiedNames) {
                this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, 10));
            }
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public IPackageFragment getPackage() {
        return this.fPackage;
    }

    private RefactoringStatus checkForMainAndNativeMethods() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.fRenameSubpackages) {
            IPackageFragment[] allSubpackages = JavaElementUtil.getPackageAndSubpackages(this.fPackage);
            int i = 0;
            while (i < allSubpackages.length) {
                ICompilationUnit[] cus = allSubpackages[i].getCompilationUnits();
                int c = 0;
                while (c < cus.length) {
                    result.merge(Checks.checkForMainAndNativeMethods(cus[c]));
                    ++c;
                }
                ++i;
            }
        } else {
            ICompilationUnit[] cus = this.fPackage.getCompilationUnits();
            int i = 0;
            while (i < cus.length) {
                result.merge(Checks.checkForMainAndNativeMethods(cus[i]));
                ++i;
            }
        }
        return result;
    }

    public static boolean isPackageNameOkInRoot(String newName, IPackageFragmentRoot root) throws CoreException {
        IPackageFragment pack = root.getPackageFragment(newName);
        if (!pack.exists()) {
            return true;
        }
        if (pack.containsJavaResources()) {
            return false;
        }
        return pack.getNonJavaResources().length == 0;
    }

    private RefactoringStatus checkPackageInCurrentRoot(String newName) throws CoreException {
        if (this.fRenameSubpackages) {
            String currentName = this.getCurrentElementName();
            if (this.isAncestorPackage(currentName, newName)) {
                return null;
            }
            if (!this.isAncestorPackage(newName, currentName) && !RenamePackageProcessor.isPackageNameOkInRoot(newName, this.getPackageFragmentRoot())) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenamePackageRefactoring_package_exists);
            }
            IPackageFragment[] packsToRename = JavaElementUtil.getPackageAndSubpackages(this.fPackage);
            int i = 0;
            while (i < packsToRename.length) {
                IPackageFragment pack = packsToRename[i];
                String newPack = String.valueOf(newName) + pack.getElementName().substring(currentName.length());
                if (!this.isAncestorPackage(currentName, newPack) && !RenamePackageProcessor.isPackageNameOkInRoot(newPack, this.getPackageFragmentRoot())) {
                    String msg = Messages.format(RefactoringCoreMessages.RenamePackageProcessor_subpackage_collides, BasicElementLabels.getJavaElementName(newPack));
                    return RefactoringStatus.createFatalErrorStatus((String)msg);
                }
                ++i;
            }
            return null;
        }
        if (!RenamePackageProcessor.isPackageNameOkInRoot(newName, this.getPackageFragmentRoot())) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenamePackageRefactoring_package_exists);
        }
        return null;
    }

    private boolean isAncestorPackage(String ancestor, String descendant) {
        int d;
        int a = ancestor.length();
        if (a == (d = descendant.length()) || a < d && descendant.charAt(a) == '.') {
            return descendant.startsWith(ancestor);
        }
        return false;
    }

    private IPackageFragmentRoot getPackageFragmentRoot() {
        return (IPackageFragmentRoot)this.fPackage.getParent();
    }

    private RefactoringStatus checkPackageName(String newName) throws CoreException {
        RefactoringStatus status = new RefactoringStatus();
        IPackageFragmentRoot[] roots = this.fPackage.getJavaProject().getPackageFragmentRoots();
        Set<String> topLevelTypeNames = this.getTopLevelTypeNames();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            if (!RenamePackageProcessor.isPackageNameOkInRoot(newName, root)) {
                String rootLabel = JavaElementLabels.getElementLabel((IJavaElement)root, JavaElementLabels.ALL_DEFAULT);
                String newPackageName = BasicElementLabels.getJavaElementName(this.getNewElementName());
                String message = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_aleady_exists, new Object[]{newPackageName, rootLabel});
                status.merge(RefactoringStatus.createWarningStatus((String)message));
                status.merge(this.checkTypeNameConflicts(root, newName, topLevelTypeNames));
            }
            ++i;
        }
        return status;
    }

    private Set<String> getTopLevelTypeNames() throws CoreException {
        ICompilationUnit[] cus = this.fPackage.getCompilationUnits();
        HashSet<String> result = new HashSet<String>(2 * cus.length);
        int i = 0;
        while (i < cus.length) {
            result.addAll(RenamePackageProcessor.getTopLevelTypeNames(cus[i]));
            ++i;
        }
        return result;
    }

    private static Collection<String> getTopLevelTypeNames(ICompilationUnit iCompilationUnit) throws CoreException {
        IType[] types = iCompilationUnit.getTypes();
        ArrayList<String> result = new ArrayList<String>(types.length);
        int i = 0;
        while (i < types.length) {
            result.add(types[i].getElementName());
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypeNameConflicts(IPackageFragmentRoot root, String newName, Set<String> topLevelTypeNames) throws CoreException {
        IPackageFragment otherPack = root.getPackageFragment(newName);
        if (this.fPackage.equals(otherPack)) {
            return null;
        }
        ICompilationUnit[] cus = otherPack.getCompilationUnits();
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < cus.length) {
            result.merge(this.checkTypeNameConflicts(cus[i], topLevelTypeNames));
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypeNameConflicts(ICompilationUnit iCompilationUnit, Set<String> topLevelTypeNames) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IType[] types = iCompilationUnit.getTypes();
        int i = 0;
        while (i < types.length) {
            String name = types[i].getElementName();
            if (topLevelTypeNames.contains(name)) {
                Object[] keys = new String[]{RenamePackageProcessor.getElementLabel(iCompilationUnit.getParent()), RenamePackageProcessor.getElementLabel((IJavaElement)types[i])};
                String msg = Messages.format(RefactoringCoreMessages.RenamePackageRefactoring_contains_type, keys);
                RefactoringStatusContext context = JavaStatusContext.create((IMember)types[i]);
                result.addError(msg, context);
            }
            ++i;
        }
        return result;
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(RefactoringCoreMessages.RenamePackageRefactoring_creating_change, 1);
            RenameJavaElementDescriptor descriptor = this.createRefactoringDescriptor();
            DynamicValidationRefactoringChange result = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, RefactoringCoreMessages.RenamePackageRefactoring_change_name);
            result.addAll((Change[])this.fChangeManager.getAllChanges());
            this.fRenamePackageChange = new RenamePackageChange(this.fPackage, this.getNewElementName(), this.fRenameSubpackages);
            result.add((Change)this.fRenamePackageChange);
            monitor.worked(1);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = result;
            return dynamicValidationRefactoringChange;
        }
        finally {
            this.fChangeManager = null;
            this.fImportsManager = null;
            monitor.done();
        }
    }

    private RenameJavaElementDescriptor createRefactoringDescriptor() {
        String project = null;
        IJavaProject javaProject = this.fPackage.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        String description = Messages.format(RefactoringCoreMessages.RenamePackageProcessor_descriptor_description_short, RenamePackageProcessor.getElementLabel((IJavaElement)this.fPackage));
        String header = Messages.format(RefactoringCoreMessages.RenamePackageProcessor_descriptor_description, new String[]{RenamePackageProcessor.getElementLabel((IJavaElement)this.fPackage), this.getNewElementName()});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
        if (this.fRenameSubpackages) {
            comment.addSetting(RefactoringCoreMessages.RenamePackageProcessor_rename_subpackages);
        }
        RenameJavaElementDescriptor descriptor = RefactoringSignatureDescriptorFactory.createRenameJavaElementDescriptor((String)"org.eclipse.jdt.ui.rename.package");
        descriptor.setProject(project);
        descriptor.setDescription(description);
        descriptor.setComment(comment.asString());
        descriptor.setFlags(589830);
        descriptor.setJavaElement((IJavaElement)this.fPackage);
        descriptor.setNewName(this.getNewElementName());
        descriptor.setUpdateReferences(this.fUpdateReferences);
        descriptor.setUpdateTextualOccurrences(this.fUpdateTextualMatches);
        descriptor.setUpdateQualifiedNames(this.fUpdateQualifiedNames);
        if (this.fUpdateQualifiedNames && this.fFilePatterns != null && !"".equals(this.fFilePatterns)) {
            descriptor.setFileNamePatterns(this.fFilePatterns);
        }
        descriptor.setUpdateHierarchy(this.fRenameSubpackages);
        return descriptor;
    }

    private static String getElementLabel(IJavaElement javaElement) {
        return JavaElementLabels.getElementLabel(javaElement, JavaElementLabels.ALL_DEFAULT);
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        if (this.fQualifiedNameSearchResult != null) {
            CompositeChange parent = (CompositeChange)this.fRenamePackageChange.getParent();
            try {
                parent.remove((Change)this.fRenamePackageChange);
                parent.add(this.fQualifiedNameSearchResult.getSingleChange(Changes.getModifiedFiles(participantChanges)));
            }
            finally {
                this.fQualifiedNameSearchResult = null;
                parent.add((Change)this.fRenamePackageChange);
                this.fRenamePackageChange = null;
            }
        }
        return null;
    }

    private void computeQualifiedNameMatches(IProgressMonitor pm) {
        if (this.fQualifiedNameSearchResult == null) {
            this.fQualifiedNameSearchResult = new QualifiedNameSearchResult();
        }
        QualifiedNameFinder.process(this.fQualifiedNameSearchResult, this.fPackage.getElementName(), this.getNewElementName(), this.fFilePatterns, this.fPackage.getJavaProject().getProject(), pm);
    }

    public String getNewPackageName(String oldSubPackageName) {
        String oldPackageName = this.getPackage().getElementName();
        return String.valueOf(this.getNewElementName()) + oldSubPackageName.substring(oldPackageName.length());
    }

    private RefactoringStatus initialize(JavaRefactoringArguments extended) {
        IJavaElement element;
        String handle = extended.getAttribute("input");
        if (handle != null) {
            element = JavaRefactoringDescriptorUtil.handleToElement(extended.getProject(), handle, false);
            if (element == null || !element.exists() || element.getElementType() != 4) {
                return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getProcessorName(), "org.eclipse.jdt.ui.rename.package");
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        this.fPackage = (IPackageFragment)element;
        String name = extended.getAttribute("name");
        if (name == null || "".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.setNewElementName(name);
        String patterns = extended.getAttribute(ATTRIBUTE_PATTERNS);
        this.fFilePatterns = patterns != null && !"".equals(patterns) ? patterns : "";
        String references = extended.getAttribute("references");
        if (references == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.valueOf(references);
        String matches = extended.getAttribute(ATTRIBUTE_TEXTUAL_MATCHES);
        if (matches == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_TEXTUAL_MATCHES));
        }
        this.fUpdateTextualMatches = Boolean.valueOf(matches);
        String qualified = extended.getAttribute(ATTRIBUTE_QUALIFIED);
        if (qualified == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_QUALIFIED));
        }
        this.fUpdateQualifiedNames = Boolean.valueOf(qualified);
        String hierarchical = extended.getAttribute(ATTRIBUTE_HIERARCHICAL);
        if (hierarchical == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_HIERARCHICAL));
        }
        this.fRenameSubpackages = Boolean.valueOf(hierarchical);
        return new RefactoringStatus();
    }

    static class ImportsManager {
        private HashMap<ICompilationUnit, ImportChange> fImportChanges = new HashMap();

        ImportsManager() {
        }

        public ImportChange getImportChange(ICompilationUnit cu) {
            ImportChange importChange = this.fImportChanges.get(cu);
            if (importChange == null) {
                importChange = new ImportChange();
                this.fImportChanges.put(cu, importChange);
            }
            return importChange;
        }

        public void rewriteImports(TextChangeManager changeManager, IProgressMonitor pm) throws CoreException {
            for (Map.Entry<ICompilationUnit, ImportChange> entry : this.fImportChanges.entrySet()) {
                ICompilationUnit cu = entry.getKey();
                ImportChange importChange = entry.getValue();
                ImportRewrite importRewrite = StubUtility.createImportRewrite(cu, true);
                importRewrite.setFilterImplicitImports(false);
                Iterator iterator = importChange.fStaticToRemove.iterator();
                while (iterator.hasNext()) {
                    importRewrite.removeStaticImport((String)iterator.next());
                }
                iterator = importChange.fToRemove.iterator();
                while (iterator.hasNext()) {
                    importRewrite.removeImport((String)iterator.next());
                }
                for (String[] toAdd : importChange.fStaticToAdd) {
                    importRewrite.addStaticImport(toAdd[0], toAdd[1], true);
                }
                iterator = importChange.fToAdd.iterator();
                while (iterator.hasNext()) {
                    importRewrite.addImport((String)iterator.next());
                }
                if (!importRewrite.hasRecordedChanges()) continue;
                TextEdit importEdit = importRewrite.rewriteImports(pm);
                String name = RefactoringCoreMessages.RenamePackageRefactoring_update_imports;
                try {
                    TextChangeCompatibility.addTextEdit(changeManager.get(cu), name, importEdit);
                }
                catch (MalformedTreeException e) {
                    JavaPlugin.logErrorMessage("MalformedTreeException while processing cu " + cu);
                    throw e;
                }
            }
        }

        public static class ImportChange {
            private ArrayList<String> fStaticToRemove = new ArrayList();
            private ArrayList<String[]> fStaticToAdd = new ArrayList();
            private ArrayList<String> fToRemove = new ArrayList();
            private ArrayList<String> fToAdd = new ArrayList();

            public void removeStaticImport(String elementName) {
                this.fStaticToRemove.add(elementName);
            }

            public void addStaticImport(String declaringType, String memberName) {
                this.fStaticToAdd.add(new String[]{declaringType, memberName});
            }

            public void removeImport(String elementName) {
                this.fToRemove.add(elementName);
            }

            public void addImport(String elementName) {
                this.fToAdd.add(elementName);
            }
        }
    }

    private static class PackageRenamer {
        private final IPackageFragment fPackage;
        private final RenamePackageProcessor fProcessor;
        private final TextChangeManager fTextChangeManager;
        private final ImportsManager fImportsManager;
        private SearchResultGroup[] fOccurrences;
        private List<SearchResultGroup> fReferencesToTypesInNamesakes;
        private List<SearchResultGroup> fReferencesToTypesInPackage;

        public PackageRenamer(IPackageFragment pack, RenamePackageProcessor processor, TextChangeManager textChangeManager, ImportsManager importsManager) {
            this.fPackage = pack;
            this.fProcessor = processor;
            this.fTextChangeManager = textChangeManager;
            this.fImportsManager = importsManager;
        }

        void doRename(IProgressMonitor pm, RefactoringStatus result) throws CoreException {
            pm.beginTask("", 16);
            if (this.fProcessor.getUpdateReferences()) {
                pm.setTaskName(RefactoringCoreMessages.RenamePackageRefactoring_searching);
                String binaryRefsDescription = Messages.format(RefactoringCoreMessages.ReferencesInBinaryContext_ref_in_binaries_description, RenamePackageProcessor.getElementLabel((IJavaElement)this.fPackage));
                ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext(binaryRefsDescription);
                this.fOccurrences = this.getReferences((IProgressMonitor)new SubProgressMonitor(pm, 4), binaryRefs, result);
                this.fReferencesToTypesInNamesakes = this.getReferencesToTypesInNamesakes((IProgressMonitor)new SubProgressMonitor(pm, 4), result);
                this.fReferencesToTypesInPackage = this.getReferencesToTypesInPackage((IProgressMonitor)new SubProgressMonitor(pm, 4), binaryRefs, result);
                binaryRefs.addErrorIfNecessary(result);
                pm.setTaskName(RefactoringCoreMessages.RenamePackageRefactoring_checking);
                result.merge(this.analyzeAffectedCompilationUnits());
                pm.worked(1);
            } else {
                this.fOccurrences = new SearchResultGroup[0];
                pm.worked(13);
            }
            if (result.hasFatalError()) {
                return;
            }
            if (this.fProcessor.getUpdateReferences()) {
                this.addReferenceUpdates((IProgressMonitor)new SubProgressMonitor(pm, 3));
            } else {
                pm.worked(3);
            }
            pm.done();
        }

        private SearchResultGroup[] getReferences(IProgressMonitor pm, ReferencesInBinaryContext binaryRefs, RefactoringStatus status) throws CoreException {
            IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.fPackage, true, false);
            SearchPattern pattern = SearchPattern.createPattern((IJavaElement)this.fPackage, (int)2);
            CuCollectingSearchRequestor requestor = new CuCollectingSearchRequestor(binaryRefs);
            return RefactoringSearchEngine.search(pattern, scope, requestor, pm, status);
        }

        private void addReferenceUpdates(IProgressMonitor pm) throws CoreException {
            pm.beginTask("", this.fOccurrences.length + this.fReferencesToTypesInPackage.size() + this.fReferencesToTypesInNamesakes.size());
            int i = 0;
            while (i < this.fOccurrences.length) {
                ICompilationUnit cu = this.fOccurrences[i].getCompilationUnit();
                if (cu != null) {
                    SearchResultGroup typeRefsRequiringNewNameImport;
                    SearchResultGroup typeRefsRequiringOldNameImport;
                    SearchMatch[] results = this.fOccurrences[i].getSearchResults();
                    int j = 0;
                    while (j < results.length) {
                        SearchMatch result = results[j];
                        IJavaElement enclosingElement = SearchUtils.getEnclosingJavaElement(result);
                        if (enclosingElement instanceof IImportDeclaration) {
                            IImportDeclaration importDeclaration = (IImportDeclaration)enclosingElement;
                            String updatedImport = this.getUpdatedImport(importDeclaration);
                            this.updateImport(cu, importDeclaration, updatedImport);
                        } else {
                            TextChangeCompatibility.addTextEdit(this.fTextChangeManager.get(cu), RefactoringCoreMessages.RenamePackageRefactoring_update_reference, this.createTextChange(result));
                        }
                        ++j;
                    }
                    if (this.fReferencesToTypesInNamesakes.size() != 0 && (typeRefsRequiringOldNameImport = PackageRenamer.extractGroupFor(cu, this.fReferencesToTypesInNamesakes)) != null) {
                        this.addTypeImports(typeRefsRequiringOldNameImport);
                    }
                    if (this.fReferencesToTypesInPackage.size() != 0 && (typeRefsRequiringNewNameImport = PackageRenamer.extractGroupFor(cu, this.fReferencesToTypesInPackage)) != null) {
                        this.updateTypeImports(typeRefsRequiringNewNameImport);
                    }
                    pm.worked(1);
                }
                ++i;
            }
            if (this.fReferencesToTypesInNamesakes.size() != 0) {
                for (SearchResultGroup referencesToTypesInNamesakes : this.fReferencesToTypesInNamesakes) {
                    this.addTypeImports(referencesToTypesInNamesakes);
                    pm.worked(1);
                }
            }
            if (this.fReferencesToTypesInPackage.size() != 0) {
                for (SearchResultGroup namesakeReferencesToPackage : this.fReferencesToTypesInPackage) {
                    this.updateTypeImports(namesakeReferencesToPackage);
                    pm.worked(1);
                }
            }
            pm.done();
        }

        private static SearchResultGroup extractGroupFor(ICompilationUnit cu, List<SearchResultGroup> searchResultGroups) {
            Iterator<SearchResultGroup> iter = searchResultGroups.iterator();
            while (iter.hasNext()) {
                SearchResultGroup group = iter.next();
                if (!cu.equals(group.getCompilationUnit())) continue;
                iter.remove();
                return group;
            }
            return null;
        }

        private TextEdit createTextChange(SearchMatch searchResult) {
            return new ReplaceEdit(searchResult.getOffset(), searchResult.getLength(), this.getNewPackageName());
        }

        private RefactoringStatus analyzeAffectedCompilationUnits() throws CoreException {
            RefactoringStatus result = new RefactoringStatus();
            this.fOccurrences = Checks.excludeCompilationUnits(this.fOccurrences, result);
            if (result.hasFatalError()) {
                return result;
            }
            result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fOccurrences));
            return result;
        }

        private IJavaSearchScope getPackageAndOccurrencesWithoutNamesakesScope() {
            ArrayList<Object> scopeList = new ArrayList<Object>();
            scopeList.add(this.fPackage);
            int i = 0;
            while (i < this.fOccurrences.length) {
                IPackageFragment pack;
                ICompilationUnit cu = this.fOccurrences[i].getCompilationUnit();
                if (cu != null && !(pack = (IPackageFragment)cu.getParent()).getElementName().equals(this.fPackage.getElementName())) {
                    scopeList.add(cu);
                }
                ++i;
            }
            return SearchEngine.createJavaSearchScope((IJavaElement[])scopeList.toArray(new IJavaElement[scopeList.size()]));
        }

        private List<SearchResultGroup> getReferencesToTypesInNamesakes(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
            pm.beginTask("", 2);
            IJavaElement[] elements = new IJavaElement[this.fOccurrences.length + 1];
            int i = 0;
            while (i < this.fOccurrences.length) {
                elements[i] = this.fOccurrences[i].getCompilationUnit();
                ++i;
            }
            elements[this.fOccurrences.length] = this.fPackage;
            IJavaSearchScope namesakePackagesScope = RefactoringScopeFactory.createReferencedScope(elements);
            IPackageFragment[] namesakePackages = this.getNamesakePackages(namesakePackagesScope, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (namesakePackages.length == 0) {
                pm.done();
                return new ArrayList<SearchResultGroup>(0);
            }
            IType[] typesToSearch = this.getTypesInPackages(namesakePackages);
            if (typesToSearch.length == 0) {
                pm.done();
                return new ArrayList<SearchResultGroup>(0);
            }
            SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])typesToSearch, 2);
            IJavaSearchScope scope = this.getPackageAndOccurrencesWithoutNamesakesScope();
            SearchResultGroup[] results = RefactoringSearchEngine.search(pattern, scope, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
            pm.done();
            return new ArrayList<SearchResultGroup>(Arrays.asList(results));
        }

        private List<SearchResultGroup> getReferencesToTypesInPackage(IProgressMonitor pm, ReferencesInBinaryContext binaryRefs, RefactoringStatus status) throws CoreException {
            pm.beginTask("", 2);
            IJavaSearchScope referencedFromNamesakesScope = RefactoringScopeFactory.create((IJavaElement)this.fPackage, true, false);
            IPackageFragment[] namesakePackages = this.getNamesakePackages(referencedFromNamesakesScope, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            if (namesakePackages.length == 0) {
                pm.done();
                return new ArrayList<SearchResultGroup>(0);
            }
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])namesakePackages);
            IType[] typesToSearch = this.getTypesInPackage(this.fPackage);
            if (typesToSearch.length == 0) {
                pm.done();
                return new ArrayList<SearchResultGroup>(0);
            }
            SearchPattern pattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])typesToSearch, 2);
            CuCollectingSearchRequestor requestor = new CuCollectingSearchRequestor(binaryRefs);
            SearchResultGroup[] results = RefactoringSearchEngine.search(pattern, scope, requestor, (IProgressMonitor)new SubProgressMonitor(pm, 1), status);
            pm.done();
            return new ArrayList<SearchResultGroup>(Arrays.asList(results));
        }

        private IType[] getTypesInPackage(IPackageFragment packageFragment) throws JavaModelException {
            ArrayList<IType> types = new ArrayList<IType>();
            this.addContainedTypes(packageFragment, types);
            return types.toArray(new IType[types.size()]);
        }

        private IPackageFragment[] getNamesakePackages(IJavaSearchScope scope, IProgressMonitor pm) throws CoreException {
            SearchPattern pattern = SearchPattern.createPattern((String)this.fPackage.getElementName(), (int)2, (int)0, (int)8);
            final HashSet packageFragments = new HashSet();
            SearchRequestor requestor = new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    IJavaElement enclosingElement = SearchUtils.getEnclosingJavaElement(match);
                    if (enclosingElement instanceof IPackageFragment) {
                        IPackageFragment pack = (IPackageFragment)enclosingElement;
                        if (!PackageRenamer.this.fPackage.equals(pack)) {
                            packageFragments.add(pack);
                        }
                    }
                }
            };
            new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, requestor, pm);
            return packageFragments.toArray(new IPackageFragment[packageFragments.size()]);
        }

        private IType[] getTypesInPackages(IPackageFragment[] packageFragments) throws JavaModelException {
            ArrayList<IType> types = new ArrayList<IType>();
            int i = 0;
            while (i < packageFragments.length) {
                IPackageFragment pack = packageFragments[i];
                this.addContainedTypes(pack, types);
                ++i;
            }
            return types.toArray(new IType[types.size()]);
        }

        private void addContainedTypes(IPackageFragment pack, List<IType> typesCollector) throws JavaModelException {
            IJavaElement[] children = pack.getChildren();
            int c = 0;
            while (c < children.length) {
                IJavaElement child = children[c];
                if (child instanceof ICompilationUnit) {
                    typesCollector.addAll(Arrays.asList(((ICompilationUnit)child).getTypes()));
                } else if (child instanceof IClassFile) {
                    typesCollector.add(((IClassFile)child).getType());
                }
                ++c;
            }
        }

        private void updateImport(ICompilationUnit cu, IImportDeclaration importDeclaration, String updatedImport) throws JavaModelException {
            ImportsManager.ImportChange importChange = this.fImportsManager.getImportChange(cu);
            if (Flags.isStatic((int)importDeclaration.getFlags())) {
                importChange.removeStaticImport(importDeclaration.getElementName());
                importChange.addStaticImport(Signature.getQualifier((String)updatedImport), Signature.getSimpleName((String)updatedImport));
            } else {
                importChange.removeImport(importDeclaration.getElementName());
                importChange.addImport(updatedImport);
            }
        }

        private void addTypeImports(SearchResultGroup typeReferences) throws CoreException {
            SearchMatch[] searchResults = typeReferences.getSearchResults();
            int i = 0;
            while (i < searchResults.length) {
                String reference;
                SearchMatch result = searchResults[i];
                IJavaElement enclosingElement = SearchUtils.getEnclosingJavaElement(result);
                if (!(enclosingElement instanceof IImportDeclaration) && !(reference = PackageRenamer.getNormalizedTypeReference(result)).startsWith(this.fPackage.getElementName())) {
                    reference = PackageRenamer.cutOffInnerTypes(reference);
                    ImportsManager.ImportChange importChange = this.fImportsManager.getImportChange(typeReferences.getCompilationUnit());
                    importChange.addImport(String.valueOf(this.fPackage.getElementName()) + '.' + reference);
                }
                ++i;
            }
        }

        private void updateTypeImports(SearchResultGroup typeReferences) throws CoreException {
            SearchMatch[] searchResults = typeReferences.getSearchResults();
            int i = 0;
            while (i < searchResults.length) {
                SearchMatch result = searchResults[i];
                IJavaElement enclosingElement = SearchUtils.getEnclosingJavaElement(result);
                if (enclosingElement instanceof IImportDeclaration) {
                    IImportDeclaration importDeclaration = (IImportDeclaration)enclosingElement;
                    this.updateImport(typeReferences.getCompilationUnit(), importDeclaration, this.getUpdatedImport(importDeclaration));
                } else {
                    String reference = PackageRenamer.getNormalizedTypeReference(result);
                    if (!reference.startsWith(this.fPackage.getElementName())) {
                        reference = PackageRenamer.cutOffInnerTypes(reference);
                        ImportsManager.ImportChange importChange = this.fImportsManager.getImportChange(typeReferences.getCompilationUnit());
                        importChange.removeImport(String.valueOf(this.fPackage.getElementName()) + '.' + reference);
                        importChange.addImport(String.valueOf(this.getNewPackageName()) + '.' + reference);
                    }
                }
                ++i;
            }
        }

        private static String getNormalizedTypeReference(SearchMatch searchResult) throws JavaModelException {
            ICompilationUnit cu = SearchUtils.getCompilationUnit(searchResult);
            String reference = cu.getBuffer().getText(searchResult.getOffset(), searchResult.getLength());
            return CommentAnalyzer.normalizeReference(reference);
        }

        private static String cutOffInnerTypes(String reference) {
            int dotPos = reference.indexOf(46);
            if (dotPos != -1) {
                reference = reference.substring(0, dotPos);
            }
            return reference;
        }

        private String getUpdatedImport(IImportDeclaration importDeclaration) {
            String fullyQualifiedImportType = importDeclaration.getElementName();
            int offsetOfDotBeforeTypeName = this.fPackage.getElementName().length();
            String result = String.valueOf(this.getNewPackageName()) + fullyQualifiedImportType.substring(offsetOfDotBeforeTypeName);
            return result;
        }

        private String getNewPackageName() {
            return this.fProcessor.getNewPackageName(this.fPackage.getElementName());
        }
    }
}

