/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.workflow.common;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.efm.sew.launcher.Activator;
import org.eclipse.efm.sew.launcher.workflow.IWorkflowConfigurationConstants;
import org.eclipse.efm.sew.launcher.workflow.common.DebuglevelKind;
import org.eclipse.efm.sew.launcher.workflow.common.impl.DeveloperTuningOptionImpl;
import org.eclipse.efm.sew.launcher.workflow.util.PrettyPrintWriter;
import org.eclipse.jface.preference.IPreferenceStore;

public class DeveloperTuningOptionCustomImpl
extends DeveloperTuningOptionImpl
implements IWorkflowConfigurationConstants {
    static boolean fEnabledDebugOptions;
    static boolean fEnabledSymbexDeveloperMode;

    public static void setEnabledFlags(ILaunchConfiguration configuration) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        fEnabledDebugOptions = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_DEBUG_OPTIONS");
        fEnabledSymbexDeveloperMode = prefs.getBoolean("org.eclipse.efm.sew.launcher.ui.PREF_SYMBEX_DEVELOPER_MODE");
        if (fEnabledSymbexDeveloperMode) {
            try {
                fEnabledSymbexDeveloperMode = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_DEVELOPER_TUNING", false);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public static DeveloperTuningOptionCustomImpl createWorkflow(ILaunchConfiguration configuration) {
        DeveloperTuningOptionCustomImpl.setEnabledFlags(configuration);
        if (fEnabledSymbexDeveloperMode) {
            String str;
            DeveloperTuningOptionCustomImpl devTuning = new DeveloperTuningOptionCustomImpl();
            try {
                str = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_DEVELOPER_TUNING_LOG_FILENAME", "symbex.log");
            }
            catch (CoreException e) {
                e.printStackTrace();
                str = "symbex.log";
            }
            devTuning.setLogTraceFilename(str);
            try {
                str = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_DEVELOPER_TUNING_DEBUG_FILENAME", "symbex.dbg");
            }
            catch (CoreException e) {
                e.printStackTrace();
                str = "symbex.dbg";
            }
            devTuning.setDebugTraceFilename(str);
            try {
                str = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_DEVELOPER_TUNING_DEBUG_LEVEL", "ZERO");
            }
            catch (CoreException e) {
                e.printStackTrace();
                str = "ZERO";
            }
            DebuglevelKind debugLevel = DebuglevelKind.get(str);
            if (debugLevel == null) {
                debugLevel = DebuglevelKind.ZERO;
            }
            devTuning.setDebugLevel(debugLevel);
            devTuning.configureTuningOption(configuration);
            return devTuning;
        }
        return null;
    }

    public boolean configureTuningOption(ILaunchConfiguration configuration) {
        boolean enabled;
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_PARSING", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledParsing(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_CONFIGURING", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledConfigure(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_COMPILING", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledCompiling(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_LOADING", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledLoading(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_COMPUTING", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledComputing(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_REPORTING", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledReporting(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_SOLVING", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledSolver(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_PROFILING", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledProfiling(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_ALL_PROCESS_STAGE", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledAllProcessStage(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_PRE_PROCESSING", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledPreProcessing(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_POST_PROCESSING", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledPostProcessing(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_PROCESSING", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledProcessing(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_PRE_FILTERING", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledPreFiltering(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_POST_FILTERING", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledPostFiltering(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_FILTERING", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledFiltering(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_QUEUE", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledQueue(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_PROGRAM", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledProgram(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_STATEMENT", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledStatement(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_STATEMENT_ASSIGNMENT", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledStatementAssignment(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_STATEMENT_COMMUNICATION", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledStatementCommunication(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_STATEMENT_TEST_DECISION", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledStatementTestDecision(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_BYTECODE", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledBytecode(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_DATA", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledData(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_TRACE", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledTrace(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_VARIABLE", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledVariable(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_BUFFER", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledBuffer(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_PORT", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledPort(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_SIGNAL", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledSignal(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_CONNEXION", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledConnexion(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_TIME", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledTime(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_EXECUTABLE", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledExecutable(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_ACTIVITY", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledActivity(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_ROUTINE", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledRoutine(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_TRANSITION", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledTransition(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_MACHINE", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledMachine(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_STATEMACHINE", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledStatemachine(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_NAME_ID", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledNameId(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_QUALIFIED_NAME_ID", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledQualifiedNameId(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_FULLY_QUALIFIED_NAME_ID", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledFullyQualifiedNameId(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_REDUNDANCE", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledRedundance(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_REFERENCE_COUNTING", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledReferenceCounting(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_NOTHING", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledNothing(enabled);
        try {
            enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_TRACE_GOD_MODE", false);
        }
        catch (CoreException coreException) {
            enabled = false;
        }
        this.setEnabledGodMode(enabled);
        return true;
    }

    public static String getModelFilename(ILaunchConfiguration configuration) {
        String modelPath;
        try {
            modelPath = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_FILE_LOCATION", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
            modelPath = null;
        }
        if (modelPath != null && !modelPath.isEmpty()) {
            int pos = modelPath.lastIndexOf(47);
            if (pos > 0) {
                modelPath = modelPath.substring(pos + 1);
            }
            if ((pos = modelPath.lastIndexOf(46)) > 0) {
                modelPath = modelPath.substring(0, pos);
            }
            return modelPath;
        }
        return null;
    }

    public static DeveloperTuningOptionCustomImpl createDirector(ILaunchConfiguration configuration) {
        DeveloperTuningOptionCustomImpl.setEnabledFlags(configuration);
        if (fEnabledDebugOptions || fEnabledSymbexDeveloperMode) {
            boolean enabled;
            DeveloperTuningOptionCustomImpl devTuning = new DeveloperTuningOptionCustomImpl();
            devTuning.setDebugLevel(DebuglevelKind.NONE);
            String modelFilename = DeveloperTuningOptionCustomImpl.getModelFilename(configuration);
            try {
                enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_PARSED_MODEL_TEXTUAL_GENERATION", false);
            }
            catch (CoreException e) {
                e.printStackTrace();
                enabled = false;
            }
            if (enabled) {
                devTuning.setOutputFilename(String.valueOf(modelFilename) + "_%1%");
                devTuning.setSpecificationFilename(String.valueOf(modelFilename) + ".xlia");
                if (fEnabledSymbexDeveloperMode) {
                    devTuning.setDebugFilename(String.valueOf(modelFilename) + "_%1%");
                    devTuning.setParsedModelFilename(String.valueOf(modelFilename) + "_parsed.xlia");
                }
            }
            try {
                enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_COMPILED_MODEL_TEXTUAL_GENERATION", false);
            }
            catch (CoreException e) {
                e.printStackTrace();
                enabled = false;
            }
            if (enabled) {
                devTuning.setExecutableFilename(String.valueOf(modelFilename) + ".fexe");
                if (fEnabledSymbexDeveloperMode) {
                    devTuning.setCompiledModelFilename(String.valueOf(modelFilename) + "_compiled.fexe");
                }
            }
            try {
                enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_FIRST_SYMBEX_OUTPUT_TEXTUAL_GENERATION", false);
            }
            catch (CoreException e) {
                e.printStackTrace();
                enabled = false;
            }
            if (enabled) {
                devTuning.setSymbexGraphFilename(String.valueOf(modelFilename) + ".fscn");
                if (fEnabledSymbexDeveloperMode) {
                    devTuning.setSymbexTraceFilename(String.valueOf(modelFilename) + ".fet");
                }
            }
            return devTuning;
        }
        return null;
    }

    public static DeveloperTuningOptionCustomImpl createSecondDirector(ILaunchConfiguration configuration) {
        DeveloperTuningOptionCustomImpl.setEnabledFlags(configuration);
        if (fEnabledDebugOptions || fEnabledSymbexDeveloperMode) {
            boolean enabled;
            DeveloperTuningOptionCustomImpl devTuning = new DeveloperTuningOptionCustomImpl();
            devTuning.setDebugLevel(DebuglevelKind.NONE);
            String modelFilename = DeveloperTuningOptionCustomImpl.getModelFilename(configuration);
            try {
                enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_PARSED_MODEL_TEXTUAL_GENERATION", false);
            }
            catch (CoreException e) {
                e.printStackTrace();
                enabled = false;
            }
            if (enabled) {
                devTuning.setOutputFilename(String.valueOf(modelFilename) + "_%1%");
                devTuning.setSpecificationFilename(String.valueOf(modelFilename) + ".xlia");
                if (fEnabledSymbexDeveloperMode) {
                    devTuning.setDebugFilename(String.valueOf(modelFilename) + "_%1%");
                    devTuning.setParsedModelFilename(String.valueOf(modelFilename) + "_parsed.xlia");
                }
            }
            try {
                enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_COMPILED_MODEL_TEXTUAL_GENERATION", false);
            }
            catch (CoreException e) {
                e.printStackTrace();
                enabled = false;
            }
            if (enabled) {
                devTuning.setExecutableFilename(String.valueOf(modelFilename) + ".fexe");
                if (fEnabledSymbexDeveloperMode) {
                    devTuning.setCompiledModelFilename(String.valueOf(modelFilename) + "_compiled.fexe");
                }
            }
            try {
                enabled = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_SECOND_SYMBEX_OUTPUT_TEXTUAL_GENERATION", false);
            }
            catch (CoreException e) {
                e.printStackTrace();
                enabled = false;
            }
            if (enabled) {
                devTuning.setSymbexGraphFilename(String.valueOf(modelFilename) + "_extension.fscn");
                if (fEnabledSymbexDeveloperMode) {
                    devTuning.setSymbexTraceFilename(String.valueOf(modelFilename) + "_extension.fet");
                }
            }
            return devTuning;
        }
        return null;
    }

    public void toWriter(PrettyPrintWriter writer) {
        String strOutputFilename = this.getOutputFilename();
        String strSpecificationFilename = this.getSpecificationFilename();
        String strExecutableFilename = this.getExecutableFilename();
        String strScenariiFilename = this.getSymbexGraphFilename();
        if (strOutputFilename != null || strSpecificationFilename != null || strExecutableFilename != null || strScenariiFilename != null) {
            writer.appendTabEol("output 'standard analysis file' [");
            if (strOutputFilename != null) {
                writer.appendTab2("filename = '").append(strOutputFilename).appendEol("'");
            }
            if (strSpecificationFilename != null) {
                writer.appendTab2("specification = '").append(strSpecificationFilename).appendEol("'");
            }
            if (strExecutableFilename != null) {
                writer.appendTab2("executable = '").append(strExecutableFilename).appendEol("'");
            }
            if (strScenariiFilename != null) {
                writer.appendTab2("scenarii = '").append(strScenariiFilename).appendEol("'");
            }
            writer.appendTabEol("] // end output");
        }
        String strDebugFilename = this.getDebugFilename();
        String strParsedFilename = this.getParsedModelFilename();
        String strCompiledFilename = this.getCompiledModelFilename();
        String strExecutedFilename = this.getSymbexTraceFilename();
        if (strDebugFilename != null || strParsedFilename != null || strCompiledFilename != null || strExecutedFilename != null) {
            writer.appendTabEol("debug 'analysis file at different stage' [");
            if (strDebugFilename != null) {
                writer.appendTab2("filename = '").append(strDebugFilename).appendEol("'");
            }
            if (strParsedFilename != null) {
                writer.appendTab2("parsing = '").append(strParsedFilename).appendEol("'");
            }
            if (strCompiledFilename != null) {
                writer.appendTab2("compilation = '").append(strCompiledFilename).appendEol("'");
            }
            if (strExecutedFilename != null) {
                writer.appendTab2("execution = '").append(strExecutedFilename).appendEol("'");
            }
            writer.appendTabEol("] // end debug");
        }
        String strLogTraceFilename = this.getLogTraceFilename();
        String strDebugTraceFilename = this.getDebugTraceFilename();
        DebuglevelKind debugLevel = this.getDebugLevel();
        if (strLogTraceFilename != null || strDebugTraceFilename != null || debugLevel != DebuglevelKind.NONE) {
            writer.appendTabEol("developer 'tuning options' [");
            if (strLogTraceFilename != null) {
                writer.appendTab2("log   = '").append(strLogTraceFilename).appendEol("'");
            }
            if (strDebugTraceFilename != null) {
                writer.appendTab2("debug = '").append(strDebugTraceFilename).appendEol("'");
            }
            if (debugLevel != DebuglevelKind.NONE) {
                boolean enabledNothing;
                writer.appendTab2("level = '").append(debugLevel.getLiteral()).appendEol("'");
                boolean enabledGodMode = this.isEnabledGodMode();
                if (enabledGodMode && debugLevel != DebuglevelKind.ZERO) {
                    writer.appendTab2Eol("// Enable all debug trace flags");
                    writer.appendTab2Eol("flag = 'GOD_MODE'");
                }
                if ((enabledNothing = this.isEnabledNothing()) && !enabledGodMode && debugLevel != DebuglevelKind.ZERO) {
                    writer.appendTab2Eol("// Disable all debug trace flags");
                    writer.appendTab2Eol("flag = 'NOTHING'");
                }
                if (!enabledGodMode && !enabledNothing && debugLevel != DebuglevelKind.ZERO) {
                    writer.appendTab2Eol("// Enable debug trace flags");
                    if (this.isEnabledParsing()) {
                        writer.appendTab2Eol("flag = 'PARSING'");
                    }
                    if (this.isEnabledConfigure()) {
                        writer.appendTab2Eol("flag = 'CONFIGURE'");
                    }
                    if (this.isEnabledCompiling()) {
                        writer.appendTab2Eol("flag = 'COMPILING'");
                    }
                    if (this.isEnabledLoading()) {
                        writer.appendTab2Eol("flag = 'LOADING'");
                    }
                    if (this.isEnabledComputing()) {
                        writer.appendTab2Eol("flag = 'COMPUTING'");
                    }
                    if (this.isEnabledReporting()) {
                        writer.appendTab2Eol("flag = 'REPORTING'");
                    }
                    if (this.isEnabledSolver()) {
                        writer.appendTab2Eol("flag = 'SOLVER'");
                    }
                    if (this.isEnabledProfiling()) {
                        writer.appendTab2Eol("flag = 'PROFILING'");
                    }
                    if (this.isEnabledAllProcessStage()) {
                        writer.appendTab2Eol("flag = 'ALL_PROCESS_STAGE'");
                    }
                    if (this.isEnabledPreProcessing()) {
                        writer.appendTab2Eol("flag = 'PRE_PROCESSING'");
                    }
                    if (this.isEnabledPostProcessing()) {
                        writer.appendTab2Eol("flag = 'POST_PROCESSING'");
                    }
                    if (this.isEnabledProcessing()) {
                        writer.appendTab2Eol("flag = 'PROCESSING'");
                    }
                    if (this.isEnabledPreFiltering()) {
                        writer.appendTab2Eol("flag = 'PRE_FILTERING'");
                    }
                    if (this.isEnabledPostFiltering()) {
                        writer.appendTab2Eol("flag = 'POST_FILTERING'");
                    }
                    if (this.isEnabledFiltering()) {
                        writer.appendTab2Eol("flag = 'FILTERING'");
                    }
                    if (this.isEnabledQueue()) {
                        writer.appendTab2Eol("flag = 'QUEUE'");
                    }
                    if (this.isEnabledProgram()) {
                        writer.appendTab2Eol("flag = 'PROGRAM'");
                    }
                    if (this.isEnabledStatement()) {
                        writer.appendTab2Eol("flag = 'STATEMENT'");
                    }
                    if (this.isEnabledStatementAssignment()) {
                        writer.appendTab2Eol("flag = 'STATEMENT_ASSIGNMENT'");
                    }
                    if (this.isEnabledStatementCommunication()) {
                        writer.appendTab2Eol("flag = 'STATEMENT_COMMUNICATION'");
                    }
                    if (this.isEnabledStatementTestDecision()) {
                        writer.appendTab2Eol("flag = 'STATEMENT_TEST_DECISION'");
                    }
                    if (this.isEnabledBytecode()) {
                        writer.appendTab2Eol("flag = 'BYTECODE'");
                    }
                    if (this.isEnabledData()) {
                        writer.appendTab2Eol("flag = 'DATA'");
                    }
                    if (this.isEnabledTrace()) {
                        writer.appendTab2Eol("flag = 'TRACE'");
                    }
                    if (this.isEnabledVariable()) {
                        writer.appendTab2Eol("flag = 'VARIABLE'");
                    }
                    if (this.isEnabledBuffer()) {
                        writer.appendTab2Eol("flag = 'BUFFER'");
                    }
                    if (this.isEnabledPort()) {
                        writer.appendTab2Eol("flag = 'PORT'");
                    }
                    if (this.isEnabledSignal()) {
                        writer.appendTab2Eol("flag = 'SIGNAL'");
                    }
                    if (this.isEnabledConnexion()) {
                        writer.appendTab2Eol("flag = 'CONNEXION'");
                    }
                    if (this.isEnabledTime()) {
                        writer.appendTab2Eol("flag = 'TIME'");
                    }
                    if (this.isEnabledExecutable()) {
                        writer.appendTab2Eol("flag = 'EXECUTABLE'");
                    }
                    if (this.isEnabledRoutine()) {
                        writer.appendTab2Eol("flag = 'ROUTINE'");
                    }
                    if (this.isEnabledTransition()) {
                        writer.appendTab2Eol("flag = 'TRANSITION'");
                    }
                    if (this.isEnabledActivity()) {
                        writer.appendTab2Eol("flag = 'ACTIVITY'");
                    }
                    if (this.isEnabledMachine()) {
                        writer.appendTab2Eol("flag = 'MACHINE'");
                    }
                    if (this.isEnabledStatemachine()) {
                        writer.appendTab2Eol("flag = 'STATEMACHINE'");
                    }
                    if (this.isEnabledNameId()) {
                        writer.appendTab2Eol("flag = 'NAME_ID'");
                    }
                    if (this.isEnabledQualifiedNameId()) {
                        writer.appendTab2Eol("flag = 'QUALIFIED_NAME_ID'");
                    }
                    if (this.isEnabledFullyQualifiedNameId()) {
                        writer.appendTab2Eol("flag = 'FULLY_QUALIFIED_NAME_ID'");
                    }
                    if (this.isEnabledRedundance()) {
                        writer.appendTab2Eol("flag = 'REDUNDANCE'");
                    }
                    if (this.isEnabledReferenceCounting()) {
                        writer.appendTab2Eol("flag = 'REFERENCE_COUNTING'");
                    }
                }
            }
            writer.appendTabEol("] // end developer");
        }
    }
}

