/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.views.page;

import org.eclipse.efm.sew.launcher.LaunchDelegate;
import org.eclipse.efm.sew.launcher.workflow.IWorkflowConfigurationConstants;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class SWTSpider
extends Canvas
implements PaintListener,
IWorkflowConfigurationConstants {
    private boolean fRedrawBySystem;
    private boolean fResetFlag = false;
    private final String SPIDER4BRANCHES = "Spider4Branches";
    private final String SPIDER5BRANCHES = "Spider5Branches";
    private String fSpidertype = "Spider4Branches";
    private String spiderTitle;
    private int xDecalage;
    private int yDecalage;
    private int rayon;
    private int xCentre;
    private int yCentre;
    private int executionNumber = 0;
    private int maxCoverage = 1;
    private int currentCoverage = 0;
    private int maxStep = 1;
    private int currentStep = 0;
    private int maxWidth = 1;
    private int currentWidth = 0;
    private int maxDepth = 1;
    private int currentDepth = 0;
    private int maxContext = 1;
    private int currentContext = 0;
    private int currentStep2 = 0;
    private int currentWidth2 = 0;
    private int currentDepth2 = 0;
    private int currentContext2 = 0;
    private static final int SPIDER_RECTANGLE_WIDTH = 600;
    private static final int SPIDER_RECTANGLE_HEIGHT = 300;

    public SWTSpider(ScrolledComposite parent, int style, int x, int y, int r) {
        super((Composite)parent, style);
        this.xDecalage = x;
        this.yDecalage = y;
        this.rayon = r;
        this.fRedrawBySystem = true;
        this.spiderTitle = "";
        this.setBackground(Display.getCurrent().getSystemColor(37));
        this.addPaintListener(this);
    }

    public void paintControl(PaintEvent e) {
        block21: {
            if (!this.fRedrawBySystem && !this.fResetFlag) break block21;
            this.xCentre = this.xDecalage + this.rayon;
            this.yCentre = this.yDecalage + this.rayon;
            switch (this.fSpidertype) {
                case "Spider4Branches": {
                    this.initSpider4Segments(e);
                    break;
                }
                case "Spider5Branches": {
                    this.initSpider5Segments(e);
                }
            }
        }
        switch (this.fSpidertype) {
            case "Spider4Branches": {
                this.draw4CurrentSegments(e, this.currentStep, this.maxStep, this.currentDepth, this.maxDepth, this.currentContext, this.maxContext, this.currentWidth, this.maxWidth);
                break;
            }
            case "Spider5Branches": {
                this.draw5CurrentSegments(e, this.currentCoverage, this.maxCoverage, this.currentStep, this.maxStep, this.currentWidth, this.maxWidth, this.currentDepth, this.maxDepth, this.currentContext, this.maxContext);
                break;
            }
            default: {
                this.draw4CurrentSegments(e, this.currentStep, this.maxStep, this.currentDepth, this.maxDepth, this.currentContext, this.maxContext, this.currentWidth, this.maxWidth);
            }
        }
        if (LaunchDelegate.fEnableTraceExtension && this.executionNumber > 1) {
            this.drawExe2(e);
        }
    }

    public void resetSpider() {
        this.fResetFlag = true;
        this.fSpidertype = LaunchDelegate.fModelAnalysis.equals("Transition Coverage") || LaunchDelegate.fModelAnalysis.equals("Behavior Selection") ? "Spider5Branches" : "Spider4Branches";
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                SWTSpider.this.redraw();
            }
        });
    }

    private void initSpider4Segments(PaintEvent e) {
        e.gc.fillRectangle(0, 0, 600, 300);
        this.spiderTitle = LaunchDelegate.fModelAnalysis.toUpperCase();
        e.gc.drawString(this.spiderTitle, this.xDecalage + 60, this.yDecalage - 80);
        int rayonCentre = 2;
        e.gc.fillOval(this.xCentre - rayonCentre, this.yCentre - rayonCentre, 2 * rayonCentre, 2 * rayonCentre);
        e.gc.drawLine(this.xCentre, this.yCentre, this.xCentre, this.yCentre - this.rayon);
        e.gc.drawString("step", this.xCentre - 15, this.yCentre - this.rayon - 50);
        e.gc.drawString(String.valueOf(Integer.toString(this.currentStep)) + "/" + Integer.toString(this.maxStep), this.xCentre - 20, this.yCentre - this.rayon - 30);
        e.gc.drawLine(this.xCentre, this.yCentre, this.xCentre + this.rayon, this.yCentre);
        e.gc.drawString("depth", this.xCentre + this.rayon + 20, this.yCentre - 20);
        e.gc.drawString(String.valueOf(Integer.toString(this.currentDepth)) + "/" + Integer.toString(this.maxDepth), this.xCentre + this.rayon + 20, this.yCentre);
        e.gc.drawLine(this.xCentre, this.yCentre, this.xCentre, this.yCentre + this.rayon);
        e.gc.drawString("context", this.xCentre - 20, this.yCentre + this.rayon + 10);
        e.gc.drawString(String.valueOf(Integer.toString(this.currentContext)) + "/" + Integer.toString(this.maxContext), this.xCentre - 20, this.yCentre + this.rayon + 30);
        e.gc.drawLine(this.xCentre, this.yCentre, this.xCentre - this.rayon, this.yCentre);
        e.gc.drawString("width", this.xCentre - this.rayon - 50, this.yCentre - 20);
        e.gc.drawString(String.valueOf(Integer.toString(this.currentWidth)) + "/" + Integer.toString(this.maxWidth), this.xCentre - this.rayon - 50, this.yCentre);
        this.draw4RegularSegments(e, this.rayon / 4);
        this.draw4RegularSegments(e, this.rayon / 2);
        this.draw4RegularSegments(e, this.rayon / 4 * 3);
        this.draw4RegularSegments(e, this.rayon);
    }

    public void draw4RegularSegments(PaintEvent pe, int lg) {
        pe.gc.drawLine(this.xCentre, this.yCentre - lg, this.xCentre + lg, this.yCentre);
        pe.gc.drawLine(this.xCentre + lg, this.yCentre, this.xCentre, this.yCentre + lg);
        pe.gc.drawLine(this.xCentre, this.yCentre + lg, this.xCentre - lg, this.yCentre);
        pe.gc.drawLine(this.xCentre - lg, this.yCentre, this.xCentre, this.yCentre - lg);
    }

    public void draw4CurrentSegments(PaintEvent pe, int cStep, int mStep, int cDepth, int mDepth, int cContext, int mContext, int cWidth, int mWidth) {
        if (mStep == 0 || mDepth == 0 || mContext == 0 || mWidth == 0) {
            return;
        }
        int lgPoint = this.rayon * cStep / mStep;
        int xP1 = this.xCentre;
        int yP1 = this.yCentre - lgPoint;
        lgPoint = this.rayon * cDepth / mDepth;
        int xP2 = this.xCentre + lgPoint;
        int yP2 = this.yCentre;
        lgPoint = this.rayon * cContext / mContext;
        int xP3 = this.xCentre;
        int yP3 = this.yCentre + lgPoint;
        lgPoint = this.rayon * cWidth / mWidth;
        int xP4 = this.xCentre - lgPoint;
        int yP4 = this.yCentre;
        Display device = Display.getCurrent();
        pe.gc.setForeground(device.getSystemColor(5));
        pe.gc.setLineWidth(3);
        pe.gc.drawLine(xP1, yP1, xP2, yP2);
        pe.gc.drawLine(xP2, yP2, xP3, yP3);
        pe.gc.drawLine(xP3, yP3, xP4, yP4);
        pe.gc.drawLine(xP4, yP4, xP1, yP1);
    }

    private void initSpider5Segments(PaintEvent e) {
        e.gc.fillRectangle(0, 0, 600, 300);
        this.spiderTitle = LaunchDelegate.fModelAnalysis.toUpperCase();
        e.gc.drawString(this.spiderTitle, this.xDecalage + 60, this.yDecalage - 80);
        int rayonCentre = 2;
        e.gc.fillOval(this.xCentre - rayonCentre, this.yCentre - rayonCentre, 2 * rayonCentre, 2 * rayonCentre);
        e.gc.drawLine(this.xCentre, this.yCentre, this.xCentre, this.yCentre - this.rayon);
        e.gc.drawString("coverage", this.xCentre - 30, this.yCentre - this.rayon - 50);
        e.gc.drawString(String.valueOf(Integer.toString(this.currentCoverage)) + "/" + Integer.toString(this.maxCoverage), this.xCentre - 20, this.yCentre - this.rayon - 30);
        int xVariation1 = (int)((double)this.rayon * 0.951);
        int yVariation1 = (int)((double)this.rayon * 0.309);
        e.gc.drawLine(this.xCentre, this.yCentre, this.xCentre - xVariation1, this.yCentre - yVariation1);
        e.gc.drawString("context", this.xCentre - xVariation1 - 80, this.yCentre - yVariation1 - 20);
        e.gc.drawString(String.valueOf(Integer.toString(this.currentContext)) + "/" + Integer.toString(this.maxContext), this.xCentre - xVariation1 - 80, this.yCentre - yVariation1);
        e.gc.drawLine(this.xCentre, this.yCentre, this.xCentre + xVariation1, this.yCentre - yVariation1);
        e.gc.drawString("step", this.xCentre + xVariation1 + 10, this.yCentre - yVariation1 - 20);
        e.gc.drawString(String.valueOf(Integer.toString(this.currentStep)) + "/" + Integer.toString(this.maxStep), this.xCentre + xVariation1 + 10, this.yCentre - yVariation1);
        int xVariation2 = (int)((double)this.rayon * 0.588);
        int yVariation2 = (int)((double)this.rayon * 0.809);
        e.gc.drawLine(this.xCentre, this.yCentre, this.xCentre - xVariation2, this.yCentre + yVariation2);
        e.gc.drawString("depth", this.xCentre - xVariation2 - 20, this.yCentre + yVariation2 + 10);
        e.gc.drawString(String.valueOf(Integer.toString(this.currentDepth)) + "/" + Integer.toString(this.maxDepth), this.xCentre - xVariation2 - 20, this.yCentre + yVariation2 + 30);
        e.gc.drawLine(this.xCentre, this.yCentre, this.xCentre + xVariation2, this.yCentre + yVariation2);
        e.gc.drawString("width", this.xCentre + xVariation2 - 20, this.yCentre + yVariation2 + 10);
        e.gc.drawString(String.valueOf(Integer.toString(this.currentWidth)) + "/" + Integer.toString(this.maxWidth), this.xCentre + xVariation2 - 20, this.yCentre + yVariation2 + 30);
        this.draw5RegularSegments(e, this.rayon / 4);
        this.draw5RegularSegments(e, this.rayon / 2);
        this.draw5RegularSegments(e, this.rayon / 4 * 3);
        this.draw5RegularSegments(e, this.rayon);
    }

    public void draw5RegularSegments(PaintEvent pe, int lg) {
        int xVariation1 = (int)((double)lg * 0.951);
        int yVariation1 = (int)((double)lg * 0.309);
        pe.gc.drawLine(this.xCentre, this.yCentre - lg, this.xCentre - xVariation1, this.yCentre - yVariation1);
        pe.gc.drawLine(this.xCentre, this.yCentre - lg, this.xCentre + xVariation1, this.yCentre - yVariation1);
        int xVariation2 = (int)((double)lg * 0.588);
        int yVariation2 = (int)((double)lg * 0.809);
        pe.gc.drawLine(this.xCentre - xVariation1, this.yCentre - yVariation1, this.xCentre - xVariation2, this.yCentre + yVariation2);
        pe.gc.drawLine(this.xCentre + xVariation1, this.yCentre - yVariation1, this.xCentre + xVariation2, this.yCentre + yVariation2);
        pe.gc.drawLine(this.xCentre - xVariation2, this.yCentre + yVariation2, this.xCentre + xVariation2, this.yCentre + yVariation2);
    }

    public void draw5CurrentSegments(PaintEvent pe, int cCoverage, int mCoverage, int cStep, int mStep, int cWidth, int mWidth, int cDepth, int mDepth, int cContext, int mContext) {
        if (mCoverage == 0 || mContext == 0 || mDepth == 0 || mWidth == 0 || mStep == 0) {
            return;
        }
        int lgPoint = this.rayon * cCoverage / mCoverage;
        int xP1 = this.xCentre;
        int yP1 = this.yCentre - lgPoint;
        lgPoint = this.rayon * cContext / mContext;
        int xVariation = (int)((double)lgPoint * 0.951);
        int yVariation = (int)((double)lgPoint * 0.309);
        int xP2 = this.xCentre - xVariation;
        int yP2 = this.yCentre - yVariation;
        lgPoint = this.rayon * cDepth / mDepth;
        xVariation = (int)((double)lgPoint * 0.588);
        yVariation = (int)((double)lgPoint * 0.809);
        int xP3 = this.xCentre - xVariation;
        int yP3 = this.yCentre + yVariation;
        lgPoint = this.rayon * cWidth / mWidth;
        xVariation = (int)((double)lgPoint * 0.588);
        yVariation = (int)((double)lgPoint * 0.809);
        int xP4 = this.xCentre + xVariation;
        int yP4 = this.yCentre + yVariation;
        lgPoint = this.rayon * cStep / mStep;
        xVariation = (int)((double)lgPoint * 0.951);
        yVariation = (int)((double)lgPoint * 0.309);
        int xP5 = this.xCentre + xVariation;
        int yP5 = this.yCentre - yVariation;
        Display device = Display.getCurrent();
        if (cCoverage < mCoverage) {
            pe.gc.setForeground(device.getSystemColor(3));
        } else {
            pe.gc.setForeground(device.getSystemColor(6));
            pe.gc.drawString(this.spiderTitle, this.xDecalage + 60, this.yDecalage - 80);
            pe.gc.setForeground(device.getSystemColor(5));
        }
        pe.gc.setLineWidth(3);
        pe.gc.drawLine(xP1, yP1, xP2, yP2);
        pe.gc.drawLine(xP2, yP2, xP3, yP3);
        pe.gc.drawLine(xP3, yP3, xP4, yP4);
        pe.gc.drawLine(xP4, yP4, xP5, yP5);
        pe.gc.drawLine(xP5, yP5, xP1, yP1);
    }

    private void drawExe2(PaintEvent pe) {
        Display device = Display.getCurrent();
        if (this.currentCoverage < this.maxCoverage) {
            pe.gc.setForeground(device.getSystemColor(3));
            pe.gc.drawString(this.spiderTitle, this.xDecalage + 60, this.yDecalage - 80);
        } else {
            pe.gc.setForeground(device.getSystemColor(6));
            pe.gc.drawString(this.spiderTitle, this.xDecalage + 60, this.yDecalage - 80);
        }
        pe.gc.drawString("Trace extension:", this.xDecalage + 250, this.yDecalage - 80);
        pe.gc.drawString("- step = " + this.currentStep2, this.xDecalage + 250, this.yDecalage - 60);
        pe.gc.drawString("- context = " + this.currentContext2, this.xDecalage + 250, this.yDecalage - 40);
        pe.gc.drawString("- depth = " + this.currentDepth2, this.xDecalage + 250, this.yDecalage - 20);
        pe.gc.drawString("- width = " + this.currentWidth2, this.xDecalage + 250, this.yDecalage);
    }

    public void updateSpider(int exeNumber, int cStep, int mStep, int cContext, int mContext, int cDepth, int mDepth, int cWidth, int mWidth, int cCoverage, int mCoverage) {
        this.executionNumber = exeNumber;
        if (exeNumber == 1) {
            this.currentStep = cStep;
            this.maxStep = mStep;
            this.currentContext = cContext;
            this.maxContext = mContext;
            this.currentDepth = cDepth;
            this.maxDepth = mDepth;
            this.currentWidth = cWidth;
            this.maxWidth = mWidth;
            this.currentCoverage = cCoverage;
            this.maxCoverage = mCoverage;
        } else if (LaunchDelegate.fEnableTraceExtension && exeNumber > 1) {
            this.currentStep2 = cStep;
            this.currentContext2 = cContext;
            this.currentDepth2 = cDepth;
            this.currentWidth2 = cWidth;
        }
        this.fRedrawBySystem = false;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                SWTSpider.this.redraw();
            }
        });
        this.fRedrawBySystem = true;
    }
}

