/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.RefreshUtil;
import org.eclipse.debug.core.model.IProcess;

public class BackgroundResourceRefresher
implements IDebugEventSetListener {
    private ILaunchConfiguration fConfiguration;
    private IProcess fProcess;

    public BackgroundResourceRefresher(ILaunchConfiguration configuration, IProcess process) {
        this.fConfiguration = configuration;
        this.fProcess = process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBackgroundRefresh() {
        IProcess iProcess = this.fProcess;
        synchronized (iProcess) {
            if (this.fProcess.isTerminated()) {
                this.refresh();
            } else {
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
            }
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource() == this.fProcess && event.getKind() == 8) {
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                this.refresh();
                break;
            }
            ++i;
        }
    }

    protected void refresh() {
        Job job = new Job("Refreshing resources..."){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    RefreshUtil.refreshResources((ILaunchConfiguration)BackgroundResourceRefresher.this.fConfiguration, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

