/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.GitDateFormatter;

public class PreferenceBasedDateFormatter
extends GitDateFormatter {
    private final SimpleDateFormat customFormat;

    @NonNull
    public static PreferenceBasedDateFormatter create() {
        String choice = Activator.getDefault().getPreferenceStore().getString("date_format_choice");
        GitDateFormatter.Format format = null;
        try {
            format = GitDateFormatter.Format.valueOf((String)choice);
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
        return new PreferenceBasedDateFormatter(format);
    }

    private PreferenceBasedDateFormatter(GitDateFormatter.Format gitFormat) {
        super(gitFormat != null ? gitFormat : GitDateFormatter.Format.DEFAULT);
        SimpleDateFormat format = null;
        if (gitFormat == null) {
            String pattern = Activator.getDefault().getPreferenceStore().getString("date_format");
            try {
                format = new SimpleDateFormat(pattern);
            }
            catch (IllegalArgumentException | NullPointerException e1) {
                Activator.logError("org.eclipse.egit.ui preference date_format is invalid; ignoring", e1);
                format = new SimpleDateFormat(Activator.getDefault().getPreferenceStore().getDefaultString("date_format"));
            }
        }
        this.customFormat = format;
    }

    public String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        TimeZone timeZone = TimeZone.getDefault();
        Assert.isNotNull((Object)timeZone);
        return this.formatDate(date, timeZone);
    }

    public String formatDate(@NonNull Date date, @NonNull TimeZone timeZone) {
        return this.formatDate(new PersonIdent("", "", date, timeZone));
    }

    public String formatDate(PersonIdent ident) {
        if (ident == null) {
            return "";
        }
        if (this.customFormat == null) {
            return super.formatDate(ident);
        }
        return this.customFormat.format(ident.getWhen());
    }
}

