/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.ArtifactInfoPostprocessor;
import org.apache.maven.index.CleaningEncoder;
import org.apache.maven.index.Field;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.IteratorResultSet;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.MatchHighlight;
import org.apache.maven.index.MatchHighlightMode;
import org.apache.maven.index.MatchHighlightRequest;
import org.apache.maven.index.OneLineFragmenter;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.creator.JarFileContentsIndexCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIteratorResultSet
implements IteratorResultSet {
    private static final int HARD_HIT_COUNT_LIMIT = Integer.MAX_VALUE;
    private final IteratorSearchRequest searchRequest;
    private final IndexSearcher indexSearcher;
    private final List<IndexingContext> contexts;
    private final int[] starts;
    private final ArtifactInfoFilter filter;
    private final ArtifactInfoPostprocessor postprocessor;
    private final List<MatchHighlightRequest> matchHighlightRequests;
    private final Hits hits;
    private final int from;
    private final int count;
    private final int maxRecPointer;
    private int pointer;
    private int processedArtifactInfoCount;
    private ArtifactInfo ai;

    protected DefaultIteratorResultSet(IteratorSearchRequest request, IndexSearcher indexSearcher, List<IndexingContext> contexts, Hits hits) throws IOException {
        this.searchRequest = request;
        this.indexSearcher = indexSearcher;
        this.contexts = contexts;
        int maxDoc = 0;
        this.starts = new int[contexts.size() + 1];
        for (int i = 0; i < contexts.size(); ++i) {
            this.starts[i] = maxDoc;
            maxDoc += contexts.get(i).getIndexReader().maxDoc();
        }
        this.starts[contexts.size()] = maxDoc;
        this.filter = request.getArtifactInfoFilter();
        this.postprocessor = request.getArtifactInfoPostprocessor();
        this.matchHighlightRequests = request.getMatchHighlightRequests();
        this.hits = hits;
        this.from = request.getStart() == -1 ? 0 : request.getStart();
        this.count = request.getCount() == -1 ? Integer.MAX_VALUE : Math.min(request.getCount(), Integer.MAX_VALUE);
        this.pointer = this.from;
        this.processedArtifactInfoCount = 0;
        this.maxRecPointer = this.from + this.count;
        this.ai = this.createNextAi();
    }

    @Override
    public boolean hasNext() {
        return this.ai != null;
    }

    @Override
    public ArtifactInfo next() {
        ArtifactInfo result = this.ai;
        try {
            this.ai = this.createNextAi();
        }
        catch (IOException e) {
            this.ai = null;
            throw new IllegalStateException("Cannot fetch next ArtifactInfo!", e);
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Method not supported on " + this.getClass().getName());
    }

    @Override
    public Iterator<ArtifactInfo> iterator() {
        return this;
    }

    @Override
    public int getTotalProcessedArtifactInfoCount() {
        return this.processedArtifactInfoCount;
    }

    protected ArtifactInfo createNextAi() throws IOException {
        ArtifactInfo result = null;
        while (result == null && this.pointer < this.maxRecPointer && this.pointer < this.hits.length()) {
            IndexingContext context;
            Document doc = this.hits.doc(this.pointer);
            result = IndexUtils.constructArtifactInfo(doc, context = this.getIndexingContextForPointer(doc, this.hits.id(this.pointer)));
            if (result != null) {
                result.setLuceneScore(this.hits.score(this.pointer));
                result.repository = context.getRepositoryId();
                result.context = context.getId();
                if (this.filter != null && !this.filter.accepts(context, result)) {
                    result = null;
                }
                if (result != null && this.postprocessor != null) {
                    this.postprocessor.postprocess(context, result);
                }
                if (result != null && this.matchHighlightRequests.size() > 0) {
                    this.calculateHighlights(context, doc, result);
                }
            }
            ++this.pointer;
            ++this.processedArtifactInfoCount;
        }
        return result;
    }

    protected void calculateHighlights(IndexingContext context, Document d, ArtifactInfo ai) throws IOException {
        IndexerField field = null;
        String text = null;
        List<String> highlightFragment = null;
        for (MatchHighlightRequest hr : this.matchHighlightRequests) {
            field = this.selectStoredIndexerField(hr.getField());
            if (field == null || (text = ai.getFieldValue(field.getOntology())) == null || (highlightFragment = this.highlightField(context, hr, field, text)) == null || highlightFragment.size() <= 0) continue;
            MatchHighlight matchHighlight = new MatchHighlight(hr.getField(), highlightFragment);
            ai.getMatchHighlights().add(matchHighlight);
        }
    }

    protected IndexerField selectStoredIndexerField(Field field) {
        if (MAVEN.CLASSNAMES.equals(field)) {
            return JarFileContentsIndexCreator.FLD_CLASSNAMES;
        }
        return field.getIndexerFields().isEmpty() ? null : field.getIndexerFields().iterator().next();
    }

    protected List<String> highlightField(IndexingContext context, MatchHighlightRequest hr, IndexerField field, String text) throws IOException {
        if (MAVEN.CLASSNAMES.equals(field.getOntology())) {
            text = text.replace('/', '.').replaceAll("^\\.", "").replaceAll("\n\\.", "\n");
        }
        Query rewrittenQuery = hr.getQuery().rewrite(context.getIndexReader());
        CachingTokenFilter tokenStream = new CachingTokenFilter(context.getAnalyzer().tokenStream(field.getKey(), (Reader)new StringReader(text)));
        SimpleHTMLFormatter formatter = null;
        if (!MatchHighlightMode.HTML.equals((Object)hr.getHighlightMode())) {
            throw new UnsupportedOperationException("Hightlight more \"" + hr.getHighlightMode().toString() + "\" is not supported!");
        }
        formatter = new SimpleHTMLFormatter();
        return this.getBestFragments(rewrittenQuery, (Formatter)formatter, (TokenStream)tokenStream, text, 3);
    }

    protected final List<String> getBestFragments(Query query, Formatter formatter, TokenStream tokenStream, String text, int maxNumFragments) throws IOException {
        Highlighter highlighter = new Highlighter(formatter, (Encoder)new CleaningEncoder(), (Scorer)new QueryScorer(query));
        highlighter.setTextFragmenter((Fragmenter)new OneLineFragmenter());
        tokenStream.reset();
        maxNumFragments = Math.max(1, maxNumFragments);
        TextFragment[] frag = highlighter.getBestTextFragments(tokenStream, text, false, maxNumFragments);
        ArrayList<String> fragTexts = new ArrayList<String>(maxNumFragments);
        for (int i = 0; i < frag.length; ++i) {
            if (frag[i] == null || !(frag[i].getScore() > 0.0f)) continue;
            fragTexts.add(frag[i].toString());
        }
        return fragTexts;
    }

    protected IndexingContext getIndexingContextForPointer(Document doc, int docPtr) {
        return this.contexts.get(DefaultIteratorResultSet.readerIndex(docPtr, this.starts, this.contexts.size()));
    }

    private static int readerIndex(int n, int[] starts, int numSubReaders) {
        int lo = 0;
        int hi = numSubReaders - 1;
        while (hi >= lo) {
            int mid = lo + hi >>> 1;
            int midValue = starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < numSubReaders && starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }
}

