/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.common.PomManager;
import org.apache.maven.archetype.downloader.DownloadException;
import org.apache.maven.archetype.downloader.DownloadNotFoundException;
import org.apache.maven.archetype.downloader.Downloader;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.metadata.io.xpp3.ArchetypeDescriptorXpp3Reader;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptor;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptorBuilder;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Model;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ArchetypeArtifactManager.class)
public class DefaultArchetypeArtifactManager
extends AbstractLogEnabled
implements ArchetypeArtifactManager {
    @Requirement
    private Downloader downloader;
    @Requirement
    private PomManager pomManager;
    private Map<String, File> archetypeCache = new TreeMap<String, File>();

    @Override
    public File getArchetypeFile(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> repositories) throws UnknownArchetype {
        try {
            File archetype = this.getArchetype(groupId, artifactId, version);
            if (archetype == null) {
                archetype = this.downloader.download(groupId, artifactId, version, archetypeRepository, localRepository, repositories);
                this.setArchetype(groupId, artifactId, version, archetype);
            }
            return archetype;
        }
        catch (DownloadNotFoundException ex) {
            throw new UnknownArchetype(ex);
        }
        catch (DownloadException ex) {
            throw new UnknownArchetype(ex);
        }
    }

    @Override
    public ClassLoader getArchetypeJarLoader(File archetypeFile) throws UnknownArchetype {
        try {
            URL[] urls = new URL[]{archetypeFile.toURI().toURL()};
            return new URLClassLoader(urls);
        }
        catch (MalformedURLException e) {
            throw new UnknownArchetype(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model getArchetypePom(File jar) throws XmlPullParserException, UnknownArchetype, IOException {
        Model model;
        ZipEntry pom;
        ZipFile zipFile;
        block6: {
            String pomFileName;
            block5: {
                zipFile = null;
                try {
                    ZipEntry el;
                    pomFileName = null;
                    zipFile = this.getArchetypeZipFile(jar);
                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                    while (enumeration.hasMoreElements()) {
                        el = enumeration.nextElement();
                        String entry = el.getName();
                        if (!entry.startsWith("META-INF") || !entry.endsWith("pom.xml")) continue;
                        pomFileName = entry;
                    }
                    if (pomFileName != null) break block5;
                    el = null;
                    this.closeZipFile(zipFile);
                    return el;
                }
                catch (Throwable throwable) {
                    this.closeZipFile(zipFile);
                    throw throwable;
                }
            }
            pom = zipFile.getEntry(pomFileName);
            if (pom != null) break block6;
            model = null;
            this.closeZipFile(zipFile);
            return model;
        }
        model = this.pomManager.readPom(zipFile.getInputStream(pom));
        this.closeZipFile(zipFile);
        return model;
    }

    @Override
    public ZipFile getArchetypeZipFile(File archetypeFile) throws UnknownArchetype {
        try {
            return new ZipFile(archetypeFile);
        }
        catch (ZipException e) {
            throw new UnknownArchetype(e);
        }
        catch (IOException e) {
            throw new UnknownArchetype(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean isFileSetArchetype(File archetypeFile) {
        ZipFile zipFile = null;
        try {
            this.getLogger().debug("checking fileset archetype status on " + archetypeFile);
            zipFile = this.getArchetypeZipFile(archetypeFile);
            boolean bl = this.isFileSetArchetype(zipFile);
            if (zipFile != null) {
                this.closeZipFile(zipFile);
            }
            return bl;
        }
        catch (IOException e) {
            this.getLogger().debug(e.toString());
            boolean bl = false;
            if (zipFile != null) {
                this.closeZipFile(zipFile);
            }
            return bl;
        }
        catch (UnknownArchetype e2) {
            this.getLogger().debug(e2.toString());
            boolean bl = false;
            if (zipFile != null) {
                this.closeZipFile(zipFile);
            }
            return bl;
            {
                catch (Throwable throwable) {
                    if (zipFile != null) {
                        this.closeZipFile(zipFile);
                    }
                    throw throwable;
                }
            }
        }
    }

    @Override
    public boolean isFileSetArchetype(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> repositories) {
        try {
            File archetypeFile = this.getArchetypeFile(groupId, artifactId, version, archetypeRepository, localRepository, repositories);
            return this.isFileSetArchetype(archetypeFile);
        }
        catch (UnknownArchetype e) {
            this.getLogger().debug(e.toString());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean isOldArchetype(File archetypeFile) {
        ZipFile zipFile = null;
        try {
            this.getLogger().debug("checking old archetype status on " + archetypeFile);
            zipFile = this.getArchetypeZipFile(archetypeFile);
            boolean bl = this.isOldArchetype(zipFile);
            if (zipFile != null) {
                this.closeZipFile(zipFile);
            }
            return bl;
        }
        catch (IOException e) {
            this.getLogger().debug(e.toString());
            boolean bl = false;
            if (zipFile != null) {
                this.closeZipFile(zipFile);
            }
            return bl;
        }
        catch (UnknownArchetype e2) {
            this.getLogger().debug(e2.toString());
            boolean bl = false;
            if (zipFile != null) {
                this.closeZipFile(zipFile);
            }
            return bl;
            {
                catch (Throwable throwable) {
                    if (zipFile != null) {
                        this.closeZipFile(zipFile);
                    }
                    throw throwable;
                }
            }
        }
    }

    @Override
    public boolean isOldArchetype(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> repositories) {
        try {
            File archetypeFile = this.getArchetypeFile(groupId, artifactId, version, archetypeRepository, localRepository, repositories);
            return this.isOldArchetype(archetypeFile);
        }
        catch (UnknownArchetype e) {
            this.getLogger().debug(e.toString());
            return false;
        }
    }

    @Override
    public boolean exists(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) {
        try {
            File archetype = this.getArchetype(archetypeGroupId, archetypeArtifactId, archetypeVersion);
            if (archetype == null) {
                archetype = this.downloader.download(archetypeGroupId, archetypeArtifactId, archetypeVersion, archetypeRepository, localRepository, remoteRepositories);
                this.setArchetype(archetypeGroupId, archetypeArtifactId, archetypeVersion, archetype);
            }
            return archetype.exists();
        }
        catch (DownloadException e) {
            this.getLogger().debug("Archetype " + archetypeGroupId + ":" + archetypeArtifactId + ":" + archetypeVersion + " doesn't exist", (Throwable)e);
            return false;
        }
        catch (DownloadNotFoundException e) {
            this.getLogger().debug("Archetype " + archetypeGroupId + ":" + archetypeArtifactId + ":" + archetypeVersion + " doesn't exist", (Throwable)e);
            return false;
        }
    }

    @Override
    public org.apache.maven.archetype.metadata.ArchetypeDescriptor getFileSetArchetypeDescriptor(File archetypeFile) throws UnknownArchetype {
        ZipFile zipFile = null;
        try {
            zipFile = this.getArchetypeZipFile(archetypeFile);
            org.apache.maven.archetype.metadata.ArchetypeDescriptor archetypeDescriptor = this.loadFileSetArchetypeDescriptor(zipFile);
            return archetypeDescriptor;
        }
        catch (XmlPullParserException e) {
            throw new UnknownArchetype(e);
        }
        catch (IOException e) {
            throw new UnknownArchetype(e);
        }
        finally {
            this.closeZipFile(zipFile);
        }
    }

    @Override
    public org.apache.maven.archetype.metadata.ArchetypeDescriptor getFileSetArchetypeDescriptor(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> repositories) throws UnknownArchetype {
        File archetypeFile = this.getArchetypeFile(groupId, artifactId, version, archetypeRepository, localRepository, repositories);
        return this.getFileSetArchetypeDescriptor(archetypeFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getFilesetArchetypeResources(File archetypeFile) throws UnknownArchetype {
        this.getLogger().debug("getFilesetArchetypeResources( \"" + archetypeFile.getAbsolutePath() + "\" )");
        ArrayList<String> archetypeResources = new ArrayList<String>();
        ZipFile zipFile = null;
        try {
            zipFile = this.getArchetypeZipFile(archetypeFile);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                if (entry.getName().startsWith("archetype-resources")) {
                    String resource = entry.getName().substring("archetype-resources".length() + 1);
                    this.getLogger().debug("  - found resource (archetype-resources/)" + resource);
                    archetypeResources.add(resource);
                    continue;
                }
                this.getLogger().debug("  - ignored resource " + entry.getName());
            }
            ArrayList<String> arrayList = archetypeResources;
            return arrayList;
        }
        finally {
            this.closeZipFile(zipFile);
        }
    }

    @Override
    public ArchetypeDescriptor getOldArchetypeDescriptor(File archetypeFile) throws UnknownArchetype {
        ZipFile zipFile = null;
        try {
            zipFile = this.getArchetypeZipFile(archetypeFile);
            ArchetypeDescriptor archetypeDescriptor = this.loadOldArchetypeDescriptor(zipFile);
            return archetypeDescriptor;
        }
        catch (XmlPullParserException e) {
            throw new UnknownArchetype(e);
        }
        catch (IOException e) {
            throw new UnknownArchetype(e);
        }
        finally {
            this.closeZipFile(zipFile);
        }
    }

    @Override
    public ArchetypeDescriptor getOldArchetypeDescriptor(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> repositories) throws UnknownArchetype {
        File archetypeFile = this.getArchetypeFile(groupId, artifactId, version, archetypeRepository, localRepository, repositories);
        return this.getOldArchetypeDescriptor(archetypeFile);
    }

    private File getArchetype(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion) {
        String key = archetypeGroupId + ":" + archetypeArtifactId + ":" + archetypeVersion;
        if (this.archetypeCache.containsKey(key)) {
            this.getLogger().debug("Found archetype " + key + " in cache: " + this.archetypeCache.get(key));
            return this.archetypeCache.get(key);
        }
        this.getLogger().debug("Not found archetype " + key + " in cache");
        return null;
    }

    private void setArchetype(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion, File archetype) {
        String key = archetypeGroupId + ":" + archetypeArtifactId + ":" + archetypeVersion;
        this.archetypeCache.put(key, archetype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFileSetArchetype(ZipFile zipFile) throws IOException {
        Reader reader = null;
        try {
            reader = this.getArchetypeDescriptorReader(zipFile);
            boolean bl = reader != null;
            return bl;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOldArchetype(ZipFile zipFile) throws IOException {
        Reader reader = null;
        try {
            reader = this.getOldArchetypeDescriptorReader(zipFile);
            boolean bl = reader != null;
            return bl;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private org.apache.maven.archetype.metadata.ArchetypeDescriptor loadFileSetArchetypeDescriptor(ZipFile zipFile) throws IOException, XmlPullParserException {
        Reader reader = null;
        try {
            reader = this.getArchetypeDescriptorReader(zipFile);
            if (reader == null) {
                org.apache.maven.archetype.metadata.ArchetypeDescriptor archetypeDescriptor = null;
                return archetypeDescriptor;
            }
            ArchetypeDescriptorXpp3Reader archetypeReader = new ArchetypeDescriptorXpp3Reader();
            org.apache.maven.archetype.metadata.ArchetypeDescriptor archetypeDescriptor = archetypeReader.read(reader, false);
            return archetypeDescriptor;
        }
        catch (IOException e) {
            throw e;
        }
        catch (XmlPullParserException e) {
            throw e;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private ArchetypeDescriptor loadOldArchetypeDescriptor(ZipFile zipFile) throws IOException, XmlPullParserException {
        Reader reader = null;
        try {
            reader = this.getOldArchetypeDescriptorReader(zipFile);
            if (reader == null) {
                ArchetypeDescriptor archetypeDescriptor = null;
                return archetypeDescriptor;
            }
            ArchetypeDescriptorBuilder builder = new ArchetypeDescriptorBuilder();
            ArchetypeDescriptor archetypeDescriptor = builder.build(reader);
            return archetypeDescriptor;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (XmlPullParserException ex) {
            throw ex;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private Reader getArchetypeDescriptorReader(ZipFile zipFile) throws IOException {
        return this.getDescriptorReader(zipFile, "META-INF/maven/archetype-metadata.xml");
    }

    private Reader getOldArchetypeDescriptorReader(ZipFile zipFile) throws IOException {
        Reader reader = this.getDescriptorReader(zipFile, "META-INF/maven/archetype.xml");
        if (reader == null) {
            reader = this.getDescriptorReader(zipFile, "META-INF/archetype.xml");
        }
        return reader;
    }

    private Reader getDescriptorReader(ZipFile zipFile, String descriptor) throws IOException {
        ZipEntry entry = this.searchEntry(zipFile, descriptor);
        if (entry == null) {
            return null;
        }
        InputStream is = zipFile.getInputStream(entry);
        if (is == null) {
            throw new IOException("The " + descriptor + " descriptor cannot be read in " + zipFile.getName() + ".");
        }
        return ReaderFactory.newXmlReader((InputStream)is);
    }

    private ZipEntry searchEntry(ZipFile zipFile, String searchString) {
        this.getLogger().debug("Searching for " + searchString + " inside " + zipFile.getName());
        Enumeration<? extends ZipEntry> enu = zipFile.entries();
        while (enu.hasMoreElements()) {
            ZipEntry entryfound = enu.nextElement();
            this.getLogger().debug("  - " + entryfound.getName());
            if (!searchString.equals(entryfound.getName())) continue;
            this.getLogger().debug("Entry found");
            return entryfound;
        }
        return null;
    }

    private void closeZipFile(ZipFile zipFile) {
        try {
            zipFile.close();
        }
        catch (Exception e) {
            this.getLogger().error("Failed to close " + zipFile.getName() + " zipFile.");
        }
    }
}

