/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.util.ContributorBlackList;
import org.eclipse.mylyn.internal.tasks.ui.BrandManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.spi.RepositoryConnectorBranding;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RepositoryConnectorUiExtensionReader {
    private static final String EXTENSION_REPOSITORIES = "org.eclipse.mylyn.tasks.ui.repositories";
    public static final String ELMNT_REPOSITORY_UI = "connectorUi";
    private static final String ATTR_BRANDING_ICON = "brandingIcon";
    private static final String ATTR_OVERLAY_ICON = "overlayIcon";
    private static final String ATTR_CLASS = "class";
    private final IExtensionRegistry registry;
    private final ContributorBlackList blackList;

    public RepositoryConnectorUiExtensionReader(IExtensionRegistry registry, ContributorBlackList blackList) {
        Assert.isNotNull((Object)registry);
        Assert.isNotNull((Object)blackList);
        this.registry = registry;
        this.blackList = blackList;
    }

    public void registerConnectorUis() {
        this.registerFromExtensionPoint();
        this.registerFromAdaptable();
        this.registerConnetorToConnectorUi();
    }

    private void registerConnetorToConnectorUi() {
        for (AbstractRepositoryConnector connector : TasksUi.getRepositoryManager().getRepositoryConnectors()) {
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(connector.getConnectorKind());
            if (connectorUi == null) continue;
            RepositoryConnectorUiExtensionReader.setConnectorForConnectorUi(connector, connectorUi);
        }
    }

    private void registerFromAdaptable() {
        for (AbstractRepositoryConnector connector : TasksUi.getRepositoryManager().getRepositoryConnectors()) {
            if (TasksUiPlugin.getConnectorUi(connector.getConnectorKind()) != null) continue;
            this.registerFromAdaptable(connector);
        }
    }

    private void registerFromAdaptable(final AbstractRepositoryConnector connector) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                RepositoryConnectorBranding branding;
                AbstractRepositoryConnectorUi connectorUi = RepositoryConnectorUiExtensionReader.this.loadAdapter(connector, AbstractRepositoryConnectorUi.class);
                if (connectorUi != null) {
                    TasksUiPlugin.getDefault().addRepositoryConnectorUi(connectorUi);
                }
                if ((branding = RepositoryConnectorUiExtensionReader.this.loadAdapter(connector, RepositoryConnectorBranding.class)) != null) {
                    this.addDefaultImageData(connector, branding);
                    RepositoryConnectorUiExtensionReader.this.addBranding(connector.getConnectorKind(), branding);
                }
            }

            protected void addDefaultImageData(AbstractRepositoryConnector connector2, RepositoryConnectorBranding branding) throws IOException {
                InputStream overlayImageData;
                InputStream brandingImageData = branding.getBrandingImageData();
                if (brandingImageData != null) {
                    try {
                        ((BrandManager)TasksUiPlugin.getDefault().getBrandManager()).addDefaultBrandingIcon(connector2.getConnectorKind(), RepositoryConnectorUiExtensionReader.this.getImage(brandingImageData));
                    }
                    finally {
                        RepositoryConnectorUiExtensionReader.this.closeQuietly(brandingImageData);
                    }
                }
                if ((overlayImageData = branding.getOverlayImageData()) != null) {
                    try {
                        ((BrandManager)TasksUiPlugin.getDefault().getBrandManager()).addDefaultOverlayIcon(connector2.getConnectorKind(), RepositoryConnectorUiExtensionReader.this.getImageDescriptor(overlayImageData));
                    }
                    finally {
                        RepositoryConnectorUiExtensionReader.this.closeQuietly(brandingImageData);
                    }
                }
            }

            public void handleException(Throwable e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Loading of connector ui for kind ''{0}'' failed.", (Object)connector.getConnectorKind()), e));
            }
        });
    }

    protected void addBranding(String connectorKind, RepositoryConnectorBranding branding) throws IOException {
        BrandManager brandManager = (BrandManager)TasksUiPlugin.getDefault().getBrandManager();
        for (String brand : branding.getBrands()) {
            if (brand == null) continue;
            try {
                InputStream overlayImageData;
                InputStream brandingImageData;
                String connectorLabel = branding.getConnectorLabel(brand);
                if (connectorLabel != null) {
                    brandManager.addConnectorLabel(connectorKind, brand, connectorLabel);
                }
                if ((brandingImageData = branding.getBrandingImageData(brand)) != null) {
                    try {
                        brandManager.addBrandingIcon(connectorKind, brand, this.getImage(brandingImageData));
                    }
                    finally {
                        this.closeQuietly(brandingImageData);
                    }
                }
                if ((overlayImageData = branding.getOverlayImageData(brand)) == null) continue;
                try {
                    brandManager.addOverlayIcon(connectorKind, brand, this.getImageDescriptor(overlayImageData));
                }
                finally {
                    this.closeQuietly(brandingImageData);
                }
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Loading of brand ''{0}'' for kind ''{1}'' failed.", (Object)brand, (Object)connectorKind), (Throwable)e));
            }
        }
    }

    private void closeQuietly(InputStream in) {
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    public <T> T loadAdapter(AbstractRepositoryConnector connector, Class<T> klass) {
        Object adapter = null;
        if (connector instanceof IAdaptable) {
            adapter = ((IAdaptable)connector).getAdapter(klass);
        }
        if (adapter == null) {
            adapter = Platform.getAdapterManager().loadAdapter((Object)connector, klass.getName());
        }
        return (T)adapter;
    }

    private ImageDescriptor getImageDescriptor(InputStream in) {
        return ImageDescriptor.createFromImageData((ImageData)new ImageData(in));
    }

    private Image getImage(InputStream in) {
        return CommonImages.getImage((ImageDescriptor)this.getImageDescriptor(in));
    }

    private void registerFromExtensionPoint() {
        IExtension[] repositoryExtensions;
        IExtensionPoint repositoriesExtensionPoint = this.registry.getExtensionPoint(EXTENSION_REPOSITORIES);
        IExtension[] iExtensionArray = repositoryExtensions = repositoriesExtensionPoint.getExtensions();
        int n = repositoryExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension repositoryExtension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = repositoryExtension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (!this.blackList.isDisabled(element) && element.getName().equals(ELMNT_REPOSITORY_UI)) {
                    this.registerRepositoryConnectorUi(element);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void registerRepositoryConnectorUi(IConfigurationElement element) {
        try {
            Object connectorUiObject = element.createExecutableExtension(ATTR_CLASS);
            if (connectorUiObject instanceof AbstractRepositoryConnectorUi) {
                AbstractRepositoryConnectorUi connectorUi = (AbstractRepositoryConnectorUi)connectorUiObject;
                AbstractRepositoryConnector connector = TasksUiPlugin.getConnector(connectorUi.getConnectorKind());
                if (connector != null) {
                    RepositoryConnectorBranding branding;
                    ImageDescriptor descriptor;
                    String overlayIconPath;
                    ImageDescriptor descriptor2;
                    TasksUiPlugin.getDefault().addRepositoryConnectorUi(connectorUi);
                    String iconPath = element.getAttribute(ATTR_BRANDING_ICON);
                    if (iconPath != null && (descriptor2 = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)iconPath)) != null) {
                        ((BrandManager)TasksUiPlugin.getDefault().getBrandManager()).addDefaultBrandingIcon(connectorUi.getConnectorKind(), CommonImages.getImage((ImageDescriptor)descriptor2));
                    }
                    if ((overlayIconPath = element.getAttribute(ATTR_OVERLAY_ICON)) != null && (descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)overlayIconPath)) != null) {
                        ((BrandManager)TasksUiPlugin.getDefault().getBrandManager()).addDefaultOverlayIcon(connectorUi.getConnectorKind(), descriptor);
                    }
                    if ((branding = this.loadAdapter(connector, RepositoryConnectorBranding.class)) != null) {
                        this.addBranding(connector.getConnectorKind(), branding);
                    }
                } else {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", NLS.bind((String)"Ignoring connector ui for kind ''{0}'' without corresponding core contributed by ''{1}''.", (Object)connectorUi.getConnectorKind(), (Object)element.getContributor().getName())));
                }
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load connector ui " + connectorUiObject.getClass().getCanonicalName()));
            }
        }
        catch (Throwable e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not load connector ui", e));
        }
    }

    private static void setConnectorForConnectorUi(AbstractRepositoryConnector connector, AbstractRepositoryConnectorUi connectorUi) {
        try {
            Field field = AbstractRepositoryConnectorUi.class.getDeclaredField("connector");
            field.setAccessible(true);
            field.set(connectorUi, connector);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Unable to call setConnector()", (Throwable)e));
        }
    }
}

