/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.views.executormonitor;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.titan.executor.executors.BaseExecutor;
import org.eclipse.titan.executor.executors.TreeBranch;
import org.eclipse.titan.executor.views.executormonitor.ExecutorStorage;
import org.eclipse.titan.executor.views.executormonitor.LaunchStorage;

public final class LaunchElement
extends TreeBranch {
    private ILaunch launch;
    private boolean terminated;

    public LaunchElement(String name, ILaunch launch) {
        super(name);
        this.launch = launch;
        this.terminated = launch.isTerminated();
    }

    @Override
    public void dispose() {
        if (ExecutorStorage.getExecutorMap().containsKey(this.launch)) {
            BaseExecutor executor = ExecutorStorage.getExecutorMap().get(this.launch);
            executor.dispose();
            ExecutorStorage.getExecutorMap().remove(this.launch);
        }
        LaunchStorage.getLaunchElementMap().remove(this.launch);
        this.launch = null;
        super.dispose();
    }

    public boolean getTerminated() {
        return this.terminated;
    }

    public void setTerminated() {
        this.terminated = true;
    }

    public ILaunch launch() {
        return this.launch;
    }

    public void changed() {
        this.terminated = this.launch.isTerminated();
    }
}

