/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.executors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.executor.executors.ITreeBranch;
import org.eclipse.titan.executor.executors.ITreeLeaf;
import org.eclipse.titan.executor.executors.TreeLeaf;

public class TreeBranch
extends TreeLeaf
implements ITreeBranch {
    private List<ITreeLeaf> children = new ArrayList<ITreeLeaf>();

    public TreeBranch(String name) {
        super(name);
    }

    @Override
    public void dispose() {
        for (ITreeLeaf element : this.children) {
            element.dispose();
        }
        this.children.clear();
        super.dispose();
    }

    @Override
    public final List<ITreeLeaf> children() {
        return this.children;
    }

    public final void addChildToEnd(TreeLeaf element) {
        element.parent(this);
        this.children.add(element);
    }

    public final void addChildBefore(TreeLeaf child, TreeLeaf reference) {
        int index = this.children.indexOf(reference);
        if (index == -1) {
            this.children.add(child);
        } else {
            this.children.add(index, child);
        }
        child.parent(this);
    }

    public final void remove(TreeLeaf element) {
        this.children.remove(element);
        element.parent(null);
    }

    public final void transferChildren(TreeBranch element) {
        for (ITreeLeaf tempElement : element.children) {
            this.children.add(tempElement);
            tempElement.parent(this);
        }
        element.children.clear();
    }
}

