/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.claribole.zgrviewer.ConfigManager;

class BookmarksList
extends JFrame
implements ListSelectionListener {
    ConfigManager cm;
    JList bkList;
    JButton loadBt;
    JButton saveBt;
    JButton addBt;

    BookmarksList(ConfigManager cfm) {
        super("Bookmark List");
        this.cm = cfm;
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.bkList = new JList<Object>(this.cm.bookmarks.keySet().toArray());
        this.bkList.setSelectionMode(0);
        c.add((Component)this.bkList, "Center");
        this.bkList.addListSelectionListener(this);
        JPanel btp = new JPanel();
        btp.setLayout(new GridLayout(1, 3));
        this.addBt = new JButton("Add...");
        btp.add(this.addBt);
        this.loadBt = new JButton("Load...");
        btp.add(this.loadBt);
        this.saveBt = new JButton("Save...");
        btp.add(this.saveBt);
        c.add((Component)btp, "South");
        ActionListener a0 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == BookmarksList.this.addBt) {
                    BookmarksList.this.cm.bookmarkCurrentLocation(BookmarksList.this);
                } else if (e.getSource() == BookmarksList.this.loadBt) {
                    BookmarksList.this.cm.loadBookmarks(BookmarksList.this);
                } else if (e.getSource() == BookmarksList.this.saveBt) {
                    BookmarksList.this.cm.saveBookmarks(BookmarksList.this);
                }
            }
        };
        this.addBt.addActionListener(a0);
        this.loadBt.addActionListener(a0);
        this.saveBt.addActionListener(a0);
        WindowAdapter w0 = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BookmarksList.this.dispose();
            }
        };
        this.addWindowListener(w0);
        this.setSize(400, 300);
        this.setVisible(true);
    }

    void updateList() {
        this.bkList.setListData(this.cm.bookmarks.keySet().toArray());
        this.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.cm.grMngr.goTo(this.cm.bookmarks.get(this.bkList.getSelectedValue()));
        }
    }
}

