/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titan.designer.wizards.GUIProjectImporter;
import org.eclipse.titan.designer.wizards.TITANProjectImportMainPage;
import org.eclipse.titan.designer.wizards.TITANProjectImportPage;
import org.eclipse.titan.designer.wizards.TITANProjectImportRecursivelyPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class TITANProjectImportWizard
extends BasicNewResourceWizard
implements IImportWizard {
    private static final String NEWPROJECT_WINDOWTITLE = "Import new TITAN Project from .prj file";
    private static final String NEWPROJECT_TITLE = "Create a TITAN Project";
    private static final String NEWPROJECT_DESCRIPTION = "Create a new TITAN project in the workspace or in an external location";
    private TITANProjectImportMainPage mainPage;
    private TITANProjectImportPage newProjectPage;
    private TITANProjectImportRecursivelyPage recursivelyPage;
    private boolean wasAutoBuilding;
    private IConfigurationElement config;

    public TITANProjectImportWizard() {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        this.wasAutoBuilding = description.isAutoBuilding();
        description.setAutoBuilding(false);
        try {
            ResourcesPlugin.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        Activator.getDefault().pauseHandlingResourceChanges();
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new TITANProjectImportMainPage(NEWPROJECT_WINDOWTITLE);
        this.mainPage.setTitle(NEWPROJECT_TITLE);
        this.mainPage.setDescription(NEWPROJECT_DESCRIPTION);
        this.addPage((IWizardPage)this.mainPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.mainPage) {
            if (this.newProjectPage == null) {
                this.newProjectPage = new TITANProjectImportPage(NEWPROJECT_WINDOWTITLE);
                this.newProjectPage.setTitle(NEWPROJECT_TITLE);
                this.newProjectPage.setDescription(NEWPROJECT_DESCRIPTION);
                this.mainPage.setNewProjectPage(this.newProjectPage);
                this.addPage((IWizardPage)this.newProjectPage);
            }
            return this.newProjectPage;
        }
        if (page == this.newProjectPage) {
            if (this.recursivelyPage == null) {
                this.recursivelyPage = new TITANProjectImportRecursivelyPage(NEWPROJECT_WINDOWTITLE);
                this.recursivelyPage.setTitle(NEWPROJECT_TITLE);
                this.recursivelyPage.setDescription(NEWPROJECT_DESCRIPTION);
                this.addPage((IWizardPage)this.recursivelyPage);
            }
            return this.recursivelyPage;
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        if (this.newProjectPage == null) {
            return false;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        IProject newProject;
        URI targetLocation = null;
        if (!this.newProjectPage.useDefaults()) {
            targetLocation = this.newProjectPage.getLocationURI();
        }
        if ((newProject = GUIProjectImporter.createNewProject(this.newProjectPage.getProjectHandle(), this.mainPage.getInformation(), targetLocation)) == null) {
            IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
            if (description.isAutoBuilding() != this.wasAutoBuilding) {
                description.setAutoBuilding(this.wasAutoBuilding);
                try {
                    ResourcesPlugin.getWorkspace().setDescription(description);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
            Activator.getDefault().resumeHandlingResourceChanges();
            return true;
        }
        try {
            TITANNature.addTITANBuilderToProject(newProject);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        ProjectFileHandler pfHandler = new ProjectFileHandler(newProject);
        pfHandler.saveProjectSettings();
        try {
            newProject.refreshLocal(2, null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        this.selectAndReveal((IResource)newProject);
        GUIProjectImporter.ProjectInformation information = this.mainPage.getInformation();
        List<GUIProjectImporter.IncludedProject> includedProjects = information.getIncludedProjects();
        if (!includedProjects.isEmpty() && (this.recursivelyPage == null || this.recursivelyPage.getRecursiveImport())) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            ArrayList<String> processedProjectFiles = new ArrayList<String>();
            processedProjectFiles.add(information.getSourceFile());
            ArrayList<IPath> projectFilesToBeProcessed = new ArrayList<IPath>();
            for (GUIProjectImporter.IncludedProject includedProject : includedProjects) {
                IPath temp = includedProject.getAbsolutePath();
                if (temp == null) continue;
                projectFilesToBeProcessed.add(temp);
            }
            while (!projectFilesToBeProcessed.isEmpty()) {
                IPath tempPath = (IPath)projectFilesToBeProcessed.remove(projectFilesToBeProcessed.size() - 1);
                if (processedProjectFiles.contains(tempPath.toOSString())) continue;
                GUIProjectImporter importer = new GUIProjectImporter();
                GUIProjectImporter.ProjectInformation tempProjectInformation = importer.loadProjectFile(tempPath.toOSString(), null, false);
                IPath tempPath2 = tempPath.removeFileExtension();
                String includedProjectName = tempPath2.lastSegment();
                IProject tempProject = workspace.getRoot().getProject(includedProjectName);
                if (tempProject.exists() || (tempProject = GUIProjectImporter.createNewProject(tempProject, tempProjectInformation, targetLocation)) == null) continue;
                try {
                    TITANNature.addTITANBuilderToProject(tempProject);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
                pfHandler = new ProjectFileHandler(tempProject);
                pfHandler.saveProjectSettings();
                try {
                    tempProject.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
                includedProjects = tempProjectInformation.getIncludedProjects();
                for (GUIProjectImporter.IncludedProject includedProject : includedProjects) {
                    IPath temp = includedProject.getAbsolutePath();
                    if (temp == null) continue;
                    projectFilesToBeProcessed.add(temp);
                }
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkspaceDescription description;
                PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn(null, (IAdaptable)newProject, (String)"org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage", null, null);
                if (dialog != null) {
                    dialog.open();
                }
                if ((description = ResourcesPlugin.getWorkspace().getDescription()).isAutoBuilding() != TITANProjectImportWizard.this.wasAutoBuilding) {
                    description.setAutoBuilding(TITANProjectImportWizard.this.wasAutoBuilding);
                    try {
                        ResourcesPlugin.getWorkspace().setDescription(description);
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                    }
                }
                Activator.getDefault().resumeHandlingResourceChanges();
            }
        });
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(NEWPROJECT_WINDOWTITLE);
        super.init(workbench, selection);
    }
}

