/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.properties.data.MakefileCreationData;
import org.eclipse.titan.designer.properties.data.ProjectDocumentHandlingUtility;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titan.designer.samples.SampleProject;
import org.eclipse.titan.designer.wizards.NewTITANProjectContentPage;
import org.eclipse.titan.designer.wizards.NewTITANProjectCreationPage;
import org.eclipse.titan.designer.wizards.NewTITANProjectOptionsWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public final class NewTITANProjectWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    public static final String NEWTITANPROJECTWIZARD = "org.eclipse.titan.designer.wizards.NewTITANProjectWizard";
    private NewTITANProjectCreationPage mainPage;
    private NewTITANProjectOptionsWizardPage optionsPage;
    private NewTITANProjectContentPage contentPage;
    private IProject newProject;
    private static final String NEWPROJECT_WINDOWTITLE = "New TITAN Project";
    private static final String NEWPROJECT_TITLE = "Create a TITAN Project";
    private static final String NEWPROJECT_DESCRIPTION = "Create a new TITAN project in the workspace or in an external location";
    private static final String CREATING_PROJECT = "creating project";
    private static final String CREATION_FAILED = "Project creation failed";
    private static final String TRUE = "true";
    private boolean wasAutoBuilding;
    private boolean isCreated;
    private IConfigurationElement config;

    public NewTITANProjectWizard() {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        this.wasAutoBuilding = description.isAutoBuilding();
        description.setAutoBuilding(false);
        try {
            ResourcesPlugin.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        Activator.getDefault().pauseHandlingResourceChanges();
        this.isCreated = false;
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new NewTITANProjectCreationPage(NEWPROJECT_WINDOWTITLE);
        this.mainPage.setTitle(NEWPROJECT_TITLE);
        this.mainPage.setDescription(NEWPROJECT_DESCRIPTION);
        this.addPage((IWizardPage)this.mainPage);
        this.optionsPage = new NewTITANProjectOptionsWizardPage();
        this.addPage((IWizardPage)this.optionsPage);
        this.contentPage = new NewTITANProjectContentPage();
        this.addPage((IWizardPage)this.contentPage);
    }

    IPath getProjectPath() {
        IPath path = this.mainPage.getLocationPath();
        String name = this.mainPage.getProjectName();
        return path.append(name);
    }

    private IProject createNewProject() {
        IProject tempProjectHandle = this.mainPage.getProjectHandle();
        URI location = null;
        if (!this.mainPage.useDefaults()) {
            location = this.mainPage.getLocationURI();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String tempExecutableName = tempProjectHandle.getName();
        final IProject newProjectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(tempExecutableName);
        final IProjectDescription description = workspace.newProjectDescription(tempExecutableName);
        description.setLocationURI(location);
        TITANNature.addTITANNatureToProject(description);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewTITANProjectWizard.this.createProject(description, newProjectHandle, monitor);
                String sourceFolder = NewTITANProjectWizard.this.optionsPage.getSourceFolder();
                if (!"".equals(sourceFolder)) {
                    SampleProject sample;
                    IFolder folder = newProjectHandle.getFolder(sourceFolder);
                    if (!folder.exists()) {
                        try {
                            folder.create(true, true, null);
                        }
                        catch (CoreException e) {
                            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                        }
                    }
                    if ((sample = NewTITANProjectWizard.this.contentPage.getSampleProject()) != null) {
                        sample.setupProject(newProjectHandle.getProject(), folder);
                        ProjectFileHandler pfHandler = new ProjectFileHandler(newProjectHandle.getProject());
                        pfHandler.saveProjectSettings();
                    }
                    if (NewTITANProjectWizard.this.optionsPage.isExcludeFromBuildSelected()) {
                        folder.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "excludeFromBuild"), NewTITANProjectWizard.TRUE);
                    }
                }
                newProjectHandle.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "generateMakefile"), NewTITANProjectWizard.TRUE);
                newProjectHandle.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "TTCN3preprocessor"), "cpp");
                newProjectHandle.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "C/C++ compiler"), "g++");
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t != null) {
                ErrorReporter.parallelErrorDisplayInMessageDialog((String)CREATION_FAILED, (String)t.getMessage());
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)101);
        try {
            progress.setTaskName(CREATING_PROJECT);
            projectHandle.create(description, (IProgressMonitor)progress.newChild(50));
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)progress.newChild(50));
            projectHandle.refreshLocal(1, (IProgressMonitor)progress.newChild(1));
            this.isCreated = true;
        }
        finally {
            progress.done();
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(NEWPROJECT_WINDOWTITLE);
    }

    public boolean performFinish() {
        if (!this.isCreated) {
            this.createNewProject();
        }
        if (this.newProject == null) {
            IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
            if (description.isAutoBuilding() != this.wasAutoBuilding) {
                description.setAutoBuilding(this.wasAutoBuilding);
                try {
                    ResourcesPlugin.getWorkspace().setDescription(description);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                }
            }
            Activator.getDefault().resumeHandlingResourceChanges();
            return false;
        }
        try {
            TITANNature.addTITANBuilderToProject(this.newProject);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        try {
            this.newProject.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "workingDir"), this.optionsPage.getWorkingFolder());
            String executable = MakefileCreationData.getDefaultTargetExecutableName(this.newProject);
            this.newProject.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"), executable);
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        ProjectDocumentHandlingUtility.createDocument(this.newProject);
        ProjectFileHandler pfHandler = new ProjectFileHandler(this.newProject);
        WorkspaceJob job = pfHandler.saveProjectSettingsJob();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        try {
            this.newProject.refreshLocal(2, null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        if (description.isAutoBuilding() != this.wasAutoBuilding) {
            description.setAutoBuilding(this.wasAutoBuilding);
            try {
                ResourcesPlugin.getWorkspace().setDescription(description);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
        Activator.getDefault().resumeHandlingResourceChanges();
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        this.selectAndReveal((IResource)this.newProject);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkspaceDescription description;
                PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn(null, (IAdaptable)NewTITANProjectWizard.this.newProject, (String)"org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage", null, null);
                if (dialog != null) {
                    dialog.open();
                }
                if ((description = ResourcesPlugin.getWorkspace().getDescription()).isAutoBuilding() != NewTITANProjectWizard.this.wasAutoBuilding) {
                    description.setAutoBuilding(NewTITANProjectWizard.this.wasAutoBuilding);
                    try {
                        ResourcesPlugin.getWorkspace().setDescription(description);
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                    }
                }
                Activator.getDefault().resumeHandlingResourceChanges();
            }
        });
        return true;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.config = config;
    }
}

