/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.properties.data.TITANFlagsOptionsData;
import org.eclipse.titan.designer.properties.pages.IOptionsPage;
import org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage;

public final class TITANFlagsOptionsPage
implements IOptionsPage {
    private Composite mainComposite;
    private Button disableBER;
    private Button disableRAW;
    private Button disableTEXT;
    private Button disableXER;
    private Button disableJSON;
    private Button forceXER;
    private Button disableSubtypeChecking;
    private Button defaultAsOmit;
    private Button forceOldFuncOutPar;
    private Button gccMessageFormat;
    private Button lineNumbersOnlyInMessages;
    private Button includeSourceInfo;
    private Button addSourceLineInfo;
    private Button suppressWarnings;
    private Button quietly;
    private Button omitInValueList;
    private Button warningsForBadVariants;

    @Override
    public void dispose() {
        if (this.mainComposite != null) {
            this.mainComposite.dispose();
            this.mainComposite = null;
            this.disableBER.dispose();
            this.disableRAW.dispose();
            this.disableTEXT.dispose();
            this.disableXER.dispose();
            this.disableJSON.dispose();
            this.forceXER.dispose();
            this.disableSubtypeChecking.dispose();
            this.defaultAsOmit.dispose();
            this.forceOldFuncOutPar.dispose();
            this.gccMessageFormat.dispose();
            this.lineNumbersOnlyInMessages.dispose();
            this.includeSourceInfo.dispose();
            this.addSourceLineInfo.dispose();
            this.suppressWarnings.dispose();
            this.quietly.dispose();
            this.omitInValueList.dispose();
            this.warningsForBadVariants.dispose();
        }
    }

    @Override
    public Composite createContents(Composite parent) {
        if (this.mainComposite != null) {
            return this.mainComposite;
        }
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayout((Layout)new GridLayout());
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.disableBER = new Button(this.mainComposite, 32);
        this.disableBER.setText("Disable BER encoding (-b)");
        this.disableRAW = new Button(this.mainComposite, 32);
        this.disableRAW.setText("Disable RAW encoding (-r)");
        this.disableTEXT = new Button(this.mainComposite, 32);
        this.disableTEXT.setText("Disable TEXT encoding (-x)");
        this.disableXER = new Button(this.mainComposite, 32);
        this.disableXER.setText("Disable XER encoding (-X)");
        this.disableJSON = new Button(this.mainComposite, 32);
        this.disableJSON.setText("Disable JSON encoder (-j)");
        this.forceXER = new Button(this.mainComposite, 32);
        this.forceXER.setText("Force XER in ASN.1 files (-a)");
        this.disableSubtypeChecking = new Button(this.mainComposite, 32);
        this.disableSubtypeChecking.setText("Disable subtype checking (-y)");
        this.defaultAsOmit = new Button(this.mainComposite, 32);
        this.defaultAsOmit.setText("Treat default fields as omit (-d)");
        this.forceOldFuncOutPar = new Button(this.mainComposite, 32);
        this.forceOldFuncOutPar.setText("Force old function out par handling (-Y)");
        this.gccMessageFormat = new Button(this.mainComposite, 32);
        this.gccMessageFormat.setText("Emulate gcc error/warning message format (-g)");
        this.lineNumbersOnlyInMessages = new Button(this.mainComposite, 32);
        this.lineNumbersOnlyInMessages.setText("Use only line numbers in error/warning messages (-i)");
        this.includeSourceInfo = new Button(this.mainComposite, 32);
        this.includeSourceInfo.setText("Include source line info in C++ code (-l)");
        this.addSourceLineInfo = new Button(this.mainComposite, 32);
        this.addSourceLineInfo.setText("Add source line info for logging (-L)");
        this.suppressWarnings = new Button(this.mainComposite, 32);
        this.suppressWarnings.setText("Suppress warnings (-w)");
        this.quietly = new Button(this.mainComposite, 32);
        this.quietly.setText("Suppress all messages (quiet mode) (-q)");
        this.omitInValueList = new Button(this.mainComposite, 32);
        this.omitInValueList.setText("Allow 'omit' in template value lists (legacy behavior) (-M)");
        this.warningsForBadVariants = new Button(this.mainComposite, 32);
        this.warningsForBadVariants.setText("Display warnings instead of errors for invalid variants (-E)");
        return this.mainComposite;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.mainComposite == null) {
            return;
        }
        this.disableBER.setEnabled(enabled);
        this.disableRAW.setEnabled(enabled);
        this.disableTEXT.setEnabled(enabled);
        this.disableXER.setEnabled(enabled);
        this.disableJSON.setEnabled(enabled);
        this.forceXER.setEnabled(enabled);
        this.disableSubtypeChecking.setEnabled(enabled);
        this.defaultAsOmit.setEnabled(enabled);
        this.forceOldFuncOutPar.setEnabled(enabled);
        this.gccMessageFormat.setEnabled(enabled);
        this.lineNumbersOnlyInMessages.setEnabled(enabled);
        this.includeSourceInfo.setEnabled(enabled);
        this.addSourceLineInfo.setEnabled(enabled);
        this.suppressWarnings.setEnabled(enabled);
        this.quietly.setEnabled(enabled);
        this.omitInValueList.setEnabled(enabled);
        this.warningsForBadVariants.setEnabled(enabled);
    }

    @Override
    public void copyPropertyStore(IProject project, PreferenceStore tempStorage) {
        String temp = null;
        for (int i = 0; i < TITANFlagsOptionsData.PROPERTIES.length; ++i) {
            try {
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", TITANFlagsOptionsData.PROPERTIES[i]));
                if (temp == null) continue;
                tempStorage.setValue(TITANFlagsOptionsData.PROPERTIES[i], temp);
                continue;
            }
            catch (CoreException ce) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
            }
        }
    }

    @Override
    public boolean evaluatePropertyStore(IProject project, PreferenceStore tempStorage) {
        String actualValue = null;
        String copyValue = null;
        boolean result = false;
        for (int i = 0; i < TITANFlagsOptionsData.PROPERTIES.length; ++i) {
            try {
                actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", TITANFlagsOptionsData.PROPERTIES[i]));
                copyValue = tempStorage.getString(TITANFlagsOptionsData.PROPERTIES[i]);
                if (!(result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null)) continue;
                return true;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                result = true;
            }
        }
        return result;
    }

    @Override
    public void performDefaults() {
        if (this.mainComposite == null) {
            return;
        }
        this.setEnabled(true);
        this.disableBER.setSelection(false);
        this.disableRAW.setSelection(false);
        this.disableTEXT.setSelection(false);
        this.disableXER.setSelection(false);
        this.disableJSON.setSelection(false);
        this.forceXER.setSelection(false);
        this.disableSubtypeChecking.setSelection(false);
        this.defaultAsOmit.setSelection(false);
        this.forceOldFuncOutPar.setSelection(false);
        this.gccMessageFormat.setSelection(false);
        this.lineNumbersOnlyInMessages.setSelection(false);
        this.includeSourceInfo.setSelection(true);
        this.addSourceLineInfo.setSelection(true);
        this.suppressWarnings.setSelection(false);
        this.quietly.setSelection(false);
        this.omitInValueList.setSelection(false);
        this.warningsForBadVariants.setSelection(false);
    }

    @Override
    public boolean checkProperties(ProjectBuildPropertyPage page) {
        boolean xerDisabled = this.disableXER.getSelection();
        boolean xerOnASN1Forced = this.forceXER.getSelection();
        if (xerDisabled && xerOnASN1Forced) {
            page.setErrorMessage("Forcing XER in ASN.1 files and disabling XER are incompatible options.");
            return false;
        }
        return true;
    }

    @Override
    public void loadProperties(IProject project) {
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableBER"));
            this.disableBER.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableRAW"));
            this.disableRAW.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableTEXT"));
            this.disableTEXT.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableXER"));
            this.disableXER.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableJSON"));
            this.disableJSON.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "forceXERinASN.1"));
            this.forceXER.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disableSubtypeChecking"));
            this.disableSubtypeChecking.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "defaultasOmit"));
            this.defaultAsOmit.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "forceOldFuncOutParHandling"));
            this.forceOldFuncOutPar.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "gccMessageFormat"));
            this.gccMessageFormat.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "lineNumbersOnlyInMessages"));
            this.lineNumbersOnlyInMessages.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "includeSourceInfo"));
            this.includeSourceInfo.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "addSourceLineInfo"));
            if (temp == null) {
                this.addSourceLineInfo.setSelection(false);
            } else {
                this.addSourceLineInfo.setSelection("true".equals(temp));
            }
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "suppressWarnings"));
            this.suppressWarnings.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "quietly"));
            this.quietly.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "omitInValueList"));
            this.omitInValueList.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "warningsForBadVariants"));
            this.warningsForBadVariants.setSelection("true".equals(temp));
        }
        catch (CoreException e) {
            this.performDefaults();
        }
    }

    @Override
    public boolean saveProperties(IProject project) {
        try {
            this.setProperty(project, "disableBER", this.disableBER.getSelection() ? "true" : "false");
            this.setProperty(project, "disableRAW", this.disableRAW.getSelection() ? "true" : "false");
            this.setProperty(project, "disableTEXT", this.disableTEXT.getSelection() ? "true" : "false");
            this.setProperty(project, "disableXER", this.disableXER.getSelection() ? "true" : "false");
            this.setProperty(project, "disableJSON", this.disableJSON.getSelection() ? "true" : "false");
            this.setProperty(project, "forceXERinASN.1", this.forceXER.getSelection() ? "true" : "false");
            this.setProperty(project, "disableSubtypeChecking", this.disableSubtypeChecking.getSelection() ? "true" : "false");
            this.setProperty(project, "defaultasOmit", this.defaultAsOmit.getSelection() ? "true" : "false");
            this.setProperty(project, "forceOldFuncOutParHandling", this.forceOldFuncOutPar.getSelection() ? "true" : "false");
            this.setProperty(project, "gccMessageFormat", this.gccMessageFormat.getSelection() ? "true" : "false");
            this.setProperty(project, "lineNumbersOnlyInMessages", this.lineNumbersOnlyInMessages.getSelection() ? "true" : "false");
            this.setProperty(project, "includeSourceInfo", this.includeSourceInfo.getSelection() ? "true" : "false");
            this.setProperty(project, "addSourceLineInfo", this.addSourceLineInfo.getSelection() ? "true" : "false");
            this.setProperty(project, "suppressWarnings", this.suppressWarnings.getSelection() ? "true" : "false");
            this.setProperty(project, "quietly", this.quietly.getSelection() ? "true" : "false");
            this.setProperty(project, "omitInValueList", this.omitInValueList.getSelection() ? "true" : "false");
            this.setProperty(project, "warningsForBadVariants", this.warningsForBadVariants.getSelection() ? "true" : "false");
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        return true;
    }

    private void setProperty(IProject project, String name, String value) throws CoreException {
        QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", name);
        String oldValue = project.getPersistentProperty(qualifiedName);
        if (value != null && !value.equals(oldValue)) {
            project.setPersistentProperty(qualifiedName, value);
        }
    }
}

