/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.core.TITANBuilder;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.titan.designer.properties.data.ProjectDocumentHandlingUtility;
import org.eclipse.titan.designer.properties.pages.ConfigurationManagerControl;
import org.eclipse.titan.designer.wizards.projectFormat.TITANAutomaticProjectExporter;
import org.eclipse.ui.dialogs.PropertyPage;

public final class FileBuildPropertyPage
extends PropertyPage {
    private Composite pageComposite = null;
    private Label headLabel = null;
    private ConfigurationManagerControl configurationManager;
    private String firstConfiguration;
    private Button excludeFromBuildButton = null;
    private static final String EXCLUDE_DISPLAY_TEXT = "Excluded from build.";
    private IFile fileResource;
    private final PreferenceStore tempStore = new PreferenceStore();

    public void dispose() {
        this.pageComposite.dispose();
        this.headLabel.dispose();
        super.dispose();
    }

    public void changeConfiguration(String configuration) {
        this.configurationManager.changeActualConfiguration();
        this.loadProperties();
        PropertyNotificationManager.firePropertyChange((IResource)this.fileResource.getProject());
    }

    protected Control createContents(Composite parent) {
        this.fileResource = (IFile)this.getElement();
        try {
            String temp = this.fileResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.File", "excludeFromBuild"));
            this.tempStore.setValue("excludeFromBuild", "true".equals(temp) ? "true" : "false");
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        this.pageComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.pageComposite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        this.pageComposite.setLayoutData((Object)data);
        if (TITANBuilder.isBuilderEnabled(this.fileResource.getProject())) {
            this.headLabel = new Label(this.pageComposite, 0);
            this.headLabel.setText("This TITAN project has the TITAN builder enabled.");
        } else {
            this.headLabel = new Label(this.pageComposite, 0);
            this.headLabel.setText("This TITAN project has the TITAN builder disabled.");
        }
        this.configurationManager = new ConfigurationManagerControl(this.pageComposite, this.fileResource.getProject());
        this.configurationManager.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FileBuildPropertyPage.this.configurationManager.hasConfigurationChanged()) {
                    FileBuildPropertyPage.this.changeConfiguration(FileBuildPropertyPage.this.configurationManager.getActualSelection());
                }
            }
        });
        this.firstConfiguration = this.configurationManager.getActualSelection();
        this.excludeFromBuildButton = new Button(this.pageComposite, 32);
        this.excludeFromBuildButton.setText(EXCLUDE_DISPLAY_TEXT);
        this.excludeFromBuildButton.setEnabled(true);
        try {
            String mode = this.fileResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.File", "excludeFromBuild"));
            this.excludeFromBuildButton.setSelection("true".equals(mode));
            if (mode == null) {
                this.fileResource.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.File", "excludeFromBuild"), "false");
            }
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        return null;
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            return;
        }
        if (this.configurationManager != null) {
            this.configurationManager.refresh();
        }
        super.setVisible(visible);
    }

    protected void performDefaults() {
        this.excludeFromBuildButton.setSelection(false);
        this.configurationManager.saveActualConfiguration();
    }

    public boolean performCancel() {
        this.configurationManager.clearActualConfiguration();
        this.loadProperties();
        return super.performCancel();
    }

    public boolean performOk() {
        IProject project = this.fileResource.getProject();
        try {
            boolean configurationChanged;
            String tempString = this.excludeFromBuildButton.getSelection() ? "true" : "false";
            this.fileResource.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.File", "excludeFromBuild"), tempString);
            boolean bl = configurationChanged = !this.firstConfiguration.equals(this.configurationManager.getActualSelection());
            if (configurationChanged || !tempString.equals(this.tempStore.getString("excludeFromBuild"))) {
                this.tempStore.setValue("excludeFromBuild", "true".equals(tempString) ? "true" : "false");
                this.configurationManager.saveActualConfiguration();
                ProjectDocumentHandlingUtility.saveDocument(project);
                TITANAutomaticProjectExporter.saveAllAutomatically(project);
                MarkerHandler.markAllMarkersForRemoval((IResource)this.fileResource);
                PropertyNotificationManager.firePropertyChange((IResource)this.fileResource);
            }
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
            return false;
        }
        return true;
    }

    private void loadProperties() {
        try {
            String temp = this.fileResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.File", "excludeFromBuild"));
            this.excludeFromBuildButton.setSelection("true".equals(temp));
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
    }
}

