/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titan.designer.Activator;

public abstract class SubscribedObject<T> {
    protected final String qualifier;
    protected final String key;
    protected final T defaultValue;
    protected T currentValue;

    protected SubscribedObject(String qualifier, String key, T defaultValue) {
        this.qualifier = qualifier;
        this.key = key;
        this.defaultValue = defaultValue;
        this.subscribe();
    }

    public T getValue() {
        return this.currentValue;
    }

    public void setValue(T newValue) {
        if (this.currentValue != newValue) {
            this.storeNewValue(newValue);
            this.currentValue = newValue;
        }
    }

    private void subscribe() {
        this.handleChange(Platform.getPreferencesService());
        Activator activator = Activator.getDefault();
        if (activator != null) {
            activator.getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if (SubscribedObject.this.key.equals(property)) {
                        SubscribedObject.this.handleChange(Platform.getPreferencesService());
                        return;
                    }
                }
            });
        }
    }

    protected abstract void handleChange(IPreferencesService var1);

    protected abstract void storeNewValue(T var1);
}

