/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.editors.GlobalIntervalHandler;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3FoldingSupport;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectConfigurationParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.ui.progress.IProgressConstants;

public final class ReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    public static final String OUTLINEUPDATE = "Outline update";
    public static final String FOLDING_UPDATE = "Folding update";
    private final TTCN3Editor editor;
    private IDocument document;
    private StringBuilder actualCode;
    private String[] delimeters;
    private WorkspaceJob lastIncrementalSyntaxCheck = null;

    public ReconcilingStrategy(TTCN3Editor editor) {
        this.editor = editor;
    }

    TTCN3Editor getEditor() {
        return this.editor;
    }

    private IDocument getDocument() {
        return this.document;
    }

    public void setDocument(IDocument document) {
        this.document = document;
        this.actualCode = new StringBuilder(document.get());
        this.delimeters = this.editor.getDocument().getLegalLineDelimiters();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        if ("__insert".equals(dirtyRegion.getType())) {
            this.actualCode.insert(dirtyRegion.getOffset(), dirtyRegion.getText());
        } else {
            this.actualCode.delete(dirtyRegion.getOffset(), dirtyRegion.getOffset() + dirtyRegion.getLength());
        }
        if (dirtyRegion.getOffset() == 0 && this.editor != null && this.document.getLength() == dirtyRegion.getLength()) {
            if (!this.editor.isDirty()) {
                return;
            }
            IPreferencesService prefs = Platform.getPreferencesService();
            if (prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", true, null)) {
                this.analyze(false);
            }
            return;
        }
    }

    public void reconcileSyntax(DirtyRegion dirtyRegion) {
        int firstLine;
        double parserStart = System.nanoTime();
        if (this.document == null) {
            return;
        }
        int lineBreaks = 0;
        try {
            if ("__insert".equals(dirtyRegion.getType())) {
                lineBreaks = ReconcilingStrategy.calculateLineBreaks(dirtyRegion.getText(), this.delimeters);
                this.actualCode.insert(dirtyRegion.getOffset(), dirtyRegion.getText());
            } else {
                lineBreaks = ReconcilingStrategy.calculateLineBreaks(this.actualCode.substring(dirtyRegion.getOffset(), dirtyRegion.getOffset() + dirtyRegion.getLength()), this.delimeters);
                this.actualCode.delete(dirtyRegion.getOffset(), dirtyRegion.getOffset() + dirtyRegion.getLength());
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            ErrorReporter.logError((String)("String length: " + this.actualCode.length() + " region type: " + dirtyRegion.getType() + " region offset: " + dirtyRegion.getOffset() + " region length: " + dirtyRegion.getLength() + " region text: '" + dirtyRegion.getText() + "'\n" + "Actual size of the document: " + this.document.get().length()));
            this.actualCode = new StringBuilder(this.document.get());
        }
        if (dirtyRegion.getOffset() == 0 && this.editor != null && this.document.getLength() == dirtyRegion.getLength()) {
            if (!this.editor.isDirty()) {
                return;
            }
            IPreferencesService prefs = Platform.getPreferencesService();
            if (prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", true, null)) {
                this.analyze(false);
            }
            return;
        }
        try {
            firstLine = this.document.getLineOfOffset(dirtyRegion.getOffset());
        }
        catch (BadLocationException e) {
            ErrorReporter.logWarningExceptionStackTrace((Exception)((Object)e));
            ErrorReporter.logWarning((String)("Offset became invalid, fallback method used. Document length: " + this.document.getLength() + " region offset: " + dirtyRegion.getOffset()));
            firstLine = 0;
        }
        IFile editedFile = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        if (editedFile == null || ResourceExclusionHelper.isExcluded((IResource)editedFile)) {
            return;
        }
        int length = dirtyRegion.getLength();
        TTCN3ReparseUpdater reparser = "__remove".equals(dirtyRegion.getType()) ? new TTCN3ReparseUpdater(editedFile, this.actualCode.toString(), firstLine + 1, -1 * lineBreaks, dirtyRegion.getOffset(), dirtyRegion.getOffset() + length, -1 * length) : new TTCN3ReparseUpdater(editedFile, this.actualCode.toString(), firstLine + 1, lineBreaks, dirtyRegion.getOffset(), dirtyRegion.getOffset(), length);
        IProject project = editedFile.getProject();
        if (project == null) {
            return;
        }
        if (this.lastIncrementalSyntaxCheck != null) {
            try {
                this.lastIncrementalSyntaxCheck.join();
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser(project);
        this.lastIncrementalSyntaxCheck = sourceParser.updateSyntax(editedFile, reparser);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (store.getBoolean("org.eclipse.titan.designer.displayDebugInformation")) {
            TITANDebugConsole.println("Refreshing the syntax took " + ((double)System.nanoTime() - parserStart) * 1.0E-9 + " secs");
        }
        WorkspaceJob op = new WorkspaceJob(FOLDING_UPDATE){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ReconcilingStrategy.this.lastIncrementalSyntaxCheck != null) {
                            try {
                                ReconcilingStrategy.this.lastIncrementalSyntaxCheck.join();
                            }
                            catch (InterruptedException e) {
                                ErrorReporter.logExceptionStackTrace((Exception)e);
                            }
                        }
                        List<Position> positions = new TTCN3FoldingSupport().calculatePositions(ReconcilingStrategy.this.getDocument());
                        ReconcilingStrategy.this.getEditor().updateFoldingStructure(positions);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        op.setPriority(30);
        op.setSystem(true);
        op.setUser(false);
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.setRule((ISchedulingRule)editedFile);
        op.schedule();
    }

    public void reconcileSemantics() {
        IProject project;
        final IFile editedFile = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        if (editedFile == null || ResourceExclusionHelper.isExcluded((IResource)editedFile)) {
            return;
        }
        WorkspaceJob tempLastIncrementalSyntaxCheck = this.lastIncrementalSyntaxCheck;
        if (tempLastIncrementalSyntaxCheck != null) {
            try {
                tempLastIncrementalSyntaxCheck.join();
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
        }
        if ((project = editedFile.getProject()) == null) {
            return;
        }
        TITANDebugConsole.println("Reconciling semantics at " + System.nanoTime() + " time.");
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser(project);
        sourceParser.analyzeAll();
        WorkspaceJob op = new WorkspaceJob(OUTLINEUPDATE){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!MarkerHandler.hasMarker("org.eclipse.titan.designer.ontheflySyntacticMarker", (IResource)editedFile)) {
                            ReconcilingStrategy.this.getEditor().refreshOutlinePage();
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        op.setPriority(30);
        op.setSystem(true);
        op.setUser(false);
        op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
        op.setRule((ISchedulingRule)project);
        op.schedule();
    }

    public void reconcile(IRegion partition) {
        this.fullReconciliation(false);
    }

    public void initialReconcile() {
        this.fullReconciliation(true);
    }

    private void fullReconciliation(boolean isInitial) {
        this.actualCode = new StringBuilder(this.document.get());
        GlobalIntervalHandler.putInterval(this.document, null);
        IPreferencesService prefs = Platform.getPreferencesService();
        if (prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", true, null)) {
            this.analyze(isInitial);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    List<Position> positions = new TTCN3FoldingSupport().calculatePositions(ReconcilingStrategy.this.getDocument());
                    ReconcilingStrategy.this.getEditor().updateFoldingStructure(positions);
                    IFile editedFile = (IFile)ReconcilingStrategy.this.editor.getEditorInput().getAdapter(IFile.class);
                    if (!MarkerHandler.hasMarker("org.eclipse.titan.designer.ontheflySyntacticMarker", (IResource)editedFile)) {
                        ReconcilingStrategy.this.getEditor().refreshOutlinePage();
                    }
                }
            });
        }
    }

    public void analyze(boolean isInitial) {
        final IFile editedFile = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        if (editedFile == null || ResourceExclusionHelper.isExcluded((IResource)editedFile)) {
            return;
        }
        IProject project = editedFile.getProject();
        if (project == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                List<Position> positions = new TTCN3FoldingSupport().calculatePositions(ReconcilingStrategy.this.getDocument());
                ReconcilingStrategy.this.getEditor().updateFoldingStructure(positions);
            }
        });
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(project);
        if (isInitial || !TTCN3Editor.isSemanticCheckingDelayed()) {
            boolean minimizeMemoryUsage = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.minimiseMemoryUsage", false, null);
            if (!isInitial || minimizeMemoryUsage) {
                projectSourceParser.reportOutdating(editedFile);
            }
            projectSourceParser.analyzeAll();
            ProjectConfigurationParser projectConfigurationParser = GlobalParser.getConfigSourceParser(project);
            projectConfigurationParser.analyzeAll();
            WorkspaceJob op = new WorkspaceJob(OUTLINEUPDATE){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!MarkerHandler.hasMarker("org.eclipse.titan.designer.ontheflySyntacticMarker", (IResource)editedFile)) {
                                ReconcilingStrategy.this.getEditor().updateOutlinePage();
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            op.setPriority(30);
            op.setSystem(true);
            op.setUser(false);
            op.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
            op.setRule((ISchedulingRule)project);
            op.schedule();
        } else {
            projectSourceParser.reportSyntacticOutdatingOnly(editedFile);
            projectSourceParser.analyzeAllOnlySyntactically();
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    public static int calculateLineBreaks(String text, String[] legalLineDelimiters) {
        if (text == null || text.length() == 0) {
            return 0;
        }
        int lineBreaks = 0;
        int actualIndex = 0;
        while (actualIndex >= 0) {
            int nextIndex = -1;
            int tempIndex = -1;
            int delimeterLength = -1;
            for (int i = 0; i < legalLineDelimiters.length; ++i) {
                tempIndex = text.indexOf(legalLineDelimiters[i], actualIndex);
                if (tempIndex < 0) continue;
                if (nextIndex == -1) {
                    nextIndex = tempIndex;
                    delimeterLength = legalLineDelimiters[i].length();
                    continue;
                }
                if (tempIndex < nextIndex) {
                    nextIndex = tempIndex;
                    delimeterLength = legalLineDelimiters[i].length();
                    continue;
                }
                if (tempIndex != nextIndex) continue;
                delimeterLength = Math.max(delimeterLength, legalLineDelimiters[i].length());
            }
            if (nextIndex >= 0) {
                actualIndex = nextIndex + delimeterLength;
                ++lineBreaks;
                continue;
            }
            actualIndex = -1;
        }
        return lineBreaks;
    }
}

