/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.referenceSearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search.ui.text.MatchEvent;
import org.eclipse.search.ui.text.RemoveAllEvent;
import org.eclipse.titan.designer.editors.referenceSearch.ReferenceSearchResult;
import org.eclipse.titan.designer.editors.referenceSearch.ReferenceSearchResultView;

public final class ReferenceSearchContentProvider
implements ITreeContentProvider {
    private HashMap<IResource, ArrayList<IResource>> tree = new HashMap();
    private SearchResultListener searchResultListener = new SearchResultListener();
    private ReferenceSearchResult result;
    private ReferenceSearchResultView page;

    public ReferenceSearchContentProvider(ReferenceSearchResultView page) {
        if (page != null && page.getInput() != null) {
            this.page = page;
            this.setResult((ReferenceSearchResult)page.getInput());
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.tree = new HashMap();
        if (newInput instanceof ReferenceSearchResult) {
            this.setResult((ReferenceSearchResult)((Object)newInput));
        }
        if (newInput instanceof ReferenceSearchResultView) {
            this.page = (ReferenceSearchResultView)((Object)newInput);
        }
    }

    private void setResult(ReferenceSearchResult result) {
        this.tree = new HashMap();
        this.result = result;
        for (Object child : result.getElements()) {
            Object parent = this.getParent(child);
            while (parent != null && this.addTreeElement((IResource)parent, (IResource)child)) {
                child = parent;
                parent = this.getParent(parent);
            }
        }
        result.addListener(this.searchResultListener);
    }

    public List<IProject> getProjects() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        for (IResource resource : this.tree.keySet()) {
            if (!(resource instanceof IProject)) continue;
            result.add((IProject)resource);
        }
        return result;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ReferenceSearchResult) {
            return this.getProjects().toArray();
        }
        if (parentElement instanceof IFile) {
            return this.result.getMatches(parentElement);
        }
        if (parentElement instanceof IResource) {
            List result = this.tree.get(parentElement);
            return result == null ? new Object[]{} : result.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        if (element instanceof Match) {
            ((Match)element).getElement();
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IFile) {
            return this.result.getMatchCount(element) > 0;
        }
        return this.tree.get(element) != null;
    }

    public void removeAll() {
        this.result.removeAll();
    }

    private boolean addTreeElement(IResource parent, IResource child) {
        ArrayList<Object> children = this.tree.get(parent);
        if (children == null) {
            children = new ArrayList();
            children.add(child);
            this.tree.put(parent, children);
            return true;
        }
        if (!children.contains(child)) {
            children.add(child);
            return true;
        }
        return false;
    }

    protected ReferenceSearchResultView getPage() {
        return this.page;
    }

    private class SearchResultListener
    implements ISearchResultListener {
        private SearchResultListener() {
        }

        public void searchResultChanged(SearchResultEvent e) {
            if (e instanceof RemoveAllEvent) {
                ReferenceSearchContentProvider.this.tree.clear();
                return;
            }
            if (!(e instanceof MatchEvent)) {
                return;
            }
            MatchEvent event = (MatchEvent)e;
            switch (event.getKind()) {
                case 1: {
                    for (Match match : event.getMatches()) {
                        Object child = match.getElement();
                        Object parent = ReferenceSearchContentProvider.this.getParent(child);
                        while (parent != null && ReferenceSearchContentProvider.this.addTreeElement((IResource)parent, (IResource)child)) {
                            child = parent;
                            parent = ReferenceSearchContentProvider.this.getParent(parent);
                        }
                    }
                    break;
                }
                case 2: {
                    block6: for (Match match : event.getMatches()) {
                        Object child = match.getElement();
                        if (ReferenceSearchContentProvider.this.getChildren(child).length != 0) {
                            return;
                        }
                        Object parent = ReferenceSearchContentProvider.this.getParent(child);
                        while (parent != null) {
                            List children = (List)ReferenceSearchContentProvider.this.tree.get(parent);
                            if (children != null) {
                                children.remove(child);
                                if (!children.isEmpty()) continue block6;
                            }
                            ReferenceSearchContentProvider.this.tree.remove(parent);
                            child = ReferenceSearchContentProvider.this.getParent(child);
                            parent = ReferenceSearchContentProvider.this.getParent(parent);
                        }
                    }
                    break;
                }
            }
        }
    }
}

